/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.processors;

import com.igormaznitsa.meta.checker.Context;
import com.igormaznitsa.meta.checker.processors.AbstractMetaAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.commons.jexl2.JexlEngine;

public final class Constraint
extends AbstractMetaAnnotationProcessor {
    private final JexlEngine JEXL = new JexlEngine();
    static final Pattern ARG_SEARCHER = Pattern.compile(".*?(?:\\b|\\s)X(\\b|\\s).*?", 2);

    @Override
    protected void doProcessing(Context context, JavaClass clazz, ElementType type, ParameterAnnotationEntry pae, AnnotationEntry ae) {
        String text = Constraint.extractStrValue("value", ae, "");
        try {
            if (!ARG_SEARCHER.matcher(this.JEXL.createExpression(text).dump()).matches()) {
                context.error(String.format("can't detect 'X' at constraint expression '%s'", text), true);
            }
        }
        catch (Throwable thr) {
            context.error(String.format("wrong constraint expression '%s'", text), true);
        }
    }

    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return com.igormaznitsa.meta.annotation.Constraint.class;
    }
}

