/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.processors;

import com.igormaznitsa.meta.checker.Context;
import com.igormaznitsa.meta.checker.Utils;
import com.igormaznitsa.meta.checker.processors.AbstractMetaAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.ParameterAnnotationEntry;

public class MustNotContainNull
extends AbstractMetaAnnotationProcessor {
    @Override
    protected void doProcessing(Context context, JavaClass clazz, ElementType type, ParameterAnnotationEntry pae, AnnotationEntry ae) {
        boolean error = false;
        String name = "";
        switch (type) {
            case FIELD: {
                Field method = (Field)context.getNode();
                error = !Utils.isObjectType(method.getType());
                name = "a non-object field";
                break;
            }
            case PARAMETER: {
                Method method = (Method)context.getNode();
                error = !Utils.isObjectType(method.getArgumentTypes()[context.getItemIndex()]);
                name = "a non-object parameter";
                break;
            }
            case METHOD: {
                Method method = (Method)context.getNode();
                error = !Utils.isObjectType(method.getReturnType());
                name = "the non-object result";
                break;
            }
            default: {
                throw new Error("Unexpected item type [" + (Object)((Object)type) + ']');
            }
        }
        if (error) {
            context.error(name + " is marked by @" + this.getAnnotationClass().getName(), true);
        }
    }

    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return com.igormaznitsa.meta.annotation.MustNotContainNull.class;
    }
}

