/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.processors;

import com.igormaznitsa.meta.Complexity;
import com.igormaznitsa.meta.checker.Context;
import com.igormaznitsa.meta.checker.processors.AbstractMetaAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.ParameterAnnotationEntry;

public class TimeComplexity
extends AbstractMetaAnnotationProcessor {
    @Override
    protected void doProcessing(Context context, JavaClass clazz, ElementType type, ParameterAnnotationEntry pae, AnnotationEntry ae) {
        ElementValue element = TimeComplexity.extractValue("value", ae);
        if (element == null) {
            context.error("Can't find value int " + this.getAnnotationClass().getCanonicalName() + " annotation", true);
        } else {
            try {
                Complexity unit = Complexity.valueOf((String)element.stringifyValue());
                Complexity maxAllowed = context.getMaxAllowedTimeComplexity();
                if (maxAllowed != null && unit.ordinal() > maxAllowed.ordinal()) {
                    context.error("Detected violation for time complexity : " + unit.name(), true);
                }
            }
            catch (Exception ex) {
                context.error("Can't get information about complexity from annotation " + this.getAnnotationClass().getCanonicalName() + " [" + element.stringifyValue() + "]", true);
            }
        }
    }

    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return com.igormaznitsa.meta.annotation.TimeComplexity.class;
    }
}

