/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.checker.processors;

import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.checker.Context;
import com.igormaznitsa.meta.checker.processors.AbstractMetaAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.ParameterAnnotationEntry;

public class Weight
extends AbstractMetaAnnotationProcessor {
    @Override
    protected void doProcessing(Context context, JavaClass clazz, ElementType type, ParameterAnnotationEntry pae, AnnotationEntry ae) {
        ElementValue element = Weight.extractValue("value", ae);
        if (element == null) {
            context.error("Can't find unit for " + this.getAnnotationClass().getCanonicalName() + " annotation", true);
        } else {
            try {
                Weight.Unit unit = Weight.Unit.valueOf((String)element.stringifyValue());
                Weight.Unit maxAllowed = context.getMaxAllowedWeightLevel();
                if (maxAllowed == null) {
                    if (unit.ordinal() >= Weight.Unit.EXTRAHARD.ordinal()) {
                        context.warning("has weight " + unit.name(), true);
                    }
                } else if (unit.ordinal() > maxAllowed.ordinal()) {
                    context.error("Detected violation of max weight rule : " + unit.name(), true);
                }
            }
            catch (Exception ex) {
                context.error("Can't get information about unit from annotation " + this.getAnnotationClass().getCanonicalName() + " [" + element.stringifyValue() + "]", true);
            }
        }
    }

    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return com.igormaznitsa.meta.annotation.Weight.class;
    }
}

