/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.Weight;
import com.igormaznitsa.meta.common.utils.IOUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@Weight(value=Weight.Unit.VARIABLE)
@ThreadSafe
@Immutable
public class CallTrace
implements Serializable {
    private static final long serialVersionUID = -3908621401136825952L;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String EOL_LINUX = "\n";
    public static final String EOL_WINDOWS = "\r\n";
    private final boolean packed;
    private final byte[] stacktrace;
    private final String threadDescriptor;
    private final String eol;

    public CallTrace() {
        this(true, true, EOL_LINUX);
    }

    @Weight(value=Weight.Unit.VARIABLE, comment="Depends on the call stack depth")
    public CallTrace(boolean skipConstructors, boolean pack, @Nonnull String eol) {
        int index;
        this.eol = eol;
        this.threadDescriptor = Thread.currentThread().toString();
        StackTraceElement[] allElements = Thread.currentThread().getStackTrace();
        if (skipConstructors) {
            for (index = 1; index < allElements.length && "<init>".equals(allElements[index].getMethodName()); ++index) {
            }
        }
        StringBuilder buffer = new StringBuilder((allElements.length - index) * 32);
        while (index < allElements.length) {
            if (buffer.length() > 0) {
                buffer.append(eol);
            }
            buffer.append(allElements[index].toString());
            ++index;
        }
        this.packed = pack;
        this.stacktrace = pack ? IOUtils.packData(buffer.toString().getBytes(UTF8)) : buffer.toString().getBytes(UTF8);
    }

    @Nonnull
    public String getThreadDescriptor() {
        return this.threadDescriptor;
    }

    @Nonnull
    public String restoreStackTrace() {
        return "THREAD_ID : " + this.threadDescriptor + this.eol + new String(this.packed ? IOUtils.unpackData(this.stacktrace) : this.stacktrace, UTF8);
    }

    public String toString() {
        return this.restoreStackTrace();
    }
}

