/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.mvngolang.AbstractGolangMojo;
import com.igormaznitsa.mvngolang.utils.IOUtils;
import com.igormaznitsa.mvngolang.utils.MavenUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.zeroturnaround.zip.ZipUtil;

public abstract class AbstractGoDependencyAwareMojo
extends AbstractGolangMojo {
    private String extraGoPathSectionInOsFormat = "";
    @Parameter(name="scanDependencies", defaultValue="true")
    private boolean scanDependencies = true;
    @Parameter(name="includeTestDependencies", defaultValue="true")
    private boolean includeTestDependencies = true;
    @Parameter(name="dependencyTempFolder", defaultValue="${project.build.directory}${file.separator}.__deps__")
    private String dependencyTempFolder;

    @Nonnull
    public String getDependencyTempFolder() {
        return this.dependencyTempFolder;
    }

    public void setDependencyTempFolder(@Nonnull String path) {
        this.dependencyTempFolder = (String)Assertions.assertNotNull((Object)path);
    }

    public boolean isScanDependencies() {
        return this.scanDependencies;
    }

    public void setScanDependencies(boolean flag) {
        this.scanDependencies = flag;
    }

    public boolean isIncludeTestDependencies() {
        return this.includeTestDependencies;
    }

    public void setIncludeTestDependencies(boolean value) {
        this.includeTestDependencies = value;
    }

    @Override
    public final void doInit() throws MojoFailureException, MojoExecutionException {
        super.doInit();
        if (this.isScanDependencies()) {
            List<File> foundArtifacts;
            this.getLog().info((CharSequence)"Scanning maven dependencies");
            try {
                foundArtifacts = MavenUtils.scanForMvnGoArtifacts(this.getProject(), this.isIncludeTestDependencies(), this, this.getSession(), this.getExecution(), this.getArtifactResolver(), this.getRemoteRepositories());
            }
            catch (ArtifactResolverException ex) {
                throw new MojoFailureException("Can't resolve artifact", (Throwable)ex);
            }
            if (foundArtifacts.isEmpty()) {
                this.getLog().debug((CharSequence)"Mvn golang dependencies are not found");
                this.extraGoPathSectionInOsFormat = "";
            } else {
                this.getLog().debug((CharSequence)("Found mvn-golang artifactis: " + foundArtifacts));
                File dependencyTempTargetFolder = new File(this.getDependencyTempFolder());
                this.getLog().debug((CharSequence)("Depedencies will be unpacked into folder: " + dependencyTempTargetFolder));
                List<File> unpackedFolders = this.unpackArtifactsIntoFolder(foundArtifacts, dependencyTempTargetFolder);
                String preparedExtraPartForGoPath = IOUtils.makeOsFilePathWithoutDuplications(unpackedFolders.toArray(new File[0]));
                this.getLog().debug((CharSequence)("Prepared dependency path for GOPATH: " + preparedExtraPartForGoPath));
                this.extraGoPathSectionInOsFormat = preparedExtraPartForGoPath;
            }
        } else {
            this.getLog().info((CharSequence)"Maven dependency scanning is off");
        }
    }

    @Nonnull
    @MustNotContainNull
    private List<File> unpackArtifactsIntoFolder(@Nonnull @MustNotContainNull List<File> zippedArtifacts, @Nonnull File targetFolder) throws MojoExecutionException {
        ArrayList<File> resultFolders = new ArrayList<File>();
        if (!targetFolder.isDirectory() && !targetFolder.mkdirs()) {
            throw new MojoExecutionException("Can't create folder to unpack dependencies: " + targetFolder);
        }
        for (File zipFile : zippedArtifacts) {
            File outDir = new File(targetFolder, FilenameUtils.getBaseName((String)zipFile.getName()));
            if (outDir.isDirectory()) {
                this.getLog().debug((CharSequence)("Dependency already unpacked: " + outDir));
                resultFolders.add(outDir);
                continue;
            }
            try {
                this.getLog().debug((CharSequence)("Unpack dependency archive: " + zipFile));
                ZipUtil.unpack((File)zipFile, (File)outDir, (Charset)StandardCharsets.UTF_8);
                resultFolders.add(outDir);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Can't unpack dependency archive '" + zipFile.getName() + "' into folder '" + targetFolder + '\'', ex);
            }
        }
        return resultFolders;
    }

    @Override
    @Nonnull
    protected final String getSpecialPartOfGoPath() {
        return this.extraGoPathSectionInOsFormat;
    }
}

