/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvngolang.AbstractGoPackageAndDependencyAwareMojo;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GolangBuildMojo
extends AbstractGoPackageAndDependencyAwareMojo {
    @Parameter(name="resultFolder", defaultValue="${project.build.directory}")
    private String resultFolder;
    @Parameter(name="resultName", defaultValue="${project.build.finalName}")
    private String resultName;
    @Parameter(name="buildMode", defaultValue="default")
    private String buildMode;
    @Parameter(name="strip", defaultValue="false")
    private boolean strip;
    @Parameter(name="ldFlags")
    private String[] ldFlags;

    @Nonnull
    @MustNotContainNull
    public List<String> getLdflagsAsList() {
        return this.ldFlags == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(this.ldFlags));
    }

    public boolean isStrip() {
        return this.strip;
    }

    public void setStrip(boolean flag) {
        this.strip = flag;
    }

    @Nonnull
    public String getBuildMode() {
        return this.buildMode;
    }

    public void setBuilMode(@Nullable String buildMode) {
        this.buildMode = (String)GetUtils.ensureNonNull((Object)buildMode, (Object)"default");
    }

    @Nonnull
    private File getResultFile() {
        return new File(this.getResultFolder(), this.resultName);
    }

    @Nonnull
    public String getResultFolder() {
        return (String)Assertions.assertNotNull((Object)this.resultFolder);
    }

    @Nonnull
    public String getResultName() {
        return (String)Assertions.assertNotNull((Object)this.resultName);
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        return "build";
    }

    @Override
    public void beforeExecution(@Nullable ProxySettings proxySettings) throws MojoFailureException {
        File folder = new File(this.getResultFolder());
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new MojoFailureException("Can't create folder : " + folder);
        }
        if (this.isVerbose() || !"default".equals(this.buildMode)) {
            this.getLog().info((CharSequence)("Build mode : " + this.buildMode));
        }
    }

    @Override
    public void afterExecution(@Nullable ProxySettings proxySettings, boolean error) throws MojoFailureException {
        if (!error) {
            File resultFile = this.getResultFile();
            if (!resultFile.isFile()) {
                throw new MojoFailureException("Can't find generated target file : " + resultFile);
            }
            try {
                if (!resultFile.setExecutable(true)) {
                    this.getLog().warn((CharSequence)("Can't make result file executable : " + resultFile));
                }
            }
            catch (SecurityException ex) {
                this.getLog().warn((CharSequence)("Security exception during executable flag set : " + resultFile));
            }
            this.getLog().info((CharSequence)("The Result file has been successfuly created : " + resultFile));
        }
    }

    @Override
    public boolean isCommandSupportVerbose() {
        return true;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getCommandFlags() {
        ArrayList<String> flags = new ArrayList<String>();
        flags.add("-buildmode=" + this.buildMode);
        List<String> linkerflags = this.getLdflagsAsList();
        if (this.strip) {
            if (!linkerflags.contains("-s")) {
                linkerflags.add("-s");
            }
            if (!linkerflags.contains("-w")) {
                linkerflags.add("-w");
            }
        }
        if (!linkerflags.isEmpty()) {
            flags.add("-ldflags");
            StringBuilder buffer = new StringBuilder();
            for (String s : linkerflags) {
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                buffer.append(s);
            }
            flags.add(buffer.toString());
        }
        flags.add("-o");
        flags.add(this.getResultFile().getAbsolutePath());
        return flags.toArray(new String[flags.size()]);
    }
}

