/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvngolang.AbstractGoPackageAndDependencyAwareMojo;
import com.igormaznitsa.mvngolang.CustomScript;
import com.igormaznitsa.mvngolang.cvs.CVSType;
import com.igormaznitsa.mvngolang.utils.PackageList;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

@Mojo(name="get", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE)
public class GolangGetMojo
extends AbstractGoPackageAndDependencyAwareMojo {
    private static final Pattern PATTERN_NO_SUBMODULE_MAPPING_FOUND_IN_GIT = Pattern.compile("no\\s+submodule\\s+mapping\\s+found\\s+in\\s+.gitmodules for path\\s+\\'([\\S]+?)\\'", 10);
    private static final Pattern PATTERN_EXTRACT_PACKAGE_AND_STATUS = Pattern.compile("^package ([\\S]+?)\\s*:\\s*exit\\s+status\\s+([\\d]+?)\\s*$", 10);
    @Parameter(name="customScript")
    private CustomScript customScript;
    @Parameter(name="externalPackageFile", property="mvn.golang.get.packages.file")
    private String externalPackageFile;
    @Parameter(name="autofixGitCache", defaultValue="false")
    private boolean autofixGitCache;
    @Parameter(name="branch")
    private String branch;
    @Parameter(name="tag")
    private String tag;
    @Parameter(name="revision")
    private String revision;
    @Parameter(name="customCvsOptions")
    private String[] customCvsOptions;
    @Parameter(name="cvsExe")
    private String cvsExe;
    @Parameter(name="enforceDeletePackageFiles", defaultValue="false")
    private boolean enforceDeletePackageFiles;
    @Parameter(name="deleteCommonPkg", defaultValue="false")
    private boolean deleteCommonPkg;
    @Parameter(name="relativePathToCvsFolder")
    private String relativePathToCvsFolder;
    @Parameter(name="disableCvsAutosearch", defaultValue="false")
    private boolean disableCvsAutosearch;
    private List<PackageList.Package> integralPackageList;

    @Nullable
    public String getExternalPackageFile() {
        return this.externalPackageFile;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getPackages() {
        String[] result = new String[this.integralPackageList.size()];
        for (int i = 0; i < this.integralPackageList.size(); ++i) {
            result[i] = this.integralPackageList.get(i).getPackage();
        }
        return result;
    }

    @Nonnull
    private static String processSlashes(@Nonnull String str) {
        char last;
        StringBuilder result = new StringBuilder();
        boolean check = true;
        for (char c : str.toCharArray()) {
            if (check) {
                if (c == '\\' || c == '/') continue;
                check = false;
            }
            if (c == '\\' || c == '/') {
                result.append(File.separatorChar);
                continue;
            }
            result.append(c);
        }
        while (result.length() > 0 && ((last = result.charAt(result.length() - 1)) == '/' || last == '\\')) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    @Nullable
    public CustomScript getCustomScript() {
        return this.customScript;
    }

    private synchronized boolean processCVS(@Nonnull @MustNotContainNull List<PackageList.Package> packages, @Nullable ProxySettings proxySettings, @Nonnull @MustNotContainNull File[] goPath) {
        if (!packages.isEmpty()) {
            for (File f : goPath) {
                for (PackageList.Package p : packages) {
                    File rootCvsFolder = this.makePathToPackageSources(f, p.getPackage());
                    if (this.getRelativePathToCvsFolder() == null) {
                        File file = rootCvsFolder = this.isDisableCvsAutosearch() ? rootCvsFolder : this.findRootCvsFolderForPackageSources(f, rootCvsFolder);
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("CVS folder path for %s is %s", p, rootCvsFolder));
                    }
                    if (!rootCvsFolder.isDirectory()) {
                        this.getLog().error((CharSequence)String.format("Can't find CVS folder for package '%s' at '%s'", p, rootCvsFolder.getAbsolutePath()));
                        return false;
                    }
                    CVSType repo = CVSType.investigateFolder(rootCvsFolder);
                    if (repo == CVSType.UNKNOWN) {
                        this.getLog().error((CharSequence)("Can't recognize CVS in the folder : " + rootCvsFolder + " (for package '" + p + "')"));
                        this.getLog().error((CharSequence)"May be to define folder directly through <relativePathToCvsFolder>...</relativePathToCvsFolder>!");
                        return false;
                    }
                    Object[] customcvs = this.getCustomCvsOptions();
                    if (customcvs != null || p.doesNeedCvsProcessing()) {
                        if (!repo.getProcessor().prepareFolder(this.getLog(), proxySettings, this.getCvsExe(), rootCvsFolder)) {
                            this.getLog().debug((CharSequence)("Can't prepare folder : " + rootCvsFolder));
                            return false;
                        }
                        if (customcvs != null && p.doesNeedCvsProcessing()) {
                            this.getLog().warn((CharSequence)"CVS branch, tag or revision are ignored for provided custom CVS options!");
                        }
                        if (customcvs != null) {
                            this.getLog().info((CharSequence)("Custom CVS options : " + Arrays.toString(customcvs)));
                            if (!repo.getProcessor().processCVSForCustomOptions(this.getLog(), proxySettings, rootCvsFolder, this.getCvsExe(), (String[])customcvs)) {
                                return false;
                            }
                        } else if (p.doesNeedCvsProcessing()) {
                            this.getLog().info((CharSequence)String.format("Switch '%s' to branch = '%s', tag = '%s', revision = '%s'", p, GetUtils.ensureNonNull((Object)p.getBranch(), (Object)"_"), GetUtils.ensureNonNull((Object)p.getTag(), (Object)"_"), GetUtils.ensureNonNull((Object)p.getRevision(), (Object)"_")));
                            if (!repo.getProcessor().processCVSRequisites(this.getLog(), proxySettings, this.getCvsExe(), rootCvsFolder, p.getBranch(), p.getTag(), p.getRevision())) {
                                return false;
                            }
                        }
                    }
                    if (this.getCustomScript() == null || this.processCustomScriptCallForPackage(p.getPackage(), rootCvsFolder, (CustomScript)Assertions.assertNotNull((Object)this.getCustomScript()))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean processCustomScriptCallForPackage(@Nonnull String packageName, @Nonnull File rootCvsFolder, @Nonnull CustomScript script) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(script.path);
        if (script.options != null) {
            for (String s : script.options) {
                command.add(s);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("CLI : " + command));
            this.getLog().debug((CharSequence)("Package name : " + packageName));
            this.getLog().debug((CharSequence)("Root CVS folder : " + rootCvsFolder));
        }
        this.getLog().warn((CharSequence)String.format("Starting script in VCS folder [%s] : %s", packageName, StringUtils.join((Object[])command.toArray(), (char)' ')));
        ProcessExecutor processExecutor = new ProcessExecutor(command.toArray(new String[command.size()]));
        processExecutor.exitValueAny().directory(rootCvsFolder).environment("MVNGO_CVS_BRANCH", (String)GetUtils.ensureNonNull((Object)this.branch, (Object)"")).environment("MVNGO_CVS_TAG", (String)GetUtils.ensureNonNull((Object)this.tag, (Object)"")).environment("MVNGO_CVS_REVISION", (String)GetUtils.ensureNonNull((Object)this.revision, (Object)"")).environment("MVNGO_CVS_PACKAGE", packageName).redirectError((OutputStream)System.err).redirectOutput((OutputStream)System.out);
        boolean result = false;
        try {
            ProcessResult process = processExecutor.executeNoTimeout();
            int exitValue = process.getExitValue();
            result = script.ignoreFail ? true : exitValue == 0;
        }
        catch (IOException | InterruptedException | InvalidExitValueException ex) {
            this.getLog().error((CharSequence)"Error in proces custom script", ex);
        }
        return result;
    }

    public boolean isDisableCvsAutosearch() {
        return this.disableCvsAutosearch;
    }

    public boolean getDeleteCommonPkg() {
        return this.deleteCommonPkg;
    }

    @Nullable
    @MustNotContainNull
    public String[] getCustomCvsOptions() {
        return this.customCvsOptions;
    }

    @Nullable
    public String getRelativePathToCvsFolder() {
        return this.relativePathToCvsFolder;
    }

    public boolean isAutoFixGitCache() {
        return this.autofixGitCache;
    }

    public boolean isEnforceDeletePackageFiles() {
        return this.enforceDeletePackageFiles;
    }

    @Nullable
    public String getRevision() {
        return this.revision;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    @Nullable
    public String getCvsExe() {
        return this.cvsExe;
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        return "get";
    }

    @Override
    public boolean isEnforcePrintOutput() {
        return true;
    }

    @Override
    public boolean isMojoMustNotBeExecuted() throws MojoFailureException {
        boolean result;
        String[] packages = this.getTailArguments();
        if (packages.length == 0) {
            this.getLog().info((CharSequence)"There are no packages to get");
            result = true;
        } else {
            result = super.isMojoMustNotBeExecuted();
        }
        return result;
    }

    @Nonnull
    @MustNotContainNull
    private List<String> extractProblemPackagesFromErrorLog(@Nonnull String errorLog) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher extractor = PATTERN_EXTRACT_PACKAGE_AND_STATUS.matcher(errorLog);
        while (extractor.find()) {
            String packageName = extractor.group(1);
            String status = extractor.group(2);
            if ("0".equals(status)) continue;
            result.add(packageName);
        }
        return result;
    }

    @Nullable
    private File findRootCvsFolderForPackageSources(@Nonnull File rootFolder, @Nullable File packageSourceFolder) {
        File foundFile = null;
        if (packageSourceFolder != null) {
            File srcFolder = this.getSrcFolder(rootFolder);
            File current = packageSourceFolder;
            while (!srcFolder.equals(current)) {
                if (CVSType.investigateFolder(current) != CVSType.UNKNOWN) {
                    foundFile = current;
                    break;
                }
                current = current.getParentFile();
            }
        }
        return foundFile;
    }

    @Nonnull
    private File getSrcFolder(@Nonnull File goPath) {
        return new File(goPath, "src");
    }

    @Nonnull
    private File makePathToPackageSources(@Nonnull File goPath, @Nonnull String pack) {
        String path = pack.trim();
        String predefinedCvsPath = this.getRelativePathToCvsFolder();
        if (predefinedCvsPath != null) {
            path = GolangGetMojo.processSlashes(predefinedCvsPath);
        } else {
            try {
                URI uri = URI.create(path);
                path = GolangGetMojo.processSlashes(uri.getPath());
            }
            catch (IllegalArgumentException ex) {
                path = GolangGetMojo.processSlashes(path);
            }
        }
        return new File(this.getSrcFolder(goPath), path);
    }

    @Nonnull
    private File makePathToPackageCompiled(@Nonnull File goPath, @Nonnull String pack) {
        String path = pack.trim();
        try {
            URI uri = URI.create(path);
            path = GolangGetMojo.processSlashes(uri.getPath());
        }
        catch (IllegalArgumentException ex) {
            path = GolangGetMojo.processSlashes(path);
        }
        return new File(goPath, "pkg" + File.separatorChar + this.getOs() + '_' + this.getArch() + File.separatorChar + path);
    }

    private boolean tryToFixGitCacheErrorsForPackages(@Nonnull @MustNotContainNull List<String> packages) throws IOException {
        File[] goPath = this.findGoPath(true);
        int fixed = 0;
        for (File f : goPath) {
            for (String s : packages) {
                File packageFolder = this.makePathToPackageSources(f, s);
                if (packageFolder.isDirectory()) {
                    CVSType repo = CVSType.investigateFolder(packageFolder);
                    if (repo == CVSType.GIT) {
                        this.getLog().warn((CharSequence)String.format("Executing 'git rm -r --cached .' in %s", packageFolder.getAbsolutePath()));
                        int result = repo.getProcessor().execute(this.getCvsExe(), this.getLog(), packageFolder, "rm", "-r", "--cached", ".");
                        if (result != 0) {
                            return false;
                        }
                        ++fixed;
                    } else {
                        this.getLog().warn((CharSequence)String.format("Folder %s is not GIT repository", packageFolder.getAbsolutePath()));
                        return false;
                    }
                    ++fixed;
                    continue;
                }
                this.getLog().debug((CharSequence)("Folder " + packageFolder + " is not found"));
            }
        }
        return fixed != 0;
    }

    private void preparePackageList() throws MojoExecutionException {
        boolean debugEnabled = this.getLog().isDebugEnabled();
        if (debugEnabled) {
            this.getLog().debug((CharSequence)"Preparing package list");
        }
        String[] packagesInConfiguration = super.getPackages();
        ArrayList<PackageList.Package> list = new ArrayList<PackageList.Package>();
        String extPackageFilePath = this.getExternalPackageFile();
        if (extPackageFilePath != null) {
            if ("none".equals(extPackageFilePath)) {
                this.getLog().warn((CharSequence)"Provided value 'none' as package list file name, so that it is ignored");
            } else {
                File extFile = new File(extPackageFilePath);
                this.getLog().info((CharSequence)("Loading external package list file : " + extFile.getAbsolutePath()));
                try {
                    String text = FileUtils.readFileToString((File)extFile, (String)"UTF-8");
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)text);
                    }
                    text = this.interpolate(text);
                    list.addAll(new PackageList(extFile, text, new PackageList.ContentProvider(){

                        @Override
                        @Nonnull
                        public String readContent(@Nonnull File contentFile) throws IOException {
                            if (!contentFile.isFile()) {
                                throw new IOException("Can't find file : " + contentFile.getAbsolutePath());
                            }
                            try {
                                String text = FileUtils.readFileToString((File)contentFile, (String)"UTF-8");
                                if (GolangGetMojo.this.getLog().isDebugEnabled()) {
                                    GolangGetMojo.this.getLog().debug((CharSequence)text);
                                }
                                return GolangGetMojo.this.interpolate(text);
                            }
                            catch (InterpolationException ex) {
                                throw new IOException("Can't interpolate text for error", ex);
                            }
                        }
                    }).getPackages());
                }
                catch (InterpolationException ex) {
                    throw new MojoExecutionException("Interpolation error with file : " + extFile, (Exception)((Object)ex));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Can't load external package list file : " + extFile, (Exception)ex);
                }
                catch (ParseException ex) {
                    throw new MojoExecutionException("Can't parse external package list file", (Exception)ex);
                }
            }
        } else if (debugEnabled) {
            this.getLog().debug((CharSequence)"There is no provided external package list file");
        }
        if (packagesInConfiguration != null && packagesInConfiguration.length > 0) {
            for (String p : packagesInConfiguration) {
                list.add(new PackageList.Package(p, this.getBranch(), this.getTag(), this.getRevision()));
            }
        } else if (debugEnabled) {
            this.getLog().debug((CharSequence)"There are no defined packages in mojo configuration");
        }
        this.integralPackageList = Collections.unmodifiableList(list);
        if (debugEnabled) {
            for (PackageList.Package p : this.integralPackageList) {
                this.getLog().debug((CharSequence)("Added package in list: " + p.makeString()));
            }
        }
    }

    @Override
    public void beforeExecution(@Nullable ProxySettings proxySettings) throws MojoFailureException, MojoExecutionException {
        PackageList.Package p;
        this.preparePackageList();
        if (this.getDeleteCommonPkg()) {
            File[] goPath;
            this.getLog().warn((CharSequence)"Request to delete whole common pkg folder");
            try {
                goPath = this.findGoPath(true);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't get $GOPATH", (Exception)ex);
            }
            for (File f : goPath) {
                File pkgBinary = new File(f, "pkg");
                if (pkgBinary.isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)pkgBinary);
                        this.getLog().warn((CharSequence)("Folder " + pkgBinary + " has been deleted"));
                        continue;
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Can't delete PKG folder : " + pkgBinary, (Exception)ex);
                    }
                }
                this.getLog().info((CharSequence)("PKG folder is not found : " + pkgBinary));
            }
        }
        if (this.isEnforceDeletePackageFiles()) {
            File[] goPath;
            int deletedInstances = 0;
            this.getLog().debug((CharSequence)"Detected request to delete both package source and binary folders if they are presented");
            String[] packages = this.getPackages();
            try {
                goPath = this.findGoPath(true);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't find $GOPATH", (Exception)ex);
            }
            if (packages != null) {
                for (File f : goPath) {
                    for (String p2 : packages) {
                        this.getLog().info((CharSequence)("Removing binary and source folders for package '" + p2 + "' in " + f));
                        File pkgSources = this.makePathToPackageSources(f, p2);
                        File pkgBinary = this.makePathToPackageCompiled(f, p2);
                        this.getLog().debug((CharSequence)("Src folder : " + pkgSources));
                        this.getLog().debug((CharSequence)("Pkg folder : " + pkgBinary));
                        if (pkgSources.isDirectory()) {
                            try {
                                FileUtils.deleteDirectory((File)pkgSources);
                                ++deletedInstances;
                            }
                            catch (IOException ex) {
                                throw new MojoExecutionException("Can't delete source folder : " + pkgSources, (Exception)ex);
                            }
                            this.getLog().info((CharSequence)("\tDeleted source folder : " + pkgSources));
                        } else {
                            this.getLog().debug((CharSequence)("Folder " + pkgSources + " is not found"));
                        }
                        if (pkgBinary.isDirectory()) {
                            try {
                                FileUtils.deleteDirectory((File)pkgBinary);
                                ++deletedInstances;
                            }
                            catch (IOException ex) {
                                throw new MojoExecutionException("Can't delete binary folder : " + pkgBinary, (Exception)ex);
                            }
                            this.getLog().info((CharSequence)("\tDeleted binary folder : " + pkgBinary));
                            continue;
                        }
                        File compiled = new File(pkgBinary.getAbsolutePath() + ".a");
                        if (compiled.isFile()) {
                            if (!compiled.delete()) {
                                throw new MojoExecutionException("Can't delete compiled file : " + compiled);
                            }
                            ++deletedInstances;
                            this.getLog().info((CharSequence)("\tDeleted compiled file : " + compiled));
                            continue;
                        }
                        this.getLog().debug((CharSequence)("File " + compiled + " is not found"));
                    }
                }
            }
            if (deletedInstances > 0) {
                try {
                    this.getLog().info((CharSequence)"1.5 second delay to be visible by systems analyzing file time stamp");
                    Thread.sleep(1500L);
                }
                catch (InterruptedException ex) {
                    throw new MojoExecutionException("Interrupted");
                }
            }
        }
        String[] customcvs = this.getCustomCvsOptions();
        boolean hasTagBranchOrRevision = false;
        List packages = (List)Assertions.assertNotNull((String)"Integral package list must be not inited", this.integralPackageList);
        Iterator ex = packages.iterator();
        while (ex.hasNext() && !(hasTagBranchOrRevision |= (p = (PackageList.Package)ex.next()).doesNeedCvsProcessing())) {
        }
        if (customcvs != null || hasTagBranchOrRevision) {
            File[] goPath;
            try {
                goPath = this.findGoPath(true);
            }
            catch (IOException ex2) {
                throw new MojoFailureException("Can't find $GOPATH", (Throwable)ex2);
            }
            this.getLog().info((CharSequence)"(!) Get initial version of package repository before CVS operations");
            this.buildFlagsToIgnore.add("-u");
            this.addTmpBuildFlagIfNotPresented("-d");
            try {
                boolean error = this.doMainBusiness(proxySettings, 10);
                if (error) {
                    throw new Exception("error as result of 'get' operation during initial loading of packages " + Arrays.toString(this.getPackages()));
                }
            }
            catch (Exception ex3) {
                throw new MojoExecutionException("Can't get packages", ex3);
            }
            finally {
                this.buildFlagsToIgnore.clear();
                this.tempBuildFlags.clear();
            }
            this.getLog().debug((CharSequence)String.format("Switching branch and tag for packages : branch = %s , tag = %s", GetUtils.ensureNonNull((Object)this.branch, (Object)"..."), GetUtils.ensureNonNull((Object)this.tag, (Object)"...")));
            this.getLog().debug((CharSequence)("Custom CVS options : " + Arrays.toString(this.customCvsOptions)));
            if (!this.processCVS(packages, proxySettings, goPath)) {
                throw new MojoFailureException("Can't change branch or tag or execute custom CVS options, see the log for errors!");
            }
        }
    }

    @Nonnull
    private String interpolate(@Nonnull String str) throws IOException, InterpolationException {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)this.getProject().getProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
        interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        return interpolator.interpolate(str);
    }

    @Override
    public boolean isCommandSupportVerbose() {
        return true;
    }

    @Override
    protected boolean doesNeedOneMoreAttempt(@Nonnull ProcessResult processResult, @Nonnull String consoleOut, @Nonnull String consoleErr) throws IOException, MojoExecutionException {
        List<String> packagesWithDetectedGitCacheErrors;
        Matcher matcher;
        boolean result = false;
        if (processResult.getExitValue() != 0 && (matcher = PATTERN_NO_SUBMODULE_MAPPING_FOUND_IN_GIT.matcher(consoleErr)).find() && !(packagesWithDetectedGitCacheErrors = this.extractProblemPackagesFromErrorLog(consoleErr)).isEmpty()) {
            if (this.autofixGitCache) {
                this.getLog().warn((CharSequence)"Trying to fix the detected git cache errors automatically..");
                result = this.tryToFixGitCacheErrorsForPackages(packagesWithDetectedGitCacheErrors);
            } else {
                for (String s : packagesWithDetectedGitCacheErrors) {
                    this.getLog().error((CharSequence)String.format("Detected Git cache error for package '%s', can be fixed with 'git rm -r --cached .'", s));
                }
            }
        }
        return result;
    }
}

