/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.mvngolang.AbstractGoDependencyAwareMojo;
import com.igormaznitsa.mvngolang.utils.IOUtils;
import com.igormaznitsa.mvngolang.utils.MavenUtils;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.zeroturnaround.zip.ZipUtil;

@Mojo(name="mvninstall", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GolangMvnInstallMojo
extends AbstractGoDependencyAwareMojo {
    public static final String MVNGOLANG_DEPENDENCIES_FILE = ".mvn-golang-dependencies";
    @Component
    protected RepositoryManager repositoryManager;
    @Component
    protected ArtifactInstaller installer;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(name="compression", defaultValue="9")
    private int compression;

    public void setCompression(int level) {
        this.compression = level;
    }

    public int getCompression() {
        return this.compression;
    }

    @Override
    public boolean isSkip() {
        return super.isSkip() || Boolean.parseBoolean(System.getProperty("maven.install.skip", "false"));
    }

    @Override
    protected boolean doMainBusiness(@Nonnull ProxySettings proxySettings, int maxAttempts) throws InterruptedException, MojoFailureException, MojoExecutionException, IOException {
        try {
            File archive = this.compressProjectFiles();
            this.getProject().getArtifact().setFile(archive);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Detected unexpected IOException, check the log!", (Exception)ex);
        }
        return true;
    }

    private void safeCopyDirectory(@Nullable String src, @Nonnull File dst) throws IOException {
        if (src == null || src.isEmpty()) {
            return;
        }
        File srcFile = new File(src);
        if (srcFile.isDirectory()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Copying %s => %s", srcFile.getAbsolutePath(), dst.getAbsolutePath()));
            }
            FileUtils.copyDirectoryToDirectory((File)srcFile, (File)dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEffectivePom(@Nonnull File folder) throws IOException {
        Model model = this.getProject().getModel();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(folder, "pom.xml"), false), "UTF-8");
            new MavenXpp3Writer().write((Writer)writer, model);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Effective pom has been written");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(writer);
            throw throwable;
        }
        IOUtils.closeSilently(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File compressProjectFiles() throws IOException {
        Artifact artifact = this.getProject().getArtifact();
        File buildFolder = new File(this.getProject().getBuild().getDirectory());
        if (!buildFolder.isDirectory() && !buildFolder.mkdirs()) {
            this.getLog().error((CharSequence)("Can't create build folder: " + buildFolder));
            throw new IOException("Can't create build folder: " + buildFolder);
        }
        File resultZip = new File(buildFolder, artifact.getArtifactId() + '-' + artifact.getVersion() + '.' + artifact.getType());
        if (resultZip.isFile() && !resultZip.delete()) {
            throw new IOException("Can't delete file : " + resultZip);
        }
        File folderToPack = new File(".tmp_pack_folder_" + Long.toHexString(System.currentTimeMillis()).toUpperCase(Locale.ENGLISH));
        if (folderToPack.isDirectory()) {
            FileUtils.deleteDirectory((File)folderToPack);
        }
        if (!folderToPack.mkdirs()) {
            throw new IOException("Can't create temp folder : " + folderToPack);
        }
        File mvnGolangDependencyListFile = new File(folderToPack, MVNGOLANG_DEPENDENCIES_FILE);
        try {
            this.saveEffectivePom(folderToPack);
            FileUtils.copyFileToDirectory((File)this.getProject().getFile(), (File)folderToPack);
            this.safeCopyDirectory(this.getProject().getBuild().getSourceDirectory(), folderToPack);
            this.safeCopyDirectory(this.getProject().getBuild().getTestSourceDirectory(), folderToPack);
            for (Resource res : this.getProject().getBuild().getResources()) {
                this.safeCopyDirectory(res.getDirectory(), folderToPack);
            }
            for (Resource res : this.getProject().getBuild().getTestResources()) {
                this.safeCopyDirectory(res.getDirectory(), folderToPack);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Packing folder %s to %s", folderToPack.getAbsolutePath(), resultZip.getAbsolutePath()));
            }
            if (mvnGolangDependencyListFile.isFile()) {
                this.getLog().warn((CharSequence)"Skip dependency descriptor making because detected existing one: .mvn-golang-dependencies");
            } else {
                ArrayList<Artifact> golangDependencies = new ArrayList<Artifact>();
                for (MavenProject currentProject = this.getProject(); currentProject != null && !Thread.currentThread().isInterrupted(); currentProject = currentProject.getParent()) {
                    Set dependencies = currentProject.getDependencyArtifacts();
                    if (dependencies == null) continue;
                    for (Artifact a : dependencies) {
                        if (!"mvn-golang".equals(a.getType())) continue;
                        golangDependencies.add(a);
                    }
                }
                StringBuilder buffer = new StringBuilder();
                for (Artifact a : golangDependencies) {
                    buffer.append(MavenUtils.makeArtifactRecord(a)).append('\n');
                }
                String flagFileContent = buffer.toString();
                this.getLog().debug((CharSequence)("Formed list of mvn-golang dependencies\n---------" + flagFileContent + "---------"));
                FileUtils.writeStringToFile((File)mvnGolangDependencyListFile, (String)flagFileContent, (Charset)StandardCharsets.UTF_8);
            }
            ZipUtil.pack((File)folderToPack, (File)resultZip, (int)Math.min(9, Math.max(1, this.compression)));
        }
        finally {
            FileUtils.deleteQuietly((File)folderToPack);
        }
        return resultZip;
    }
}

