/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.ArrayUtils;
import com.igormaznitsa.mvngolang.AbstractGoPackageAndDependencyAwareMojo;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="run", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE)
public class GolangRunMojo
extends AbstractGoPackageAndDependencyAwareMojo {
    @Parameter(name="xprog")
    private String xprog;
    @Parameter(name="args")
    private String[] args;

    @Nonnull
    @MustNotContainNull
    public String[] getArgs() {
        return this.args == null ? ArrayUtils.EMPTY_STRING_ARRAY : (String[])this.args.clone();
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getTailArguments() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getTailArguments()));
        result.addAll(Arrays.asList(this.getArgs()));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean isSourceFolderRequired() {
        return true;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    protected String[] getExtraBuildFlags() {
        String[] result = ArrayUtils.EMPTY_STRING_ARRAY;
        if (this.xprog != null) {
            result = new String[]{"-exec", this.xprog};
        }
        return result;
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        return "run";
    }

    @Override
    public boolean isEnforcePrintOutput() {
        return true;
    }
}

