/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.cvs;

import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.logging.Log;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public abstract class AbstractRepo {
    private final String command;

    public AbstractRepo(@Nonnull String command) {
        this.command = SystemUtils.IS_OS_WINDOWS ? command + ".exe" : command;
    }

    @Nonnull
    public String getCommand() {
        return this.command;
    }

    public int execute(@Nullable String customCommand, @Nonnull Log logger, @Nonnull File cvsFolder, String ... args) {
        ArrayList<String> cli = new ArrayList<String>();
        cli.add((String)GetUtils.findFirstNonNull((Object[])new String[]{customCommand, this.command}));
        cli.addAll(Arrays.asList(args));
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Executing repo command : " + cli));
        }
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ProcessExecutor executor = new ProcessExecutor(cli);
        int result = -1;
        try {
            ProcessResult processResult = executor.directory(cvsFolder).redirectError((OutputStream)errorStream).redirectOutput((OutputStream)outStream).executeNoTimeout();
            result = processResult.getExitValue();
            if (logger.isDebugEnabled()) {
                logger.debug((CharSequence)"Exec.out.........................................");
                logger.debug((CharSequence)new String(errorStream.toByteArray(), Charset.defaultCharset()));
                logger.debug((CharSequence)".................................................");
            }
            if (result != 0) {
                logger.error((CharSequence)new String(errorStream.toByteArray(), Charset.defaultCharset()));
            }
        }
        catch (IOException | InterruptedException | InvalidExitValueException ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.error((CharSequence)"Unexpected error", ex);
        }
        return result;
    }

    protected boolean checkResult(@Nonnull Log logger, int code) {
        return code == 0;
    }

    public abstract boolean doesContainCVS(@Nonnull File var1);

    public boolean prepareFolder(@Nonnull Log logger, @Nullable ProxySettings proxy, @Nullable String customExe, @Nonnull File cvsFolder) {
        return true;
    }

    public boolean processCVSForCustomOptions(@Nonnull Log logger, @Nullable ProxySettings proxy, @Nonnull File cvsFolder, @Nullable String customCommand, String ... options) {
        logger.debug((CharSequence)("customCvsCall: " + Arrays.toString(options)));
        return this.checkResult(logger, this.execute(customCommand, logger, cvsFolder, options));
    }

    public abstract boolean processCVSRequisites(@Nonnull Log var1, @Nullable ProxySettings var2, @Nullable String var3, @Nonnull File var4, @Nullable String var5, @Nullable String var6, @Nullable String var7);
}

