/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import com.igormaznitsa.mvngolang.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;

public final class UnpackUtils {
    private static final ArchiveStreamFactory ARCHIVE_STREAM_FACTORY = new ArchiveStreamFactory();

    private UnpackUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int unpackFileToFolder(@Nonnull Log logger, @Nullable String folder, @Nonnull File archiveFile, @Nonnull File destinationFolder, boolean tryMakeAllExecutable) throws IOException {
        ArchEntryGetter entryGetter;
        ArchiveInputStream archInputStream;
        ZipFile theZipFile;
        String normalizedName = archiveFile.getName().toLowerCase(Locale.ENGLISH);
        boolean modeZipFile = false;
        if (normalizedName.endsWith(".zip")) {
            logger.debug((CharSequence)"Detected ZIP archive");
            modeZipFile = true;
            theZipFile = new ZipFile(archiveFile);
            archInputStream = null;
            entryGetter = new ArchEntryGetter(){
                private final Enumeration<ZipArchiveEntry> iterator;
                {
                    this.iterator = theZipFile.getEntries();
                }

                @Override
                @Nullable
                public ArchiveEntry getNextEntry() throws IOException {
                    ArchiveEntry result = null;
                    if (this.iterator.hasMoreElements()) {
                        result = (ArchiveEntry)this.iterator.nextElement();
                    }
                    return result;
                }
            };
        } else {
            theZipFile = null;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(archiveFile));
            try {
                if (normalizedName.endsWith(".tar.gz")) {
                    logger.debug((CharSequence)"Detected TAR.GZ archive");
                    archInputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(in));
                    entryGetter = () -> ((TarArchiveInputStream)((TarArchiveInputStream)archInputStream)).getNextTarEntry();
                } else {
                    logger.debug((CharSequence)"Detected OTHER archive");
                    archInputStream = ARCHIVE_STREAM_FACTORY.createArchiveInputStream((InputStream)in);
                    logger.debug((CharSequence)("Created archive stream : " + archInputStream.getClass().getName()));
                    entryGetter = () -> ((ArchiveInputStream)archInputStream).getNextEntry();
                }
            }
            catch (ArchiveException ex) {
                IOUtils.closeSilently(in);
                throw new IOException("Can't recognize or read archive file : " + archiveFile, ex);
            }
            catch (CantReadArchiveEntryException ex) {
                IOUtils.closeSilently(in);
                throw new IOException("Can't read entry from archive file : " + archiveFile, ex);
            }
        }
        try {
            ArchiveEntry entry;
            String normalizedFolder = folder == null ? null : FilenameUtils.normalize((String)folder, (boolean)true) + '/';
            int unpackedFilesCounter = 0;
            while ((entry = entryGetter.getNextEntry()) != null) {
                String normalizedPath = FilenameUtils.normalize((String)entry.getName(), (boolean)true);
                logger.debug((CharSequence)("Detected archive entry : " + normalizedPath));
                if (normalizedFolder == null || normalizedPath.startsWith(normalizedFolder)) {
                    File targetFile;
                    block30: {
                        targetFile = new File(destinationFolder, normalizedFolder == null ? normalizedPath : normalizedPath.substring(normalizedFolder.length()));
                        if (entry.isDirectory()) {
                            logger.debug((CharSequence)("Folder : " + normalizedPath));
                            if (targetFile.exists() || targetFile.mkdirs()) continue;
                            throw new IOException("Can't create folder " + targetFile);
                        }
                        File parent = targetFile.getParentFile();
                        if (parent != null && !parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("Can't create folder : " + parent);
                        }
                        try (FileOutputStream fos = new FileOutputStream(targetFile);){
                            if (modeZipFile) {
                                logger.debug((CharSequence)("Unpacking ZIP entry : " + normalizedPath));
                                InputStream zipEntryInStream = theZipFile.getInputStream((ZipArchiveEntry)entry);
                                try {
                                    if ((long)org.apache.commons.io.IOUtils.copy((InputStream)zipEntryInStream, (OutputStream)fos) != entry.getSize()) {
                                        throw new IOException("Can't unpack file, illegal unpacked length : " + entry.getName());
                                    }
                                    break block30;
                                }
                                finally {
                                    IOUtils.closeSilently(zipEntryInStream);
                                }
                            }
                            logger.debug((CharSequence)("Unpacking archive entry : " + normalizedPath));
                            if (!archInputStream.canReadEntryData(entry)) {
                                throw new IOException("Can't read archive entry data : " + normalizedPath);
                            }
                            if ((long)org.apache.commons.io.IOUtils.copy((InputStream)archInputStream, (OutputStream)fos) != entry.getSize()) {
                                throw new IOException("Can't unpack file, illegal unpacked length : " + entry.getName());
                            }
                        }
                    }
                    if (tryMakeAllExecutable) {
                        try {
                            if (!targetFile.setExecutable(true, true)) {
                                logger.debug((CharSequence)("Can't make file executable : " + targetFile));
                            }
                        }
                        catch (SecurityException ex) {
                            throw new IOException("Can't make file executable for security reasons : " + targetFile, ex);
                        }
                    }
                    ++unpackedFilesCounter;
                    continue;
                }
                logger.debug((CharSequence)("Archive entry " + normalizedPath + " ignored"));
            }
            int n = unpackedFilesCounter;
            return n;
        }
        finally {
            IOUtils.closeSilently((Closeable)theZipFile);
            IOUtils.closeSilently((Closeable)archInputStream);
        }
    }

    private static interface ArchEntryGetter {
        @Nullable
        public ArchiveEntry getNextEntry() throws IOException;
    }

    public static class CantReadArchiveEntryException
    extends RuntimeException {
        private static final long serialVersionUID = 1989670574345144082L;

        public CantReadArchiveEntryException(@Nullable Throwable cause) {
            super("Can't read archive entry for exception", cause);
        }
    }
}

