/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class GoMod {
    private static final Pattern TOKENIZER = Pattern.compile("(\\/\\/|\\\"[^\\\"]+\\\"|[<>=\\w.+\\-/]+|[<>=-]+|\\(|\\)|[\\s\\n]+)");
    private final List<GoModItem> items;

    @Nonnull
    private static String quoteIfHasSpace(@Nonnull String str) {
        return str.contains(" ") ? '\"' + str + '\"' : str;
    }

    @Nonnull
    private static String ensureNoQuoting(@Nonnull String text) {
        return text.startsWith("\"") ? text.substring(1, text.length() - 1) : text;
    }

    @Nonnull
    @MustNotContainNull
    private static List<ModuleInfo> extractModuleInfo(@Nonnull @MustNotContainNull List<String> tokens, String ... separators) {
        ArrayList<ModuleInfo> result = new ArrayList<ModuleInfo>();
        ArrayList<String> tokenBuffer = new ArrayList<String>(tokens);
        ArrayList<String> accum = new ArrayList<String>();
        block8: while (!tokenBuffer.isEmpty()) {
            String next = (String)tokenBuffer.remove(0);
            boolean separator = false;
            for (String s : separators) {
                if (!s.equals(next)) continue;
                separator = true;
                break;
            }
            if (separator) {
                switch (accum.size()) {
                    case 1: {
                        result.add(new ModuleInfo((String)accum.remove(0)));
                        continue block8;
                    }
                    case 2: {
                        String name = (String)accum.remove(0);
                        String version = (String)accum.remove(0);
                        result.add(new ModuleInfo(name, version));
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Can't extract module info from tokens: " + tokens);
            }
            accum.add(next);
        }
        switch (accum.size()) {
            case 1: {
                result.add(new ModuleInfo((String)accum.remove(0)));
                break;
            }
            case 2: {
                String name = (String)accum.remove(0);
                String version = (String)accum.remove(0);
                result.add(new ModuleInfo(name, version));
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't extract module info from tokens: " + tokens);
            }
        }
        return result;
    }

    public boolean equals(@Nullable Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (that instanceof GoMod) {
            GoMod thatGoMod = (GoMod)that;
            if (this.items.size() != thatGoMod.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i).equals(thatGoMod.items.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    @Nonnull
    public static GoMod from(@Nonnull String str) {
        ArrayList<GoModItem> foundItems = new ArrayList<GoModItem>();
        Matcher matcher = TOKENIZER.matcher(str);
        ParserState state = ParserState.FIND;
        boolean findEol = false;
        boolean bracket = false;
        ArrayList<String> tokenList = new ArrayList<String>();
        String customTokenName = null;
        block30: while (matcher.find()) {
            String token = matcher.group(1);
            if (findEol) {
                if (!token.contains("\n")) continue;
                findEol = false;
                state = bracket ? state : ParserState.FIND;
                continue;
            }
            block0 : switch (state) {
                case FIND: {
                    tokenList.clear();
                    switch (token) {
                        case "module": {
                            state = ParserState.MODULE;
                            break block0;
                        }
                        case "exclude": {
                            state = ParserState.EXCLUDE;
                            break block0;
                        }
                        case "replace": {
                            state = ParserState.REPLACE;
                            break block0;
                        }
                        case "require": {
                            state = ParserState.REQUIRE;
                            break block0;
                        }
                    }
                    if ("//".equals(token)) {
                        findEol = true;
                        break;
                    }
                    if (token.trim().isEmpty()) continue block30;
                    state = ParserState.CUSTOM;
                    customTokenName = token;
                    break;
                }
                case CUSTOM: {
                    if ("//".equals(token)) {
                        if (bracket) break;
                        foundItems.add(new GoCustom(customTokenName, tokenList.toArray(new String[0])));
                        foundItems.clear();
                        customTokenName = null;
                        state = ParserState.FIND;
                        break;
                    }
                    if ("(".equals(token)) {
                        if (bracket) {
                            throw new IllegalArgumentException("Duplicated opening bracket in " + (Object)((Object)state));
                        }
                        bracket = true;
                        break;
                    }
                    if (")".equals(token)) {
                        if (!bracket) {
                            throw new IllegalArgumentException("Unexpected closing bracket in " + (Object)((Object)state));
                        }
                        bracket = false;
                        foundItems.add(new GoCustom(customTokenName, tokenList.toArray(new String[0])));
                        foundItems.clear();
                        customTokenName = null;
                        state = ParserState.FIND;
                        break;
                    }
                    if (token.contains("\n")) {
                        if (bracket) break;
                        state = ParserState.FIND;
                        foundItems.add(new GoCustom(customTokenName, tokenList.toArray(new String[0])));
                        break;
                    }
                    if (token.trim().isEmpty()) break;
                    tokenList.add(token);
                    break;
                }
                case MODULE: 
                case REQUIRE: 
                case EXCLUDE: 
                case REPLACE: {
                    boolean processTokenList;
                    if ("(".equals(token)) {
                        if (bracket) {
                            throw new IllegalArgumentException("Duplicated opening bracket in " + (Object)((Object)state));
                        }
                        if (!tokenList.isEmpty()) {
                            throw new IllegalArgumentException("Unexpected tokens " + tokenList + " before bracket in " + (Object)((Object)state));
                        }
                        bracket = true;
                        break;
                    }
                    ParserState nextState = state;
                    if (")".equals(token)) {
                        if (!bracket) {
                            throw new IllegalArgumentException("Unexpected closing bracket in " + (Object)((Object)state));
                        }
                        bracket = false;
                        processTokenList = !tokenList.isEmpty();
                        nextState = ParserState.FIND;
                    } else if ("//".equals(token)) {
                        findEol = true;
                        processTokenList = !bracket || !tokenList.isEmpty();
                        nextState = bracket ? state : ParserState.FIND;
                    } else if (token.contains("\n")) {
                        processTokenList = !bracket || !tokenList.isEmpty();
                        nextState = bracket ? state : ParserState.FIND;
                    } else {
                        if (!token.trim().isEmpty()) {
                            tokenList.add(GoMod.ensureNoQuoting(token));
                        }
                        processTokenList = false;
                    }
                    if (processTokenList) {
                        switch (state) {
                            case MODULE: {
                                List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, new String[0]);
                                tokenList.clear();
                                while (!moduleInfos.isEmpty()) {
                                    foundItems.add(new GoModule(moduleInfos.remove(0)));
                                }
                                break;
                            }
                            case REQUIRE: {
                                List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, new String[0]);
                                tokenList.clear();
                                while (!moduleInfos.isEmpty()) {
                                    foundItems.add(new GoRequire(moduleInfos.remove(0)));
                                }
                                break;
                            }
                            case EXCLUDE: {
                                List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, new String[0]);
                                tokenList.clear();
                                while (!moduleInfos.isEmpty()) {
                                    foundItems.add(new GoExclude(moduleInfos.remove(0)));
                                }
                                break;
                            }
                            case REPLACE: {
                                List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, "=>");
                                tokenList.clear();
                                while (!moduleInfos.isEmpty()) {
                                    ModuleInfo from = moduleInfos.remove(0);
                                    if (moduleInfos.isEmpty()) {
                                        throw new IllegalArgumentException("Can't find target in replace");
                                    }
                                    ModuleInfo to = moduleInfos.remove(0);
                                    foundItems.add(new GoReplace(from, to));
                                }
                                break;
                            }
                            default: {
                                throw new Error("Unexpected: " + (Object)((Object)state));
                            }
                        }
                    }
                    state = nextState;
                }
            }
        }
        if (!tokenList.isEmpty()) {
            switch (state) {
                case MODULE: {
                    List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, new String[0]);
                    tokenList.clear();
                    while (!moduleInfos.isEmpty()) {
                        foundItems.add(new GoModule(moduleInfos.remove(0)));
                    }
                    break;
                }
                case REQUIRE: {
                    List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, new String[0]);
                    tokenList.clear();
                    while (!moduleInfos.isEmpty()) {
                        foundItems.add(new GoRequire(moduleInfos.remove(0)));
                    }
                    break;
                }
                case EXCLUDE: {
                    List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, new String[0]);
                    tokenList.clear();
                    while (!moduleInfos.isEmpty()) {
                        foundItems.add(new GoExclude(moduleInfos.remove(0)));
                    }
                    break;
                }
                case REPLACE: {
                    List<ModuleInfo> moduleInfos = GoMod.extractModuleInfo(tokenList, "=>");
                    tokenList.clear();
                    while (!moduleInfos.isEmpty()) {
                        ModuleInfo from = moduleInfos.remove(0);
                        if (moduleInfos.isEmpty()) {
                            throw new IllegalArgumentException("Can't find target in replace");
                        }
                        ModuleInfo to = moduleInfos.remove(0);
                        foundItems.add(new GoReplace(from, to));
                    }
                    break;
                }
                case CUSTOM: {
                    foundItems.add(new GoCustom(customTokenName, tokenList.toArray(new String[0])));
                    break;
                }
            }
        }
        return new GoMod(foundItems);
    }

    private GoMod(@Nonnull @MustNotContainNull List<GoModItem> items) {
        ArrayList<GoModItem> newList = new ArrayList<GoModItem>(items);
        Collections.sort(newList);
        this.items = newList;
    }

    @Nonnull
    public GoMod addItem(@Nonnull GoModItem item) {
        this.items.add(item);
        Collections.sort(this.items);
        return this;
    }

    @Nonnull
    @MustNotContainNull
    public <T extends GoModItem> List<T> find(@Nonnull Class<T> klass) {
        ArrayList<GoModItem> result = new ArrayList<GoModItem>();
        for (GoModItem i : this.items) {
            if (klass != i.getClass()) continue;
            result.add((GoModItem)klass.cast(i));
        }
        return result;
    }

    public int size() {
        return this.items.size();
    }

    @Nonnull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (GoModItem i : this.items) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append(i.toString());
        }
        return buffer.toString();
    }

    public boolean hasReplaceFor(@Nonnull String moduleName, @Nullable String version) {
        boolean found = false;
        for (GoModItem r : this.items) {
            GoReplace require;
            if (!(r instanceof GoReplace) || !moduleName.equals((require = (GoReplace)r).getModule().getName()) || version != null && !version.equals(require.getModule().getVersion())) continue;
            found = true;
        }
        return found;
    }

    public boolean hasRequireFor(@Nonnull String moduleName, @Nullable String version) {
        boolean found = false;
        for (GoModItem r : this.items) {
            GoRequire require;
            if (!(r instanceof GoRequire) || !moduleName.equals((require = (GoRequire)r).getModuleInfo().getName()) || version != null && !version.equals(require.getModuleInfo().getVersion())) continue;
            found = true;
        }
        return found;
    }

    @Nullable
    public String getModule() {
        List<GoModule> found = this.find(GoModule.class);
        return found.isEmpty() ? null : found.get(0).getModuleInfo().getName();
    }

    public static final class ModuleInfo {
        private final String name;
        private final String version;

        public ModuleInfo(@Nonnull String name) {
            this.name = (String)Assertions.assertNotNull((Object)name);
            this.version = null;
        }

        public ModuleInfo(@Nonnull String name, @Nullable String version) {
            this.name = (String)Assertions.assertNotNull((Object)name);
            this.version = version;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        public boolean equals(@Nullable Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (that instanceof ModuleInfo) {
                ModuleInfo thatModuleInfo = (ModuleInfo)that;
                return this.name.equals(thatModuleInfo.name) && Objects.equals(this.version, thatModuleInfo.version);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ (this.version == null ? 0 : this.version.hashCode());
        }

        @Nonnull
        public String toString() {
            return GoMod.quoteIfHasSpace(this.name) + (this.version == null ? "" : " " + GoMod.quoteIfHasSpace(this.version));
        }
    }

    public static abstract class GoModItem
    implements Comparable<GoModItem> {
        @Override
        public int compareTo(@Nonnull GoModItem that) {
            int result = Integer.compare(this.getPriority(), that.getPriority());
            if (result == 0) {
                result = this.toString().compareTo(that.toString());
            }
            return result;
        }

        public abstract int getPriority();

        public abstract boolean equals(@Nullable Object var1);

        public abstract int hashCode();
    }

    private static enum ParserState {
        FIND,
        MODULE,
        REQUIRE,
        REPLACE,
        EXCLUDE,
        CUSTOM;

    }

    public static final class GoCustom
    extends GoModItem {
        private final String name;
        private final String[] tokens;

        public GoCustom(@Nonnull String name, @Nonnull @MustNotContainNull String[] tokens) {
            this.name = (String)Assertions.assertNotNull((Object)name);
            this.tokens = (String[])tokens.clone();
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (that instanceof GoCustom) {
                return this.name.equals(((GoCustom)that).name) && Arrays.equals(this.tokens, ((GoCustom)that).tokens);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Nonnull
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.name);
            for (String t : this.tokens) {
                if (")".equals(t)) {
                    result.append('\n');
                }
                result.append(' ').append(GoMod.quoteIfHasSpace(t));
                if (!"(".equals(t)) continue;
                result.append('\n');
            }
            return result.toString();
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }

    public static final class GoModule
    extends GoModItem {
        private final ModuleInfo moduleInfo;

        public GoModule(@Nonnull ModuleInfo module) {
            this.moduleInfo = (ModuleInfo)Assertions.assertNotNull((Object)module);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (that instanceof GoModule) {
                return this.moduleInfo.equals(((GoModule)that).moduleInfo);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.moduleInfo.hashCode();
        }

        @Nonnull
        public ModuleInfo getModuleInfo() {
            return this.moduleInfo;
        }

        @Nonnull
        public String toString() {
            return "module " + this.moduleInfo;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class GoRequire
    extends GoModItem {
        private final ModuleInfo moduleInfo;

        public GoRequire(@Nonnull ModuleInfo moduleInfo) {
            this.moduleInfo = (ModuleInfo)Assertions.assertNotNull((Object)moduleInfo);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (that instanceof GoRequire) {
                return this.moduleInfo.equals(((GoRequire)that).moduleInfo);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.moduleInfo.hashCode();
        }

        @Nonnull
        public ModuleInfo getModuleInfo() {
            return this.moduleInfo;
        }

        @Nonnull
        public String toString() {
            return "require " + this.moduleInfo;
        }

        @Override
        public int getPriority() {
            return 1;
        }
    }

    public static final class GoExclude
    extends GoModItem {
        private final ModuleInfo module;

        public GoExclude(@Nonnull ModuleInfo module) {
            this.module = (ModuleInfo)Assertions.assertNotNull((Object)module);
        }

        @Nonnull
        public ModuleInfo getModule() {
            return this.module;
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (that instanceof GoExclude) {
                return this.module.equals(((GoExclude)that).module);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.module.hashCode();
        }

        @Nonnull
        public String toString() {
            return "exclude " + this.module;
        }

        @Override
        public int getPriority() {
            return 3;
        }
    }

    public static final class GoReplace
    extends GoModItem {
        private final ModuleInfo module;
        private final ModuleInfo replacement;

        public GoReplace(@Nonnull ModuleInfo module, @Nonnull ModuleInfo replacement) {
            this.module = (ModuleInfo)Assertions.assertNotNull((Object)module);
            this.replacement = (ModuleInfo)Assertions.assertNotNull((Object)replacement);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (that instanceof GoReplace) {
                return this.module.equals(((GoReplace)that).module) && this.replacement.equals(((GoReplace)that).replacement);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.module.hashCode() ^ this.replacement.hashCode();
        }

        @Nonnull
        public ModuleInfo getModule() {
            return this.module;
        }

        @Nonnull
        public ModuleInfo getReplacement() {
            return this.replacement;
        }

        @Nonnull
        public String toString() {
            return "replace " + this.module + " => " + this.replacement;
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }
}

