/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvngolang.utils.MvnGolangArtifactHandler;
import com.igormaznitsa.mvngolang.utils.Tuple;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.zeroturnaround.zip.ZipUtil;

public final class MavenUtils {
    private static final Pattern ARTIFACT_RECORD_PATTERN = Pattern.compile("^([^:]+)::([^:]+)::([^:]*)::([^:]*)::([^:]*)::([^:]*)$");

    private MavenUtils() {
    }

    public static boolean isTestPhase(@Nonnull MojoExecution execution) {
        String phase = execution.getLifecyclePhase();
        return phase != null && (phase.equals("test") || phase.equals("process-test-resources") || phase.equals("test-compile"));
    }

    @Nonnull
    public static ProjectBuildingRequest makeResolveArtifactProjectBuildingRequest(@Nonnull MavenSession session, @Nonnull @MustNotContainNull List<ArtifactRepository> remoteRepositories) {
        DefaultProjectBuildingRequest result = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        result.setRemoteRepositories(remoteRepositories);
        result.setLocalRepository(session.getLocalRepository());
        return result;
    }

    @Nonnull
    public static Artifact parseArtifactRecord(@Nonnull String record, @Nonnull ArtifactHandler handler) throws InvalidVersionSpecificationException {
        Matcher matcher = ARTIFACT_RECORD_PATTERN.matcher(record.trim());
        if (matcher.find()) {
            return new DefaultArtifact(matcher.group(1), matcher.group(2), VersionRange.createFromVersion((String)matcher.group(3)), matcher.group(4).isEmpty() ? null : matcher.group(4), matcher.group(5).isEmpty() ? null : matcher.group(5), matcher.group(6).isEmpty() ? null : matcher.group(6), handler);
        }
        throw new IllegalArgumentException("Can't recognize record as artifact: " + record);
    }

    @Nonnull
    public static String makeArtifactRecord(@Nonnull Artifact artifact) {
        return artifact.getGroupId() + "::" + artifact.getArtifactId() + "::" + artifact.getVersionRange().toString() + "::" + (String)GetUtils.ensureNonNull((Object)artifact.getScope(), (Object)"compile") + "::" + (String)GetUtils.ensureNonNull((Object)artifact.getType(), (Object)"zip") + "::" + (String)GetUtils.ensureNonNull((Object)artifact.getClassifier(), (Object)"");
    }

    @Nonnull
    @MustNotContainNull
    public static List<Tuple<Artifact, File>> scanForMvnGoArtifacts(@Nonnull MavenProject mavenProject, boolean includeTestDependencies, @Nonnull AbstractMojo mojo, @Nonnull MavenSession session, @Nonnull MojoExecution execution, @Nonnull ArtifactResolver resolver, @Nonnull @MustNotContainNull List<ArtifactRepository> remoteRepositories) throws ArtifactResolverException {
        ArrayList<Tuple<Artifact, File>> result = new ArrayList<Tuple<Artifact, File>>();
        HashSet<String> alreadyFoundArtifactRecords = new HashSet<String>();
        MavenProject currentProject = mavenProject;
        while (currentProject != null && !Thread.currentThread().isInterrupted()) {
            Set projectDependencies = currentProject.getDependencyArtifacts();
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(projectDependencies == null ? Collections.emptySet() : projectDependencies);
            mojo.getLog().debug((CharSequence)("Detected dependency artifacts: " + artifacts));
            while (!artifacts.isEmpty() && !Thread.currentThread().isInterrupted()) {
                Artifact artifact = (Artifact)artifacts.remove(0);
                if ("test".equals(artifact.getScope()) && !includeTestDependencies || !artifact.getType().equals("mvn-golang")) continue;
                ArtifactResult artifactResult = resolver.resolveArtifact(MavenUtils.makeResolveArtifactProjectBuildingRequest(session, remoteRepositories), artifact);
                File zipFillePath = artifactResult.getArtifact().getFile();
                mojo.getLog().debug((CharSequence)("Detected MVN-GOLANG marker inside ZIP dependency: " + artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion() + ':' + artifact.getType()));
                if (ZipUtil.containsEntry((File)zipFillePath, (String)".mvn-golang-dependencies")) {
                    byte[] artifactFlagFile = ZipUtil.unpackEntry((File)zipFillePath, (String)".mvn-golang-dependencies", (Charset)StandardCharsets.UTF_8);
                    for (String str : new String(artifactFlagFile, StandardCharsets.UTF_8).split("\\R")) {
                        if (str.trim().isEmpty() || alreadyFoundArtifactRecords.contains(str)) continue;
                        mojo.getLog().debug((CharSequence)("Adding mvn-golang dependency: " + str));
                        alreadyFoundArtifactRecords.add(str);
                        try {
                            artifacts.add(MavenUtils.parseArtifactRecord(str, (ArtifactHandler)new MvnGolangArtifactHandler()));
                        }
                        catch (InvalidVersionSpecificationException ex) {
                            throw new ArtifactResolverException("Can't make artifact: " + str, (Exception)((Object)ex));
                        }
                    }
                }
                File artifactFile = artifactResult.getArtifact().getFile();
                mojo.getLog().debug((CharSequence)("Artifact file: " + artifactFile));
                if (MavenUtils.doesContainFile(result, artifactFile)) {
                    mojo.getLog().debug((CharSequence)("Artifact file ignored as duplication: " + artifactFile));
                    continue;
                }
                result.add(Tuple.of(artifact, artifactFile));
            }
            currentProject = currentProject.hasParent() ? currentProject.getParent() : null;
        }
        return result;
    }

    private static boolean doesContainFile(@Nonnull @MustNotContainNull List<Tuple<Artifact, File>> list, @Nonnull File file) {
        boolean result = false;
        for (Tuple<Artifact, File> t : list) {
            if (!t.right().equals(file)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Nullable
    public static String findProperty(@Nonnull MavenSession session, @Nonnull MavenProject project, @Nonnull String key, @Nullable String dflt) {
        String projectProperty = session.getUserProperties().getProperty(key);
        if (projectProperty == null) {
            MavenProject curProject = project;
            do {
                projectProperty = curProject.getProperties().getProperty(key);
                curProject = curProject.getParent();
            } while (projectProperty == null && curProject != null);
        }
        return projectProperty == null ? System.getProperty(key, dflt) : projectProperty;
    }
}

