/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Tuple<A, B> {
    private final A left;
    private final B right;

    private Tuple(@Nonnull A left, @Nonnull B right) {
        this.left = Assertions.assertNotNull(left);
        this.right = Assertions.assertNotNull(right);
    }

    @Nonnull
    public static <A, B> Tuple<A, B> of(@Nonnull A left, @Nonnull B right) {
        return new Tuple<A, B>(left, right);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Tuple) {
            Tuple that = (Tuple)obj;
            return this.left.equals(that.left) && this.right.equals(that.right);
        }
        return false;
    }

    public int hashCode() {
        return this.left.hashCode() ^ this.right.hashCode();
    }

    @Nonnull
    public A left() {
        return this.left;
    }

    @Nonnull
    public B right() {
        return this.right;
    }
}

