/*
 * Copyright 2019 Igor Maznitsa.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.igormaznitsa.mvngolang.utils;

import com.igormaznitsa.mvngolang.AbstractGolangMojo;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;

/**
 * Artifact handler for mvn-golang artifacts.
 *
 * @since 2.3.0
 */
public final class MvnGolangArtifactHandler extends DefaultArtifactHandler {

  public MvnGolangArtifactHandler() {
    super(AbstractGolangMojo.GOARTIFACT_PACKAGING);
    this.setExtension("zip");
    this.setAddedToClasspath(false);
  }
}
