/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.mvngolang.AbstractGolangMojo;
import com.igormaznitsa.mvngolang.utils.GoMod;
import com.igormaznitsa.mvngolang.utils.IOUtils;
import com.igormaznitsa.mvngolang.utils.MavenUtils;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import com.igormaznitsa.mvngolang.utils.Tuple;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.zeroturnaround.zip.ZipUtil;

public abstract class AbstractGoDependencyAwareMojo
extends AbstractGolangMojo {
    public static final String GO_MOD_FILE_NAME_BAK = ".#go.mod.mvn.orig";
    public static final String DELETE_GO_SUM_FLAG_FILE = ".#go.mod.mvn.delete.sum";
    private String extraGoPathSectionInOsFormat = "";
    @Parameter(name="scanDependencies", defaultValue="true")
    private boolean scanDependencies = true;
    @Parameter(name="includeTestDependencies", defaultValue="true")
    private boolean includeTestDependencies = true;
    @Parameter(name="dependencyTempFolder", defaultValue="${project.build.directory}${file.separator}.__deps__")
    private String dependencyTempFolder;
    @Parameter(name="syncSessionIfModules", defaultValue="true")
    private boolean syncSessionIfModules;

    public boolean isSyncSessionIfModules() {
        return Boolean.parseBoolean(this.findMvnProperty("mvn.golang.sync.session.if.modules", Boolean.toString(this.syncSessionIfModules)));
    }

    public void setSyncSessionIfModules(boolean value) {
        this.syncSessionIfModules = value;
    }

    @Nonnull
    public String getDependencyTempFolder() {
        return this.dependencyTempFolder;
    }

    public void setDependencyTempFolder(@Nonnull String path) {
        this.dependencyTempFolder = (String)Assertions.assertNotNull((Object)path);
    }

    public boolean isScanDependencies() {
        return this.scanDependencies;
    }

    public void setScanDependencies(boolean flag) {
        this.scanDependencies = flag;
    }

    public boolean isIncludeTestDependencies() {
        return this.includeTestDependencies;
    }

    public void setIncludeTestDependencies(boolean value) {
        this.includeTestDependencies = value;
    }

    @Nonnull
    private String makeRelativePathToFolder(@Nonnull File goModFile, @Nonnull File folder) {
        return goModFile.toPath().relativize(folder.toPath()).toString();
    }

    @Nonnull
    @MustNotContainNull
    private List<Tuple<Artifact, Tuple<GoMod, File>>> findModsInProject() throws IOException {
        File sourceFolder = this.getSources(false);
        if (sourceFolder.isDirectory()) {
            return this.findGoModsAndParse(Collections.singletonList(Tuple.of(this.getProject().getArtifact(), sourceFolder)));
        }
        return Collections.emptyList();
    }

    private void preprocessModules(@Nonnull @MustNotContainNull List<Tuple<Artifact, File>> unpackedDependencyFolders) throws MojoExecutionException {
        try {
            List<Tuple<Artifact, Tuple<GoMod, File>>> lst = this.preprocessModuleFilesInDependencies(unpackedDependencyFolders);
            List<Tuple<GoMod, File>> dependencyGoMods = this.listRightPart(lst);
            List<Tuple<Artifact, Tuple<GoMod, File>>> projectGoMods = this.findModsInProject();
            for (Tuple<Artifact, Tuple<GoMod, File>> f : projectGoMods) {
                File goModFile = f.right().right();
                File workingFolder = goModFile.getParentFile();
                File sumFile = new File(workingFolder, "go.sum");
                File goModFileBak = new File(workingFolder, GO_MOD_FILE_NAME_BAK);
                File deleteSumFileFlag = new File(workingFolder, DELETE_GO_SUM_FLAG_FILE);
                if (goModFileBak.isFile()) {
                    if (goModFile.isFile() && !goModFile.delete()) {
                        throw new IOException("Can't delete go.mod file: " + goModFile);
                    }
                    if (deleteSumFileFlag.isFile() && sumFile.isFile() && !sumFile.delete()) {
                        throw new IOException("Can't delete file " + sumFile);
                    }
                    FileUtils.copyFile((File)goModFileBak, (File)goModFile);
                } else {
                    if (goModFile.isFile()) {
                        FileUtils.copyFile((File)goModFile, (File)goModFileBak);
                    }
                    if (!(sumFile.isFile() || deleteSumFileFlag.isFile() || deleteSumFileFlag.createNewFile())) {
                        throw new IOException("Can't create file " + deleteSumFileFlag);
                    }
                }
                if (!goModFile.isFile()) continue;
                GoMod parsed = GoMod.from(FileUtils.readFileToString((File)goModFile, (Charset)StandardCharsets.UTF_8));
                if (this.replaceLinksToModules(Tuple.of(parsed, goModFile), dependencyGoMods)) {
                    FileUtils.write((File)goModFile, (CharSequence)parsed.toString(), (Charset)StandardCharsets.UTF_8);
                }
                if (!sumFile.isFile() || deleteSumFileFlag.isFile() || deleteSumFileFlag.createNewFile()) continue;
                throw new IOException("Can't create file " + deleteSumFileFlag);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Can't process a go.mod file", (Exception)ex);
        }
    }

    @Nonnull
    @MustNotContainNull
    private List<Tuple<Artifact, Tuple<GoMod, File>>> findGoModsAndParse(@Nonnull @MustNotContainNull List<Tuple<Artifact, File>> unpackedFolders) throws IOException {
        ArrayList<Tuple<Artifact, Tuple<GoMod, File>>> result = new ArrayList<Tuple<Artifact, Tuple<GoMod, File>>>();
        for (Tuple<Artifact, File> tuple : unpackedFolders) {
            for (File f : FileUtils.listFiles((File)tuple.right(), (IOFileFilter)FileFilterUtils.nameFileFilter((String)"go.mod"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
                GoMod model = GoMod.from(FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8));
                result.add(Tuple.of(tuple.left(), Tuple.of(model, f)));
            }
        }
        return result;
    }

    private boolean replaceLinksToModules(@Nonnull Tuple<GoMod, File> source, @Nonnull @MustNotContainNull List<Tuple<GoMod, File>> targets) throws IOException {
        boolean changed = false;
        for (Tuple<GoMod, File> j : targets) {
            if (source.equals(j)) continue;
            GoMod thatParsedGoMod = j.left();
            File thatGoModFile = j.right();
            if (!source.left().hasRequireFor(thatParsedGoMod.getModule(), null) || source.left().hasReplaceFor(thatParsedGoMod.getModule(), null)) continue;
            String relativePath = this.makeRelativePathToFolder(source.right().getParentFile(), thatGoModFile.getParentFile());
            source.left().addItem(new GoMod.GoReplace(new GoMod.ModuleInfo(thatParsedGoMod.getModule()), new GoMod.ModuleInfo(relativePath)));
            changed = true;
        }
        return changed;
    }

    @Nonnull
    @MustNotContainNull
    private List<Tuple<GoMod, File>> listRightPart(@Nonnull @MustNotContainNull List<Tuple<Artifact, Tuple<GoMod, File>>> list) {
        ArrayList<Tuple<GoMod, File>> parsed = new ArrayList<Tuple<GoMod, File>>();
        for (Tuple<Artifact, Tuple<GoMod, File>> i : list) {
            parsed.add(i.right());
        }
        return parsed;
    }

    private int generateCrossLinksBetweenArtifactGoMods(@Nonnull @MustNotContainNull List<Tuple<Artifact, Tuple<GoMod, File>>> unpackedFolders) throws IOException {
        int changes = 0;
        List<Tuple<GoMod, File>> parsed = this.listRightPart(unpackedFolders);
        for (Tuple<GoMod, File> i : parsed) {
            if (!this.replaceLinksToModules(i, parsed)) continue;
            ++changes;
            FileUtils.write((File)i.right(), (CharSequence)i.left().toString(), (Charset)StandardCharsets.UTF_8);
        }
        return changes;
    }

    @Nonnull
    @MustNotContainNull
    private List<Tuple<Artifact, Tuple<GoMod, File>>> preprocessModuleFilesInDependencies(@Nonnull @MustNotContainNull List<Tuple<Artifact, File>> unpackedFolders) throws IOException {
        this.getLog().debug((CharSequence)"Finding go.mod descriptors in unpacked artifacts");
        List<Tuple<Artifact, Tuple<GoMod, File>>> foundAndParsedGoMods = this.findGoModsAndParse(unpackedFolders);
        this.getLog().debug((CharSequence)String.format("Found %d go.mod descriptors", foundAndParsedGoMods.size()));
        int changedGoModCounter = this.generateCrossLinksBetweenArtifactGoMods(foundAndParsedGoMods);
        this.getLog().debug((CharSequence)String.format("Changed %d go.mod descriptors in unpacked artifacts", changedGoModCounter));
        return foundAndParsedGoMods;
    }

    @Override
    public final void doInit() throws MojoFailureException, MojoExecutionException {
        super.doInit();
        if (this.isModuleMode()) {
            try {
                File src = this.getSources(false);
                this.restoreGoModFromBackupAndRemoveBackup(src);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error during restoring of detected go.mod backup in source folder", (Exception)ex);
            }
        }
        if (this.isScanDependencies()) {
            List<Tuple<Artifact, File>> foundArtifacts;
            this.getLog().info((CharSequence)"Scanning maven dependencies");
            try {
                foundArtifacts = MavenUtils.scanForMvnGoArtifacts(this.getProject(), this.isIncludeTestDependencies(), this, this.getSession(), this.getExecution(), this.getArtifactResolver(), this.getRemoteRepositories());
            }
            catch (ArtifactResolverException ex) {
                throw new MojoFailureException("Can't resolve artifact", (Throwable)ex);
            }
            if (foundArtifacts.isEmpty()) {
                this.getLog().debug((CharSequence)"Mvn golang dependencies are not found");
                if (this.isModuleMode()) {
                    this.preprocessModules(Collections.emptyList());
                }
                this.extraGoPathSectionInOsFormat = "";
            } else {
                this.getLog().debug((CharSequence)("Found mvn-golang artifacts: " + foundArtifacts));
                File dependencyTempTargetFolder = new File(this.getDependencyTempFolder());
                this.getLog().debug((CharSequence)("Dependencies will be unpacked into folder: " + dependencyTempTargetFolder));
                List<Tuple<Artifact, File>> unpackedFolders = this.unpackArtifactsIntoFolder(foundArtifacts, dependencyTempTargetFolder);
                if (this.isModuleMode()) {
                    this.getLog().info((CharSequence)"Module mode is activated");
                    this.preprocessModules(unpackedFolders);
                    this.getLog().info((CharSequence)"Dependencies are not added into GOPATH because module mode is on");
                } else {
                    ArrayList<File> unpackedFolderList = new ArrayList<File>();
                    for (Tuple<Artifact, File> f : unpackedFolders) {
                        unpackedFolderList.add(f.right());
                    }
                    String preparedExtraPartForGoPath = IOUtils.makeOsFilePathWithoutDuplications(unpackedFolderList.toArray(new File[0]));
                    this.getLog().debug((CharSequence)("Prepared dependency path for GOPATH: " + preparedExtraPartForGoPath));
                    this.extraGoPathSectionInOsFormat = preparedExtraPartForGoPath;
                }
            }
        } else {
            this.getLog().info((CharSequence)"Maven dependency scanning is off");
        }
    }

    private void restoreGoModFromBackupAndRemoveBackup(@Nonnull File folder) throws IOException {
        Collection backupFiles = FileUtils.listFiles((File)folder, (IOFileFilter)FileFilterUtils.nameFileFilter((String)GO_MOD_FILE_NAME_BAK), (IOFileFilter)TrueFileFilter.INSTANCE);
        this.getLog().debug((CharSequence)String.format("Restoring go.mod from backup in %s, detected %d files", folder, backupFiles.size()));
        for (File backup : backupFiles) {
            File workingFolder = backup.getParentFile();
            File restored = new File(workingFolder, "go.mod");
            File goSumFile = new File(workingFolder, "go.sum");
            File deleteGoSumFileFlag = new File(workingFolder, DELETE_GO_SUM_FLAG_FILE);
            if (restored.isFile() && !restored.delete()) {
                throw new IOException("Can't delete file during backup restore: " + restored);
            }
            if (!backup.renameTo(restored)) {
                throw new IOException("Can't rename backup: " + backup + " -> " + restored);
            }
            if (!deleteGoSumFileFlag.isFile()) continue;
            if (!deleteGoSumFileFlag.delete()) {
                throw new IOException("Can't delete file " + deleteGoSumFileFlag);
            }
            if (!goSumFile.isFile() || goSumFile.delete()) continue;
            throw new IOException("Can't delete file " + goSumFile);
        }
    }

    @Override
    public void afterExecution(@Nullable ProxySettings proxySettings, boolean error) throws MojoFailureException, MojoExecutionException {
        try {
            if (this.isModuleMode()) {
                this.getLog().debug((CharSequence)"module mode is on");
                File srcFolder = this.getSources(false);
                this.getLog().debug((CharSequence)("Detected source folder: " + srcFolder));
                if (srcFolder.isDirectory()) {
                    if (this.isRestoreGoMod()) {
                        this.getLog().debug((CharSequence)("Restoring go.mod from backup in source folder: " + srcFolder));
                        this.restoreGoModFromBackupAndRemoveBackup(srcFolder);
                    } else {
                        this.getLog().debug((CharSequence)"Restoring of go.mod from backup is disabled by project property");
                    }
                } else {
                    this.getLog().debug((CharSequence)"Restore backup mod files is ignored because source folder is not directory");
                }
            } else {
                this.getLog().debug((CharSequence)"module mode is off");
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error during restore go.mod from backup", (Exception)ex);
        }
        finally {
            super.afterExecution(proxySettings, error);
        }
    }

    @Override
    protected boolean doesNeedSessionLock() {
        return this.getSession().isParallel() && this.isModuleMode() && this.isSyncSessionIfModules();
    }

    protected boolean isRestoreGoMod() {
        return Boolean.parseBoolean(MavenUtils.findProperty(this.getSession(), this.getProject(), "mvn.golang.restore.go.mod", "true"));
    }

    @Nonnull
    @MustNotContainNull
    private List<Tuple<Artifact, File>> unpackArtifactsIntoFolder(@Nonnull @MustNotContainNull List<Tuple<Artifact, File>> zippedArtifacts, @Nonnull File targetFolder) throws MojoExecutionException {
        ArrayList<Tuple<Artifact, File>> resultFolders = new ArrayList<Tuple<Artifact, File>>();
        if (!targetFolder.isDirectory() && !targetFolder.mkdirs()) {
            throw new MojoExecutionException("Can't create folder to unpack dependencies: " + targetFolder);
        }
        for (Tuple<Artifact, File> zipFile : zippedArtifacts) {
            boolean doUnpackArch;
            File outDir = new File(targetFolder, FilenameUtils.getBaseName((String)zipFile.right().getName()));
            if (outDir.isDirectory()) {
                this.getLog().debug((CharSequence)("Unpacked dependency folder already exists: " + outDir));
                if (Boolean.parseBoolean(MavenUtils.findProperty(this.getSession(), this.getProject(), "mvn.golang.force.clean.dependency", "false"))) {
                    this.getLog().debug((CharSequence)("Forcing dependency folder delete: " + outDir));
                    try {
                        FileUtils.deleteDirectory((File)outDir);
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Can't delete dependency folder: " + outDir, (Exception)ex);
                    }
                    doUnpackArch = true;
                } else {
                    this.getLog().debug((CharSequence)("Ignoring dependency unpack because folder exists: " + outDir));
                    doUnpackArch = false;
                }
            } else {
                doUnpackArch = true;
            }
            if (doUnpackArch) {
                if (ZipUtil.containsEntry((File)zipFile.right(), (String)".mvn-golang-build-folders")) {
                    File srcTargetFolder = new File(outDir, "src");
                    try {
                        this.unzipSrcFoldersContent(zipFile.right(), srcTargetFolder);
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Can't unpack source folders from dependency archive '" + zipFile.right().getName() + "' into folder '" + srcTargetFolder + '\'', ex);
                    }
                }
                try {
                    this.getLog().debug((CharSequence)("Unpack dependency archive: " + zipFile));
                    ZipUtil.unpack((File)zipFile.right(), (File)outDir, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Can't unpack dependency archive '" + zipFile.right().getName() + "' into folder '" + targetFolder + '\'', ex);
                }
            }
            resultFolders.add(Tuple.of(zipFile.left(), outDir));
        }
        return resultFolders;
    }

    private boolean unzipSrcFoldersContent(@Nonnull File artifactZip, @Nonnull File targetFolder) {
        byte[] buildFolderListFile = ZipUtil.unpackEntry((File)artifactZip, (String)".mvn-golang-build-folders");
        if (buildFolderListFile == null) {
            return false;
        }
        ArrayList<String> folderList = new ArrayList<String>();
        for (String folder : new String(buildFolderListFile, StandardCharsets.UTF_8).split("\\n")) {
            String trimmed = folder.trim();
            if (trimmed.isEmpty()) continue;
            folderList.add(folder + '/');
        }
        for (String folder : folderList) {
            ZipUtil.unpack((File)artifactZip, (File)targetFolder, name -> {
                if (name.startsWith(folder)) {
                    return name.substring(folder.length());
                }
                return null;
            });
        }
        return true;
    }

    @Override
    @Nonnull
    protected final String getSpecialPartOfGoPath() {
        return this.extraGoPathSectionInOsFormat;
    }
}

