/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.LazyInited;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.annotation.ReturnsOriginal;
import com.igormaznitsa.meta.common.utils.ArrayUtils;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.meta.common.utils.StrUtils;
import com.igormaznitsa.mvngolang.utils.IOUtils;
import com.igormaznitsa.mvngolang.utils.MavenUtils;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import com.igormaznitsa.mvngolang.utils.SysUtils;
import com.igormaznitsa.mvngolang.utils.UnpackUtils;
import com.igormaznitsa.mvngolang.utils.WildCardMatcher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public abstract class AbstractGolangMojo
extends AbstractMojo {
    public static final String GOARTIFACT_PACKAGING = "mvn-golang";
    public static final String GO_MOD_FILE_NAME = "go.mod";
    public static final String GO_SUM_FILE_NAME = "go.sum";
    public static final String ENV_GO111MODULE = "GO111MODULE";
    public static final String NAME_PATTERN = "go%s.%s-%s%s";
    private static final List<String> ALLOWED_SDKARCHIVE_CONTENT_TYPE = Collections.unmodifiableList(Arrays.asList("application/octet-stream", "application/zip", "application/x-tar", "application/x-gzip"));
    private static final ReentrantLock LOCKER = new ReentrantLock();
    private static final String[] BANNER = new String[]{"______  ___             _________     ______", "___   |/  /__   __________  ____/________  / ______ ______________ _", "__  /|_/ /__ | / /_  __ \\  / __ _  __ \\_  /  _  __ `/_  __ \\_  __ `/", "_  /  / / __ |/ /_  / / / /_/ / / /_/ /  /___/ /_/ /_  / / /  /_/ / ", "/_/  /_/  _____/ /_/ /_/\\____/  \\____//_____/\\__,_/ /_/ /_/_\\__, /", "                                                           /____/", "                  https://github.com/raydac/mvn-golang", ""};
    private static final Pattern GOBINFOLDER_PATTERN = Pattern.compile("(?:\\\\|/)go[0-9\\-\\+.]*(?:\\\\|/)bin(?:\\\\|/)?$", 2);
    protected final Set<String> buildFlagsToIgnore = new HashSet<String>();
    protected final List<String> tempBuildFlags = new ArrayList<String>();
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution execution;
    @Parameter(name="moduleMode", defaultValue="false")
    private boolean moduleMode;
    @Parameter(name="workingDir")
    private String workingDir;
    @Parameter(defaultValue="true", name="filterEnvPath")
    private boolean filterEnvPath = true;
    @Parameter(name="checkSdkHash", defaultValue="true")
    private boolean checkSdkHash = true;
    @Parameter(name="useMavenProxy", defaultValue="true")
    private boolean useMavenProxy;
    @Parameter(name="disableSSLcheck", defaultValue="false")
    private boolean disableSSLcheck;
    @Parameter(name="supposeSdkArchiveFileName", defaultValue="true")
    private boolean supposeSdkArchiveFileName;
    @Parameter(name="proxy")
    private ProxySettings proxy;
    @Parameter(name="skip", defaultValue="false")
    private boolean skip;
    @Parameter(name="ignoreErrorExitCode", defaultValue="false")
    private boolean ignoreErrorExitCode;
    @Parameter(name="reportsFolder", defaultValue="${project.build.directory}${file.separator}reports")
    private String reportsFolder;
    @Parameter(name="outLogFile")
    private String outLogFile;
    @Parameter(name="errLogFile")
    private String errLogFile;
    @Parameter(name="sdkSite", defaultValue="https://storage.googleapis.com/golang/")
    private String sdkSite;
    @Parameter(defaultValue="true", name="hideBanner")
    private boolean hideBanner;
    @Parameter(defaultValue="${user.home}${file.separator}.mvnGoLang", name="storeFolder")
    private String storeFolder;
    @Parameter(defaultValue="${user.home}${file.separator}.mvnGoLang${file.separator}.go_path", name="goPath")
    private String goPath;
    private String target386;
    @Parameter(name="targetArm")
    private String targetArm;
    @Parameter(defaultValue="${project.build.directory}", name="goBin")
    private String goBin;
    @Parameter(name="goVersion", defaultValue="1.15.6")
    private String goVersion;
    @Parameter(name="goCache", defaultValue="${project.build.directory}${file.separator}.goBuildCache")
    private String goCache;
    @Parameter(name="goRoot")
    private String goRoot;
    @Parameter(name="goRootBootstrap")
    private String goRootBootstrap;
    @Parameter(name="enforceGoPathToEnd", defaultValue="false")
    private boolean enforceGoPathToEnd;
    @Parameter(name="execSubpath", defaultValue="bin")
    private String execSubpath;
    @Parameter(name="exec", defaultValue="go")
    private String exec;
    @Parameter(name="echoWarn")
    private String[] echoWarn;
    @Parameter(name="echo")
    private String[] echo;
    @Parameter(name="disableSdkLoad", defaultValue="false")
    private boolean disableSdkLoad;
    @Parameter(defaultValue="${project.build.sourceDirectory}", name="sources")
    private String sources;
    @Parameter(name="targetOs")
    private String targetOs;
    @Parameter(name="os")
    private String os;
    @Parameter(name="targetArch")
    private String targetArch;
    @Parameter(name="arch")
    private String arch;
    @Parameter(name="osxVersion")
    private String osxVersion;
    @Parameter(name="buildFlags")
    private String[] buildFlags;
    @Parameter(name="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(name="keepSdkArchive", defaultValue="false")
    private boolean keepSdkArchive;
    @Parameter(name="useGoTool")
    private String useGoTool;
    @Parameter(name="useEnvVars", defaultValue="false")
    private boolean useEnvVars;
    @Parameter(name="env")
    private Map<?, ?> env;
    @Parameter(name="sdkArchiveName")
    private String sdkArchiveName;
    @Parameter(name="sdkDownloadUrl")
    private String sdkDownloadUrl;
    @Parameter(name="connectionTimeout", defaultValue="60000")
    private int connectionTimeout = 60000;
    @Parameter(name="keepUnarchFolderIfError", defaultValue="false")
    private boolean keepUnarchFolderIfError;
    @Parameter(name="addToGoPath")
    private String[] addToGoPath;
    @LazyInited
    private CloseableHttpClient httpClient;
    @LazyInited
    private ByteArrayOutputStream consoleErrBuffer;
    @LazyInited
    private ByteArrayOutputStream consoleOutBuffer;

    @Nonnull
    private static String ensureNoSurroundingSlashes(@Nonnull String str) {
        String result = str;
        if (!(result.isEmpty() || result.charAt(0) != '/' && result.charAt(0) != '\\')) {
            result = result.substring(1);
        }
        if (!(result.isEmpty() || result.charAt(result.length() - 1) != '/' && result.charAt(result.length() - 1) != '\\')) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static void deleteFileIfExists(@Nonnull File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            throw new IOException("Can't delete file : " + file);
        }
    }

    private static boolean isSafeEmpty(@Nullable String value) {
        return value == null || value.isEmpty();
    }

    @Nonnull
    private static String extractExtensionOfArchive(@Nonnull String archiveName) {
        String lcName = archiveName.toLowerCase(Locale.ENGLISH);
        String result = lcName.endsWith(".tar.gz") ? archiveName.substring(archiveName.length() - "tar.gz".length()) : FilenameUtils.getExtension((String)archiveName);
        return result;
    }

    @Nonnull
    protected static String adaptExecNameForOS(@Nonnull String execName) {
        return execName + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
    }

    @Nonnull
    private static String getPathToFolder(@Nonnull String path) {
        String text = path;
        if (!text.endsWith("/") && !text.endsWith("\\")) {
            text = text + File.separatorChar;
        }
        return text;
    }

    @Nonnull
    private static String getPathToFolder(@Nonnull File path) {
        return AbstractGolangMojo.getPathToFolder(path.getAbsolutePath());
    }

    @Nullable
    protected static File findExisting(File ... files) {
        File result = null;
        for (File f : files) {
            if (f == null || !f.isFile()) continue;
            result = f;
            break;
        }
        return result;
    }

    @Nonnull
    private static String removeSrcFolderAtEndIfPresented(@Nonnull String text) {
        String result = text;
        if (text.endsWith("/src") || text.endsWith("\\src")) {
            result = text.substring(0, text.length() - 4);
        }
        return result;
    }

    @Nonnull
    private static String extractComputerName() {
        String result = System.getenv("COMPUTERNAME");
        if (result == null) {
            result = System.getenv("HOSTNAME");
        }
        if (result == null) {
            try {
                result = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                result = null;
            }
        }
        return (String)GetUtils.ensureNonNull((Object)result, (Object)"<Unknown computer>");
    }

    @Nonnull
    private static String extractDomainName() {
        String result = System.getenv("USERDOMAIN");
        return (String)GetUtils.ensureNonNull((Object)result, (Object)"");
    }

    @Nullable
    public final String getWorkingDir() {
        return this.workingDir;
    }

    public final void setWorkingDir(@Nullable String path) {
        this.workingDir = path;
    }

    public boolean isModuleMode() {
        return Boolean.parseBoolean(this.findMvnProperty("mvn.golang.module.mode", Boolean.toString(this.moduleMode)));
    }

    public void setModuleMode(boolean value) {
        this.moduleMode = value;
    }

    @Nonnull
    public ArtifactResolver getArtifactResolver() {
        return (ArtifactResolver)Assertions.assertNotNull((String)"Artifact resolver component is not provided by Maven", (Object)this.artifactResolver);
    }

    @Nonnull
    @MustNotContainNull
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    protected boolean doesNeedSessionLock() {
        return false;
    }

    @Nonnull
    private String makeSessionLockFileName() {
        String id = Long.toHexString(this.getSession().getStartTime().getTime()).toUpperCase(Locale.ENGLISH);
        return ".#mvn.go.session.lock." + id;
    }

    @Nonnull
    protected File getTempFileFolder() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private void lockMvnGolangSession() throws MojoExecutionException {
        File lockFile = new File(this.getTempFileFolder(), this.makeSessionLockFileName());
        this.getLog().debug((CharSequence)("Locking project for mvn-golang sync processing, locker file: " + lockFile));
        while (!Thread.currentThread().isInterrupted()) {
            boolean locked;
            try {
                locked = lockFile.createNewFile();
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Detected error during attempt to make locker file: " + lockFile, (Exception)ex);
            }
            if (locked) {
                lockFile.deleteOnExit();
                this.getLog().debug((CharSequence)("Locking file created: " + lockFile));
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void unlockMvnGolangSession() throws MojoExecutionException {
        File locker = new File(this.getTempFileFolder(), this.makeSessionLockFileName());
        this.getLog().debug((CharSequence)("Unlocking project for mvn-golang sync processing, locker file: " + locker));
        if (locker.isFile()) {
            if (!locker.delete()) {
                throw new MojoExecutionException("Can't delete locker file: " + locker);
            }
        } else {
            this.getLog().warn((CharSequence)("Can't detect locker file, may be it was removed externally: " + locker));
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private File loadSDKAndUnpackIntoCache(@Nullable ProxySettings proxySettings, @Nonnull File cacheFolder, @Nonnull String baseSdkName, boolean notLoadIfNotInCache) throws IOException, MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isFilterEnvPath() {
        return this.filterEnvPath;
    }

    @Nullable
    protected String findMvnProperty(@Nonnull String key, @Nullable String dflt) {
        if (this.session == null || this.project == null) {
            return null;
        }
        return MavenUtils.findProperty(this.session, this.project, key, dflt);
    }

    public boolean isSkip() {
        boolean result = Boolean.parseBoolean(this.findMvnProperty("mvn.golang.skip", Boolean.toString(this.skip)));
        String skipMojoSuffix = this.getSkipMojoPropertySuffix();
        return skipMojoSuffix == null ? result : result || Boolean.parseBoolean(this.findMvnProperty(String.format("mvn.golang.%s.skip", skipMojoSuffix), "false"));
    }

    public boolean isEnforceGoPathToEnd() {
        return this.enforceGoPathToEnd;
    }

    @Nonnull
    public MavenProject getProject() {
        return this.project;
    }

    @Nonnull
    public MojoExecution getExecution() {
        return this.execution;
    }

    @Nonnull
    public MavenSession getSession() {
        return this.session;
    }

    public boolean isIgnoreErrorExitCode() {
        return this.ignoreErrorExitCode;
    }

    @Nonnull
    public Map<?, ?> getEnv() {
        return (Map)GetUtils.ensureNonNull(this.env, (Object)Collections.EMPTY_MAP);
    }

    @Nullable
    public String getSdkDownloadUrl() {
        return this.sdkDownloadUrl;
    }

    @Nonnull
    public String getExecSubpath() {
        return AbstractGolangMojo.ensureNoSurroundingSlashes((String)Assertions.assertNotNull((Object)this.execSubpath));
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Nonnull
    public String getExec() {
        return AbstractGolangMojo.ensureNoSurroundingSlashes((String)Assertions.assertNotNull((Object)this.exec));
    }

    public boolean isUseEnvVars() {
        return this.useEnvVars;
    }

    public boolean isKeepSdkArchive() {
        return this.keepSdkArchive;
    }

    public boolean isKeepUnarchFolderIfError() {
        return this.keepUnarchFolderIfError;
    }

    @Nullable
    public String getSdkArchiveName() {
        return this.sdkArchiveName;
    }

    @Nonnull
    public String getReportsFolder() {
        return this.reportsFolder;
    }

    @Nullable
    public String getOutLogFile() {
        return this.outLogFile;
    }

    @Nullable
    public String getErrLogFile() {
        return this.errLogFile;
    }

    public boolean isCheckSdkHash() {
        return this.checkSdkHash;
    }

    @Nonnull
    public String getStoreFolder() {
        return this.storeFolder;
    }

    @Nullable
    public String getUseGoTool() {
        return this.useGoTool;
    }

    public boolean isVerbose() {
        return Boolean.parseBoolean(this.findMvnProperty("mvn.golang.verbose", Boolean.toString(this.verbose)));
    }

    public boolean isDisableSdkLoad() {
        return this.disableSdkLoad;
    }

    @Nonnull
    public String getSdkSite() {
        return (String)Assertions.assertNotNull((Object)this.sdkSite);
    }

    @Nonnull
    @MustNotContainNull
    public String[] getBuildFlags() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : (String[])ArrayUtils.joinArrays((Object[][])new String[][]{(String[])GetUtils.ensureNonNull((Object)this.buildFlags, (Object)ArrayUtils.EMPTY_STRING_ARRAY), this.getExtraBuildFlags()})) {
            if (this.buildFlagsToIgnore.contains(s)) continue;
            result.add(s);
        }
        result.addAll(this.tempBuildFlags);
        return result.toArray(new String[0]);
    }

    @Nonnull
    @MustNotContainNull
    protected String[] getExtraBuildFlags() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @MustNotContainNull
    public File[] findGoPath(boolean ensureExist) throws IOException {
        LOCKER.lock();
        try {
            String foundGoPath = this.getGoPath();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("findGoPath(" + ensureExist + "), getGoPath() returns " + foundGoPath));
            }
            ArrayList<File> result = new ArrayList<File>();
            for (String p : foundGoPath.split(String.format("\\%s", File.pathSeparator))) {
                File folder = new File(p);
                result.add(folder);
                if (!ensureExist || folder.isDirectory() || folder.mkdirs()) continue;
                throw new IOException("Can't create folder for GOPATH : " + folder.getAbsolutePath());
            }
            Object[] objectArray = result.toArray(new File[0]);
            return objectArray;
        }
        finally {
            LOCKER.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File findGoRootBootstrap(boolean ensureExist) throws IOException {
        LOCKER.lock();
        try {
            String value = this.getGoRootBootstrap();
            File result = null;
            if (value != null) {
                result = new File(value);
                if (ensureExist && !result.isDirectory()) {
                    throw new IOException("Can't find folder for GOROOT_BOOTSTRAP: " + result);
                }
            }
            File file = result;
            return file;
        }
        finally {
            LOCKER.unlock();
        }
    }

    @Nonnull
    public String getOs() {
        String result = this.os;
        if (AbstractGolangMojo.isSafeEmpty(result) && AbstractGolangMojo.isSafeEmpty(result)) {
            result = (String)Assertions.assertNotNull((String)String.format("Can't recognize OS: %s", SystemUtils.OS_NAME), (Object)SysUtils.findGoSdkOsType());
        }
        return result;
    }

    @Nullable
    public String getArch() {
        String result = this.arch;
        if (AbstractGolangMojo.isSafeEmpty(result)) {
            result = (String)Assertions.assertNotNull((String)String.format("Can't recognize ARCH: %s", SystemUtils.OS_ARCH), (Object)SysUtils.decodeGoSdkArchType(SystemUtils.OS_ARCH));
        }
        return result;
    }

    @Nullable
    private String getValueOrEnv(@Nonnull String varName, @Nullable String configValue) {
        String foundInEnvironment = System.getenv(varName);
        String result = configValue;
        if (foundInEnvironment != null && this.isUseEnvVars()) {
            if (!AbstractGolangMojo.isSafeEmpty(configValue)) {
                this.getLog().warn((CharSequence)String.format("Value %s is replaced by environment value.", varName));
            }
            result = foundInEnvironment;
        }
        return result;
    }

    @Nullable
    public String getGoRoot() {
        return this.getValueOrEnv("GOROOT", this.goRoot);
    }

    @Nullable
    public String getGoCache() {
        return this.getValueOrEnv("GOCACHE", this.goCache);
    }

    @Nullable
    public String getGoRootBootstrap() {
        return this.getValueOrEnv("GOROOT_BOOTSTRAP", this.goRootBootstrap);
    }

    @Nullable
    public String getGoBin() {
        String result = this.getValueOrEnv("GOBIN", this.goBin);
        return "NONE".equals(result) ? null : result;
    }

    @Nonnull
    public String getGoPath() {
        return (String)Assertions.assertNotNull((Object)this.getValueOrEnv("GOPATH", this.goPath));
    }

    @Nullable
    public String getTargetArm() {
        return this.getValueOrEnv("GOARM", this.targetArm);
    }

    @Nullable
    public String getTarget386() {
        return this.getValueOrEnv("GO386", this.target386);
    }

    @Nullable
    public String getTargetOS() {
        return this.getValueOrEnv("GOOS", this.targetOs);
    }

    @Nullable
    public String getTargetArch() {
        return this.getValueOrEnv("GOARCH", this.targetArch);
    }

    public boolean isUseMavenProxy() {
        return this.useMavenProxy;
    }

    public boolean getSupposeSdkArchiveFileName() {
        return this.supposeSdkArchiveFileName;
    }

    public boolean isDisableSslCheck() {
        return this.disableSSLcheck || Boolean.parseBoolean(MavenUtils.findProperty(this.getSession(), this.getProject(), "mvn.golang.disable.ssl.check", "false"));
    }

    public void setDisableSslCheck(boolean flag) {
        this.disableSSLcheck = flag;
    }

    @Nullable
    public ProxySettings getProxy() {
        return this.proxy;
    }

    @Nullable
    public String getOSXVersion() {
        return this.osxVersion;
    }

    @Nonnull
    public String getGoVersion() {
        return MavenUtils.findProperty(this.session, this.project, "mvn.golang.go.version", this.goVersion);
    }

    @Nonnull
    public File getSources(boolean ensureExist) throws IOException {
        File result = new File(this.sources);
        if (ensureExist && !result.isDirectory()) {
            throw new IOException("Can't find GoLang project sources : " + result);
        }
        return result;
    }

    protected void addTmpBuildFlagIfNotPresented(String ... flags) {
        for (String s : flags) {
            if (this.tempBuildFlags.contains(s)) continue;
            boolean found = false;
            if (this.buildFlags != null) {
                for (String b : this.buildFlags) {
                    if (!s.equals(b)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.tempBuildFlags.add(s);
        }
    }

    @Nonnull
    private synchronized HttpClient getHttpClient(@Nullable ProxySettings proxy) throws MojoExecutionException {
        if (this.httpClient == null) {
            HttpClientBuilder builder = HttpClients.custom();
            if (proxy != null) {
                Object[] matchers;
                String[] ignoreForAddresses;
                if (proxy.hasCredentials()) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(proxy.host, proxy.port), (Credentials)new NTCredentials((String)GetUtils.ensureNonNull((Object)proxy.username, (Object)""), proxy.password, AbstractGolangMojo.extractComputerName(), AbstractGolangMojo.extractDomainName()));
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                    this.getLog().debug((CharSequence)String.format("Credentials provider has been created for proxy (username : %s): %s", proxy.username, proxy.toString()));
                }
                String[] stringArray = ignoreForAddresses = proxy.nonProxyHosts == null ? new String[]{} : proxy.nonProxyHosts.split("\\|");
                if (ignoreForAddresses.length > 0) {
                    matchers = new WildCardMatcher[ignoreForAddresses.length];
                    for (int i = 0; i < ignoreForAddresses.length; ++i) {
                        matchers[i] = new WildCardMatcher(ignoreForAddresses[i]);
                    }
                } else {
                    matchers = new WildCardMatcher[]{};
                }
                this.getLog().debug((CharSequence)"Regular routing mode");
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxy.host, proxy.port, proxy.protocol), (WildCardMatcher[])matchers){
                    final /* synthetic */ WildCardMatcher[] val$matchers;
                    {
                        this.val$matchers = wildCardMatcherArray;
                        super(arg0);
                    }

                    @Nonnull
                    public HttpRoute determineRoute(@Nonnull HttpHost host, @Nonnull HttpRequest request, @Nonnull HttpContext context) throws HttpException {
                        HttpRoute result = null;
                        String hostName = host.getHostName();
                        for (WildCardMatcher m : this.val$matchers) {
                            if (!m.match(hostName)) continue;
                            AbstractGolangMojo.this.getLog().debug((CharSequence)("Ignoring proxy for host : " + hostName));
                            result = new HttpRoute(host);
                            break;
                        }
                        if (result == null) {
                            result = super.determineRoute(host, request, context);
                        }
                        AbstractGolangMojo.this.getLog().debug((CharSequence)("Made connection route : " + result));
                        return result;
                    }
                };
                builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                this.getLog().debug((CharSequence)("Proxy will ignore: " + Arrays.toString(matchers)));
            }
            builder.setUserAgent("mvn-golang-wrapper-agent/1.0");
            builder.disableCookieManagement();
            if (this.isDisableSslCheck()) {
                this.getLog().warn((CharSequence)"SSL certificate check is disabled");
                try {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    X509TrustManager tm = new X509TrustManager(){

                        @Override
                        @Nullable
                        @MustNotContainNull
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(@Nonnull @MustNotContainNull X509Certificate[] arg0, @Nonnull String arg1) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(@Nonnull @MustNotContainNull X509Certificate[] arg0, @Nonnull String arg1) throws CertificateException {
                        }
                    };
                    sslcontext.init(null, new TrustManager[]{tm}, null);
                    SSLConnectionSocketFactory sslfactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    Registry r = RegistryBuilder.create().register("https", (Object)sslfactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
                    builder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)r));
                    builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslfactory);
                    builder.setSSLContext(sslcontext);
                }
                catch (KeyManagementException | NoSuchAlgorithmException ex) {
                    throw new MojoExecutionException("Can't disable SSL certificate check", (Exception)ex);
                }
            } else {
                this.getLog().debug((CharSequence)"SSL check is enabled");
            }
            this.httpClient = builder.build();
        }
        return this.httpClient;
    }

    @Nullable
    private ProxySettings extractProxySettings() {
        ProxySettings result;
        if (this.isUseMavenProxy()) {
            Proxy activeMavenProxy = this.settings == null ? null : this.settings.getActiveProxy();
            result = activeMavenProxy == null ? null : new ProxySettings(activeMavenProxy);
            this.getLog().debug((CharSequence)("Detected maven proxy : " + result));
        } else {
            result = this.proxy;
            if (result != null) {
                this.getLog().debug((CharSequence)("Defined proxy : " + result));
            }
        }
        return result;
    }

    @Nonnull
    @ReturnsOriginal
    private RequestConfig.Builder processRequestConfig(@Nullable ProxySettings proxySettings, int timeout, @Nonnull RequestConfig.Builder config) {
        this.getLog().debug((CharSequence)("Connection(timeout=" + timeout + "ms, proxySettings=" + proxySettings + ')'));
        if (proxySettings != null) {
            HttpHost proxyHost = new HttpHost(proxySettings.host, proxySettings.port, proxySettings.protocol);
            config.setProxy(proxyHost);
        }
        return config.setConnectTimeout(timeout).setSocketTimeout(timeout);
    }

    @Nonnull
    private String loadGoLangSdkList(@Nullable ProxySettings proxySettings, @Nullable String keyPrefix) throws IOException, MojoExecutionException {
        String sdksite = this.getSdkSite() + (keyPrefix == null ? "" : "?prefix=" + keyPrefix);
        this.getLog().warn((CharSequence)("Loading list of available GoLang SDKs from " + sdksite));
        HttpGet get = new HttpGet(sdksite);
        RequestConfig config = this.processRequestConfig(proxySettings, this.getConnectionTimeout(), RequestConfig.custom()).build();
        get.setConfig(config);
        get.addHeader("Accept", "application/xml");
        try {
            HttpResponse response = this.getHttpClient(proxySettings).execute((HttpUriRequest)get);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                this.getLog().info((CharSequence)"GoLang SDK list has been loaded successfuly");
                this.getLog().debug((CharSequence)content);
                String string = content;
                return string;
            }
            throw new IOException(String.format("Can't load list of SDKs from %s : %d %s", sdksite, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }
        finally {
            get.releaseConnection();
        }
    }

    @Nonnull
    private Document convertSdkListToDocument(@Nonnull String sdkListAsString) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(sdkListAsString)));
        }
        catch (ParserConfigurationException ex) {
            this.getLog().error((CharSequence)"Can't configure XML parser", (Throwable)ex);
            throw new IOException("Can't configure XML parser", ex);
        }
        catch (SAXException ex) {
            this.getLog().error((CharSequence)"Can't parse document", (Throwable)ex);
            throw new IOException("Can't parse document", ex);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Unexpected IOException", (Throwable)ex);
            throw new IOException("Unexpected IOException", ex);
        }
    }

    private void printEcho() {
        if (this.echoWarn != null) {
            for (String s : this.echoWarn) {
                this.getLog().warn((CharSequence)s);
            }
        }
        if (this.echo != null) {
            for (String s : this.echo) {
                this.getLog().info((CharSequence)s);
            }
        }
    }

    protected void logOptionally(@Nonnull String message) {
        if (this.getLog().isDebugEnabled() || this.verbose) {
            this.getLog().info((CharSequence)message);
        }
    }

    protected void initConsoleBuffers() {
        this.getLog().debug((CharSequence)"Initing console out and console err buffers");
        this.consoleErrBuffer = new ByteArrayOutputStream();
        this.consoleOutBuffer = new ByteArrayOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsOriginal
    private File unpackArchToFolder(@Nonnull File archiveFile, @Nonnull String folderInArchive, @Nonnull File destinationFolder) throws IOException {
        this.getLog().info((CharSequence)String.format("Unpacking archive %s to folder %s", archiveFile.getName(), destinationFolder.getName()));
        boolean detectedError = true;
        try {
            int unpackedFileCounter = UnpackUtils.unpackFileToFolder(this.getLog(), folderInArchive, archiveFile, destinationFolder, true);
            if (unpackedFileCounter == 0) {
                throw new IOException("Couldn't find folder '" + folderInArchive + "' in archive or the archive is empty");
            }
            this.getLog().info((CharSequence)("Unpacked " + unpackedFileCounter + " file(s)"));
            detectedError = false;
        }
        finally {
            if (detectedError && !this.isKeepUnarchFolderIfError()) {
                this.logOptionally("Deleting folder because error during unpack : " + destinationFolder);
                FileUtils.deleteQuietly((File)destinationFolder);
            }
        }
        return destinationFolder;
    }

    @Nonnull
    private String extractSDKFileName(@Nonnull String listUrl, @Nonnull Document doc, @Nonnull String sdkBaseName, @Nonnull @MustNotContainNull String[] allowedExtensions) throws IOException {
        this.getLog().debug((CharSequence)("Looking for SDK started with base name : " + sdkBaseName));
        HashSet<String> variants = new HashSet<String>();
        for (String ext : allowedExtensions) {
            variants.add(sdkBaseName + '.' + ext);
        }
        ArrayList<String> listedSdk = new ArrayList<String>();
        Element root = doc.getDocumentElement();
        if ("ListBucketResult".equals(root.getTagName())) {
            NodeList list = root.getElementsByTagName("Contents");
            for (int i = 0; i < list.getLength(); ++i) {
                Element element = (Element)list.item(i);
                NodeList keys = element.getElementsByTagName("Key");
                if (keys.getLength() <= 0) continue;
                String text = keys.item(0).getTextContent();
                if (variants.contains(text)) {
                    this.logOptionally("Detected compatible SDK in the SDK list : " + text);
                    return text;
                }
                listedSdk.add(text);
            }
            if (this.supposeSdkArchiveFileName) {
                String supposedSdkName = sdkBaseName + '.' + (SystemUtils.IS_OS_WINDOWS ? "zip" : "tar.gz");
                this.getLog().warn((CharSequence)"Can't find SDK file in the loaded list");
                this.getLog().debug((CharSequence)"..................................................");
                for (String s : listedSdk) {
                    this.getLog().debug((CharSequence)s);
                }
                this.getLog().debug((CharSequence)"..................................................");
                this.getLog().warn((CharSequence)("Supposed name of SDK archive is " + supposedSdkName + ", trying to load it directly! It can be disabled with <supposeSdkArchiveFileName>false</supposeSdkArchiveFileName>)"));
                return supposedSdkName;
            }
            this.getLog().error((CharSequence)("Can't find any SDK to be used as " + sdkBaseName));
            this.getLog().error((CharSequence)("GoLang list contains listed SDKs (" + listUrl + ")"));
            this.getLog().error((CharSequence)"It is possible directly define link to SDK through configuration parameter <sdkDownloadUrl>..</sdkDownloadUrl>");
            this.getLog().error((CharSequence)"..................................................");
            for (String s : listedSdk) {
                this.getLog().error((CharSequence)s);
            }
            throw new IOException("Can't find SDK : " + sdkBaseName);
        }
        throw new IOException("It is not a ListBucket file [" + root.getTagName() + ']');
    }

    @Nonnull
    private String findSdkArchiveFileName(@Nullable ProxySettings proxySettings, @Nonnull String sdkBaseName) throws IOException, MojoExecutionException {
        String result = this.getSdkArchiveName();
        if (AbstractGolangMojo.isSafeEmpty(result)) {
            Document parsed = this.convertSdkListToDocument(this.loadGoLangSdkList(proxySettings, URLEncoder.encode(sdkBaseName, "UTF-8")));
            result = this.extractSDKFileName(this.getSdkSite(), parsed, sdkBaseName, new String[]{"tar.gz", "zip"});
        } else {
            this.getLog().info((CharSequence)("SDK archive name is predefined : " + result));
        }
        return GetUtils.ensureNonNullStr((String)result);
    }

    private void warnIfContainsUC(@Nonnull String message, @Nonnull String str) {
        boolean detected = false;
        for (char c : str.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            detected = true;
            break;
        }
        if (detected) {
            this.getLog().warn((CharSequence)(message + " : " + str));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected File findGoRoot(@Nullable ProxySettings proxySettings) throws IOException, MojoFailureException, MojoExecutionException {
        File result;
        LOCKER.lock();
        try {
            String predefinedGoRoot = this.getGoRoot();
            if (AbstractGolangMojo.isSafeEmpty(predefinedGoRoot)) {
                File cacheFolder = new File(this.storeFolder);
                if (!cacheFolder.isDirectory()) {
                    if (cacheFolder.isFile()) {
                        throw new IOException("Can't create folder '" + cacheFolder + "' because there is presented a file with such name!");
                    }
                    this.logOptionally("Making SDK cache folder : " + cacheFolder);
                    FileUtils.forceMkdir((File)cacheFolder);
                }
                String definedOsxVersion = this.getOSXVersion();
                String sdkVersion = this.getGoVersion();
                this.getLog().debug((CharSequence)String.format("SdkVersion = %s, osxVersion = %s", sdkVersion, definedOsxVersion));
                if (AbstractGolangMojo.isSafeEmpty(sdkVersion)) {
                    throw new MojoFailureException("GoLang SDK version is not defined!");
                }
                String sdkBaseName = String.format(NAME_PATTERN, sdkVersion, this.getOs(), this.getArch(), AbstractGolangMojo.isSafeEmpty(definedOsxVersion) ? "" : "-" + definedOsxVersion);
                this.warnIfContainsUC("Prefer usage of lower case chars only for SDK base name", sdkBaseName);
                result = this.loadSDKAndUnpackIntoCache(proxySettings, cacheFolder, sdkBaseName, this.isDisableSdkLoad());
            } else {
                this.logOptionally("Detected predefined SDK root folder : " + predefinedGoRoot);
                result = new File(predefinedGoRoot);
                if (!result.isDirectory()) {
                    throw new MojoFailureException("Predefined SDK root is not a directory : " + result);
                }
            }
        }
        finally {
            LOCKER.unlock();
        }
        return result;
    }

    private void printBanner() {
        for (String s : BANNER) {
            this.getLog().info((CharSequence)s);
        }
    }

    public boolean isHideBanner() {
        return this.hideBanner;
    }

    protected boolean doesNeedOneMoreAttempt(@Nonnull ProcessResult result, @Nonnull String consoleOut, @Nonnull String consoleErr) throws IOException, MojoExecutionException {
        return false;
    }

    protected boolean doMainBusiness(@Nullable ProxySettings proxySettings, int maxAttempts) throws InterruptedException, MojoFailureException, MojoExecutionException, IOException {
        int iterations = 0;
        boolean error = false;
        while (!Thread.currentThread().isInterrupted()) {
            ProcessExecutor executor = this.prepareExecutor(proxySettings);
            if (executor == null) {
                this.logOptionally("The Mojo should not be executed");
                break;
            }
            ProcessResult result = executor.executeNoTimeout();
            int resultCode = result.getExitValue();
            error = resultCode != 0 && !this.isIgnoreErrorExitCode();
            ++iterations;
            String outLog = this.extractOutAsString();
            String errLog = this.extractErrorOutAsString();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("OUT_LOG: " + outLog));
                this.getLog().debug((CharSequence)("ERR_LOG: " + errLog));
            }
            this.processConsoleOut(resultCode, outLog, errLog);
            this.printLogs(error || this.isEnforcePrintOutput() || this.isVerbose() && this.isCommandSupportVerbose(), error, outLog, errLog);
            if (this.doesNeedOneMoreAttempt(result, outLog, errLog)) {
                if (iterations > maxAttempts) {
                    throw new MojoExecutionException("Too many iterations detected, may be some loop and bug at mojo " + ((Object)((Object)this)).getClass().getName());
                }
                this.getLog().warn((CharSequence)"Make one more attempt...");
                continue;
            }
            if (this.isIgnoreErrorExitCode()) break;
            this.assertProcessResult(result);
            break;
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        block14: {
            block15: {
                if (!this.isSkip()) break block15;
                this.getLog().info((CharSequence)"Skipping mvn-golang execution");
                break block14;
            }
            if (this.doesNeedSessionLock()) {
                this.lockMvnGolangSession();
                if (Thread.currentThread().isInterrupted()) {
                    throw new MojoFailureException("Current thread is interrupted");
                }
            }
            try {
                if (!this.isHideBanner()) {
                    this.printBanner();
                }
                this.doInit();
                this.printEcho();
                ProxySettings proxySettings = this.extractProxySettings();
                this.beforeExecution(proxySettings);
                Throwable exception = null;
                boolean errorDuringMainBusiness = false;
                try {
                    errorDuringMainBusiness = this.doMainBusiness(proxySettings, 10);
                    this.afterExecution(null, errorDuringMainBusiness || exception != null);
                }
                catch (IOException | InterruptedException | MojoExecutionException | MojoFailureException ex) {
                    try {
                        if (ex instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        exception = ex;
                        this.afterExecution(null, errorDuringMainBusiness || exception != null);
                    }
                    catch (Throwable throwable) {
                        this.afterExecution(null, errorDuringMainBusiness || exception != null);
                        throw throwable;
                    }
                }
                if (exception != null) {
                    throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
                }
                if (errorDuringMainBusiness) {
                    throw new MojoFailureException("Mojo execution failed, see log");
                }
            }
            finally {
                if (this.doesNeedSessionLock()) {
                    this.unlockMvnGolangSession();
                }
            }
        }
    }

    public void doInit() throws MojoFailureException, MojoExecutionException {
    }

    public void beforeExecution(@Nullable ProxySettings proxySettings) throws MojoFailureException, MojoExecutionException {
    }

    public void afterExecution(@Nullable ProxySettings proxySettings, boolean error) throws MojoFailureException, MojoExecutionException {
    }

    public boolean isEnforcePrintOutput() {
        return false;
    }

    @Nonnull
    private String extractOutAsString() {
        return new String(this.consoleOutBuffer.toByteArray(), Charset.defaultCharset());
    }

    @Nonnull
    private String extractErrorOutAsString() {
        return new String(this.consoleErrBuffer.toByteArray(), Charset.defaultCharset());
    }

    protected void printLogs(boolean forcePrint, boolean errorDetected, @Nonnull String outLog, @Nonnull String errLog) {
        boolean errLogNotEmpty;
        boolean outLogNotEmpty = !outLog.isEmpty();
        boolean bl = errLogNotEmpty = !errLog.isEmpty();
        if (outLogNotEmpty) {
            if (forcePrint || this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"---------Exec.Out---------");
                for (String str : outLog.split("\n")) {
                    this.getLog().info((CharSequence)StrUtils.trimRight((String)str));
                }
                this.getLog().info((CharSequence)"");
            } else {
                this.getLog().debug((CharSequence)"There is not any log out from the process");
            }
        }
        if (errLogNotEmpty) {
            if (forcePrint) {
                if (errorDetected) {
                    this.getLog().error((CharSequence)"");
                    this.getLog().error((CharSequence)"---------Exec.Err---------");
                    for (String str : errLog.split("\n")) {
                        this.getLog().error((CharSequence)StrUtils.trimRight((String)str));
                    }
                    this.getLog().error((CharSequence)"");
                } else {
                    this.getLog().warn((CharSequence)"");
                    this.getLog().warn((CharSequence)"---------Exec.Err---------");
                    for (String str : errLog.split("\n")) {
                        this.getLog().warn((CharSequence)StrUtils.trimRight((String)str));
                    }
                    this.getLog().warn((CharSequence)"");
                }
            } else {
                this.getLog().debug((CharSequence)"---------Exec.Err---------");
                for (String str : errLog.split("\n")) {
                    this.getLog().debug((CharSequence)StrUtils.trimRight((String)str));
                }
            }
        } else {
            this.getLog().debug((CharSequence)"Error log buffer is empty");
        }
    }

    private void assertProcessResult(@Nonnull ProcessResult result) throws MojoFailureException {
        int code = result.getExitValue();
        if (code != 0) {
            throw new MojoFailureException("Process exit code : " + code);
        }
    }

    public boolean isSourceFolderRequired() {
        return false;
    }

    public boolean isMojoMustNotBeExecuted() throws MojoFailureException {
        try {
            return this.isSourceFolderRequired() && !this.getSources(false).isDirectory();
        }
        catch (IOException ex) {
            throw new MojoFailureException("Can't check source folder", (Throwable)ex);
        }
    }

    @Nonnull
    @MustNotContainNull
    public abstract String[] getTailArguments();

    @Nonnull
    @MustNotContainNull
    public String[] getOptionalExtraTailArguments() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Nonnull
    public String makeExecutableFileSubpath() {
        return this.getExecSubpath() + File.separatorChar + this.getExec();
    }

    @Nonnull
    public abstract String getGoCommand();

    @Nonnull
    @MustNotContainNull
    public abstract String[] getCommandFlags();

    @Nullable
    private String getEnvPath() {
        String path = System.getenv("PATH");
        if (path == null) {
            this.getLog().warn((CharSequence)"Can't find any defined PATH in environment");
        } else {
            this.getLog().debug((CharSequence)("Found env.PATH: " + path));
        }
        boolean filter = this.isFilterEnvPath();
        if (path != null) {
            StringBuilder buffer = new StringBuilder();
            for (String s : path.split(Pattern.quote(File.pathSeparator))) {
                if (filter && GOBINFOLDER_PATTERN.matcher(s).find()) {
                    this.getLog().debug((CharSequence)("Removing item '" + s + "' from PATH because it looks like go/bin"));
                    continue;
                }
                if (buffer.length() > 0) {
                    buffer.append(File.pathSeparator);
                }
                buffer.append(s);
                this.getLog().debug((CharSequence)("Add item '" + s + "' to PATH"));
            }
            path = buffer.toString();
        }
        this.getLog().debug((CharSequence)("Prepared PATH var content:" + path));
        return path;
    }

    private void addEnvVar(@Nonnull ProcessExecutor executor, @Nonnull String name, @Nonnull String value) {
        this.logOptionally(" $" + name + " = " + value);
        executor.environment(name, value);
    }

    @Nullable
    protected ProcessExecutor prepareExecutor(@Nullable ProxySettings proxySettings) throws IOException, MojoFailureException, MojoExecutionException {
        File executableFileInPathOrRoot;
        this.initConsoleBuffers();
        String execNameAdaptedForOs = AbstractGolangMojo.adaptExecNameForOS(this.makeExecutableFileSubpath());
        File detectedRoot = this.findGoRoot(proxySettings);
        String gobin = this.getGoBin();
        String gocache = this.getGoCache();
        File[] gopathParts = this.findGoPath(true);
        if (this.isMojoMustNotBeExecuted()) {
            return null;
        }
        String toolName = FilenameUtils.normalize((String)((String)GetUtils.ensureNonNull((Object)this.getUseGoTool(), (Object)execNameAdaptedForOs)));
        File executableFileInBin = gobin == null ? null : new File(AbstractGolangMojo.getPathToFolder(gobin) + AbstractGolangMojo.adaptExecNameForOS(this.getExec()));
        Object[] exeVariants = new File[]{executableFileInBin, executableFileInPathOrRoot = new File(AbstractGolangMojo.getPathToFolder(detectedRoot) + toolName)};
        File foundExecutableTool = AbstractGolangMojo.findExisting((File[])exeVariants);
        if (foundExecutableTool == null) {
            throw new MojoFailureException("Can't find executable file : " + Arrays.toString(exeVariants));
        }
        this.logOptionally("Executable file detected : " + foundExecutableTool);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(foundExecutableTool.getAbsolutePath());
        String gocommand = this.getGoCommand();
        if (!gocommand.isEmpty()) {
            commandLine.add(this.getGoCommand());
        }
        boolean verboseAdded = false;
        for (String s : this.getCommandFlags()) {
            if (s.equals("-v")) {
                verboseAdded = true;
            }
            commandLine.add(s);
        }
        if (this.isVerbose() && !verboseAdded && this.isCommandSupportVerbose()) {
            commandLine.add("-v");
        }
        commandLine.addAll(Arrays.asList(this.getBuildFlags()));
        commandLine.addAll(Arrays.asList(this.getTailArguments()));
        commandLine.addAll(Arrays.asList(this.getOptionalExtraTailArguments()));
        StringBuilder cli = new StringBuilder();
        int index = 0;
        for (String s : commandLine) {
            if (cli.length() > 0) {
                cli.append(' ');
            }
            if (index == 0) {
                cli.append(execNameAdaptedForOs);
            } else {
                cli.append(s);
            }
            ++index;
        }
        this.getLog().info((CharSequence)String.format("Prepared command line : %s", cli.toString()));
        ProcessExecutor result = new ProcessExecutor(commandLine);
        File workingDirectory = this.getWorkingDirectoryForExecutor();
        if (workingDirectory.isDirectory()) {
            this.logOptionally("Working directory: " + workingDirectory);
            result.directory(workingDirectory);
        } else {
            this.logOptionally("Working directory is not set because provided folder doesn't exist: " + workingDirectory);
        }
        this.logOptionally("");
        this.registerEnvVars(result, detectedRoot, gobin, gocache, this.getSources(this.isSourceFolderRequired()), gopathParts);
        this.logOptionally("........................");
        this.registerOutputBuffers(result);
        return result;
    }

    protected void registerOutputBuffers(@Nonnull ProcessExecutor executor) {
        executor.redirectOutput((OutputStream)this.consoleOutBuffer);
        executor.redirectError((OutputStream)this.consoleErrBuffer);
    }

    protected void registerEnvVars(@Nonnull ProcessExecutor result, @Nonnull File theGoRoot, @Nullable String theGoBin, @Nullable String theGoCache, @Nonnull File sourcesFile, @Nonnull @MustNotContainNull File[] goPathParts) throws IOException {
        File gorootbootstrap;
        this.logOptionally("....Environment vars....");
        this.addEnvVar(result, "GOROOT", theGoRoot.getAbsolutePath());
        this.project.getProperties().setProperty("mvn.golang.last.goroot", theGoRoot.getAbsolutePath());
        String preparedGoPath = IOUtils.makeOsFilePathWithoutDuplications(goPathParts);
        preparedGoPath = this.isEnforceGoPathToEnd() ? IOUtils.makeOsFilePathWithoutDuplications(this.makePathFromExtraGoPathElements(), AbstractGolangMojo.removeSrcFolderAtEndIfPresented(sourcesFile.getAbsolutePath()), this.getSpecialPartOfGoPath(), preparedGoPath) : IOUtils.makeOsFilePathWithoutDuplications(preparedGoPath, this.makePathFromExtraGoPathElements(), AbstractGolangMojo.removeSrcFolderAtEndIfPresented(sourcesFile.getAbsolutePath()), this.getSpecialPartOfGoPath());
        this.addEnvVar(result, "GOPATH", preparedGoPath);
        this.project.getProperties().setProperty("mvn.golang.last.gopath", preparedGoPath);
        if (theGoBin == null) {
            this.getLog().warn((CharSequence)"GOBIN is disabled by direct order");
        } else {
            this.addEnvVar(result, "GOBIN", theGoBin);
            this.project.getProperties().setProperty("mvn.golang.last.gobin", theGoBin);
        }
        if (theGoBin == null) {
            this.getLog().warn((CharSequence)"GOCACHE is not provided by direct order");
        } else {
            this.addEnvVar(result, "GOCACHE", theGoCache);
            this.project.getProperties().setProperty("mvn.golang.last.gocache", theGoCache);
        }
        String trgtOs = this.getTargetOS();
        String trgtArch = this.getTargetArch();
        String trgtArm = this.getTargetArm();
        String trgt386 = this.getTarget386();
        if (trgt386 != null) {
            this.addEnvVar(result, "GO386", trgt386);
            this.project.getProperties().setProperty("mvn.golang.last.go386", trgt386);
        }
        if (trgtOs != null) {
            this.addEnvVar(result, "GOOS", trgtOs);
            this.project.getProperties().setProperty("mvn.golang.last.goos", trgtOs);
        }
        if (trgtArm != null) {
            this.addEnvVar(result, "GOARM", trgtArm);
            this.project.getProperties().setProperty("mvn.golang.last.goarm", trgtArm);
        }
        if (trgtArch != null) {
            this.addEnvVar(result, "GOARCH", trgtArch);
            this.project.getProperties().setProperty("mvn.golang.last.goarch", trgtArch);
        }
        if ((gorootbootstrap = this.findGoRootBootstrap(true)) != null) {
            this.addEnvVar(result, "GOROOT_BOOTSTRAP", gorootbootstrap.getAbsolutePath());
            this.project.getProperties().setProperty("mvn.golang.last.goroot_bootstrap", gorootbootstrap.getAbsolutePath());
        }
        String thePath = (String)GetUtils.ensureNonNull((Object)this.getEnvPath(), (Object)"");
        thePath = IOUtils.makeOsFilePathWithoutDuplications(theGoRoot + File.separator + this.getExecSubpath(), thePath, theGoBin);
        this.addEnvVar(result, "PATH", thePath);
        this.project.getProperties().setProperty("mvn.golang.last.path", thePath);
        boolean go111moduleDetected = false;
        for (Map.Entry<?, ?> record : this.getEnv().entrySet()) {
            if (ENV_GO111MODULE.equals(record.getKey().toString())) {
                go111moduleDetected = true;
            }
            this.addEnvVar(result, record.getKey().toString(), record.getValue().toString());
        }
        if (this.isModuleMode()) {
            if (go111moduleDetected) {
                this.getLog().warn((CharSequence)String.format("Module mode is true but %s detected among custom environment parameters", ENV_GO111MODULE));
            } else {
                this.getLog().warn((CharSequence)String.format("Forcing '%s = on' because module mode is activated", ENV_GO111MODULE));
                this.addEnvVar(result, ENV_GO111MODULE, "on");
            }
        }
    }

    @Nonnull
    @MustNotContainNull
    protected List<File> findAllGoModsInFolder(@Nonnull @MustNotContainNull File folder) throws IOException {
        return new ArrayList<File>(FileUtils.listFiles((File)folder, (IOFileFilter)FileFilterUtils.nameFileFilter((String)GO_MOD_FILE_NAME), (IOFileFilter)TrueFileFilter.INSTANCE));
    }

    @Nonnull
    protected File getWorkingDirectoryForExecutor() throws IOException {
        String forcedWorkingDirdir = this.getWorkingDir();
        if (forcedWorkingDirdir != null) {
            File result = new File(forcedWorkingDirdir);
            if (!result.isDirectory()) {
                throw new IOException("Working directory doesn't exist: " + result);
            }
            return result;
        }
        if (this.isModuleMode()) {
            File srcFolder = this.getSources(false);
            if (srcFolder.isDirectory()) {
                List<File> foundGoMods = this.findAllGoModsInFolder(srcFolder);
                this.getLog().debug((CharSequence)String.format("Detected %d go.mod files in source folder %s", foundGoMods.size(), srcFolder));
                foundGoMods.sort(Comparator.comparing(File::toString));
                if (foundGoMods.isEmpty()) {
                    this.getLog().error((CharSequence)("Module mode is activated but there is no any go.mod file in the source folder: " + srcFolder));
                    throw new IOException("Can't find any go.mod folder in the source folder: " + srcFolder);
                }
                File gomodFolder = foundGoMods.get(0).getParentFile();
                this.getLog().info((CharSequence)String.format("Detected module folder '%s' to be used as working folder", gomodFolder));
                return gomodFolder;
            }
            this.getLog().debug((CharSequence)("Source folder is not found: " + srcFolder));
        }
        return this.getSources(this.isSourceFolderRequired());
    }

    @Nonnull
    protected String getSpecialPartOfGoPath() {
        return "";
    }

    @Nonnull
    protected String makePathFromExtraGoPathElements() {
        String result = "";
        if (this.addToGoPath != null) {
            result = IOUtils.makeOsFilePathWithoutDuplications(this.addToGoPath);
        }
        return result;
    }

    public boolean isCommandSupportVerbose() {
        return false;
    }

    @Nullable
    protected String getSkipMojoPropertySuffix() {
        return null;
    }

    protected void processConsoleOut(int exitCode, @Nonnull String out, @Nonnull String err) throws MojoFailureException, MojoExecutionException {
        File fileToWriteErr;
        File reportsFolderFile = new File(this.getReportsFolder());
        String fileOut = this.getOutLogFile();
        String fileErr = this.getErrLogFile();
        File fileToWriteOut = fileOut == null || fileOut.trim().isEmpty() ? null : new File(reportsFolderFile, fileOut);
        File file = fileToWriteErr = fileErr == null || fileErr.trim().isEmpty() ? null : new File(reportsFolderFile, fileErr);
        if (fileToWriteOut != null) {
            this.getLog().debug((CharSequence)("Reports folder : " + reportsFolderFile));
            if (!reportsFolderFile.isDirectory() && !reportsFolderFile.mkdirs()) {
                throw new MojoExecutionException("Can't create folder for console logs : " + reportsFolderFile);
            }
            try {
                this.getLog().debug((CharSequence)("Writing out console log : " + fileToWriteErr));
                FileUtils.write((File)fileToWriteOut, (CharSequence)out, (String)"UTF-8");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't save console output log into file : " + fileToWriteOut, (Exception)ex);
            }
        }
        if (fileToWriteErr != null) {
            this.getLog().debug((CharSequence)("Reports folder : " + reportsFolderFile));
            if (!reportsFolderFile.isDirectory() && !reportsFolderFile.mkdirs()) {
                throw new MojoExecutionException("Can't create folder for console logs : " + reportsFolderFile);
            }
            try {
                this.getLog().debug((CharSequence)("Writing error console log : " + fileToWriteErr));
                FileUtils.write((File)fileToWriteErr, (CharSequence)err, (String)"UTF-8");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't save console error log into file : " + fileToWriteErr, (Exception)ex);
            }
        }
    }
}

