/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.mvngolang.AbstractModuleAware;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="list", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GolangListMojo
extends AbstractModuleAware {
    @Parameter(name="format")
    private String format = null;
    @Parameter(name="json")
    private boolean json;
    @Parameter(name="listModules")
    private boolean listModules;

    public boolean isListModules() {
        return this.listModules;
    }

    public boolean isJson() {
        return this.json;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    protected String[] getAdditionalCommandFlags() {
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, super.getAdditionalCommandFlags());
        if (this.getFormat() != null && this.getFormat().trim().length() != 0) {
            if (result.contains("-f")) {
                this.getLog().warn((CharSequence)"Format ignored because detected already defined '-f' option");
            } else {
                result.add("-f");
                result.add(this.getFormat().trim());
            }
        }
        if (this.isJson()) {
            if (result.contains("-json")) {
                this.getLog().warn((CharSequence)"Json flag ignored because detected already defined '-json' option");
            } else {
                result.add("-json");
            }
        }
        if (this.isListModules()) {
            if (result.contains("-m")) {
                this.getLog().warn((CharSequence)"Module flag ignored because detected already defined '-m' option");
            } else {
                result.add("-m");
            }
        }
        return result.toArray(new String[0]);
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Override
    @Nullable
    protected String getSkipMojoPropertySuffix() {
        return "list";
    }

    @Override
    @Nonnull
    public String getGoCommand() {
        return "list";
    }
}

