/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PackageList {
    private static final String DIRECTIVE_INCLUDE = "#include";
    private final List<Package> packages;

    public PackageList(@Nonnull @MustNotContainNull File file, @Nonnull String text, @Nonnull ContentProvider contentProvider) throws ParseException, IOException {
        ArrayList<Package> list = new ArrayList<Package>();
        for (String s : text.split("\\n")) {
            String trimmed = s.trim();
            if (trimmed.isEmpty() || trimmed.startsWith("//")) continue;
            if (trimmed.startsWith(DIRECTIVE_INCLUDE)) {
                String filePath = PackageList.removeQuotes(PackageList.removeComment(trimmed.substring(DIRECTIVE_INCLUDE.length()).trim(), true));
                File includeFile = new File(file, filePath);
                String includedText = contentProvider.readContent(includeFile);
                list.addAll(new PackageList(includeFile, includedText, contentProvider).getPackages());
                continue;
            }
            list.add(new Package(trimmed));
        }
        this.packages = Collections.unmodifiableList(list);
    }

    @Nonnull
    static String removeComment(@Nonnull String text, boolean checkQuotes) {
        int pos = -1;
        boolean quot = false;
        boolean found = false;
        block4: for (int i = 0; i < text.length() && !found; ++i) {
            switch (text.charAt(i)) {
                case '\"': {
                    quot = !quot;
                    pos = -1;
                    continue block4;
                }
                case '/': {
                    if (checkQuotes && quot) continue block4;
                    if (pos < 0) {
                        pos = i;
                        continue block4;
                    }
                    found = true;
                    continue block4;
                }
                default: {
                    pos = -1;
                }
            }
        }
        return found ? text.substring(0, pos) : text;
    }

    @Nonnull
    static String removeQuotes(@Nonnull String text) {
        String result = text;
        if (text.length() > 1 && text.startsWith("\"") && text.endsWith("\"")) {
            result = text.substring(1, text.length() - 1);
        }
        return result;
    }

    @Nonnull
    @MustNotContainNull
    public List<Package> getPackages() {
        return this.packages;
    }

    public static final class Package {
        private static final String TAG_PACKAGE = "package";
        private static final String TAG_BRANCH = "branch";
        private static final String TAG_TAG = "tag";
        private static final String TAG_REVISION = "revision";
        private static final Set<String> ALLOWED_KEYS = new HashSet<String>(Arrays.asList("branch", "package", "revision", "tag"));
        private final String pkg;
        private final String branch;
        private final String tag;
        private final String revision;
        private final Pattern PATTERN = Pattern.compile("(?:\\s*([^:\\s]+)\\s*:\\s*([^,\\s]+)\\s*(?:,|$)?)|(.+?)", 2);

        public Package(@Nonnull String pkg, @Nullable String branch, @Nullable String tag, @Nullable String revision) {
            this.pkg = (String)Assertions.assertNotNull((Object)pkg);
            this.branch = branch;
            this.revision = revision;
            this.tag = tag;
        }

        private Package(@Nonnull String textLine) throws ParseException {
            textLine = PackageList.removeComment(textLine, false);
            Matcher matcher = this.PATTERN.matcher(textLine);
            HashMap<String, String> map = new HashMap<String, String>();
            while (matcher.find()) {
                String unknown = matcher.group(3);
                if (unknown != null) {
                    throw new ParseException(textLine, matcher.start(3));
                }
                String name = matcher.group(1).trim().toLowerCase(Locale.ENGLISH);
                String value = matcher.group(2).trim();
                if (!ALLOWED_KEYS.contains(name)) {
                    throw new IllegalArgumentException("Unsupported key: " + name);
                }
                if (map.containsKey(name)) {
                    throw new ParseException(textLine, matcher.start(1));
                }
                map.put(name, value);
            }
            if (!matcher.hitEnd()) {
                throw new ParseException(textLine, 0);
            }
            if (!map.containsKey(TAG_PACKAGE)) {
                throw new IllegalArgumentException("Can't find package name : " + textLine);
            }
            this.pkg = (String)map.get(TAG_PACKAGE);
            if (this.pkg.isEmpty()) {
                throw new IllegalArgumentException("Empty package name : " + textLine);
            }
            this.branch = (String)map.get(TAG_BRANCH);
            this.tag = (String)map.get(TAG_TAG);
            this.revision = (String)map.get(TAG_REVISION);
        }

        @Nonnull
        public String makeString() {
            return "package: " + this.pkg + ",branch: " + this.branch + ",tag: " + this.tag + ",revision: " + this.revision;
        }

        public boolean doesNeedCvsProcessing() {
            return this.branch != null || this.tag != null || this.revision != null;
        }

        @Nonnull
        public String getPackage() {
            return this.pkg;
        }

        @Nullable
        public String getBranch() {
            return this.branch;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getRevision() {
            return this.revision;
        }

        @Nonnull
        public String toString() {
            return this.pkg;
        }
    }

    public static interface ContentProvider {
        @Nonnull
        public String readContent(@Nonnull File var1) throws IOException;
    }
}

