/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.ArrayUtils;
import com.igormaznitsa.mvngolang.AbstractGoPackageAndDependencyAwareMojo;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractModuleAware
extends AbstractGoPackageAndDependencyAwareMojo {
    @Parameter(name="mod")
    protected String mod = null;

    @Nullable
    public String getMod() {
        return this.findMvnProperty("mvn.golang.module.mod", this.mod);
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public final String[] getCommandFlags() {
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, this.getAdditionalCommandFlags());
        String moduleMod = this.getMod();
        if (moduleMod != null && moduleMod.trim().length() != 0) {
            if (result.stream().anyMatch(x -> x.startsWith("-mod="))) {
                this.getLog().warn((CharSequence)"Detected direct 'mod' flag, configuration 'mod' option will be ignored");
            } else {
                this.getLog().debug((CharSequence)("Detected mod value: " + moduleMod));
                result.add(0, String.format("-mod=%s", moduleMod.trim()));
            }
        }
        return result.toArray(new String[0]);
    }

    @Nonnull
    @MustNotContainNull
    protected String[] getAdditionalCommandFlags() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

