/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.utils;

import com.igormaznitsa.meta.annotation.MayContainNull;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IOUtils {
    private IOUtils() {
    }

    public static int printTextProgressBar(@Nonnull String text, long value, long maxValue, int progressBarWidth, int lastValue) {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("\r\u001b[?25l");
        builder.append(text);
        builder.append("[");
        int progress = Math.max(0, Math.min(progressBarWidth, (int)Math.round((double)progressBarWidth * ((double)value / (double)maxValue))));
        for (i = 0; i < progress; ++i) {
            builder.append('\u2592');
        }
        for (i = progress; i < progressBarWidth; ++i) {
            builder.append('-');
        }
        builder.append("]\u001b[?25h");
        if (progress != lastValue) {
            System.out.print(builder);
            System.out.flush();
        }
        return progress;
    }

    @Nonnull
    public static String makeOsFilePathWithoutDuplications(@Nonnull @MayContainNull File[] files) {
        StringBuilder result = new StringBuilder();
        HashSet<File> alreadyAdded = new HashSet<File>();
        for (File f : files) {
            if (f == null || alreadyAdded.contains(f)) continue;
            alreadyAdded.add(f);
            if (result.length() > 0) {
                result.append(File.pathSeparatorChar);
            }
            result.append(f.getAbsolutePath());
        }
        return result.toString();
    }

    @Nonnull
    public static String makeOsFilePathWithoutDuplications(String ... paths) {
        StringBuilder result = new StringBuilder();
        HashSet<String> alreadyAdded = new HashSet<String>();
        for (String s : paths) {
            if (s == null || s.isEmpty() || alreadyAdded.contains(s)) continue;
            alreadyAdded.add(s);
            if (result.length() > 0) {
                result.append(File.pathSeparatorChar);
            }
            result.append(s);
        }
        return result.toString();
    }

    public static void closeSilently(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

