/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.mvnjlink.exceptions.IORuntimeWrapperException;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.HttpUtils;
import com.igormaznitsa.mvnjlink.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractJdkProvider {
    protected static final Pattern ETAG_PATTERN = Pattern.compile("^\"?([a-fA-F0-9]{32}).*\"?$");
    protected final AbstractJdkToolMojo mojo;

    public AbstractJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        this.mojo = (AbstractJdkToolMojo)((Object)Assertions.assertNotNull((Object)((Object)mojo)));
    }

    @Nonnull
    private static String hideSensitiveText(@Nonnull String text) {
        return text.charAt(0) + "_____" + text.charAt(text.length() - 1);
    }

    @Nonnull
    protected Function<HttpRequestBase, HttpRequestBase> tuneRequestBase(@Nullable String authorization) {
        return x -> {
            if (authorization != null && !authorization.isEmpty()) {
                this.mojo.getLog().info((CharSequence)("Providing authorization header: " + AbstractJdkProvider.hideSensitiveText(authorization)));
                x.setHeader("Authorization", authorization);
            }
            return x;
        };
    }

    @Nullable
    protected Function<HttpClientBuilder, HttpClientBuilder> tuneClient(@Nullable String authorization) {
        return x -> x;
    }

    protected static void assertParameters(@Nonnull Map<String, String> attrMap, String ... names) {
        Optional<String> notFoundAttribute = Stream.of(names).filter(x -> !attrMap.containsKey(x)).findAny();
        if (notFoundAttribute.isPresent()) {
            throw new IllegalArgumentException(String.format("Parameter named '%s' must be presented", notFoundAttribute.get()));
        }
    }

    @Nonnull
    protected static String calcSha256ForFile(@Nonnull Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            String string = DigestUtils.sha256Hex((InputStream)in);
            return string;
        }
    }

    @Nonnull
    protected File lockCache(@Nonnull Path cacheFolder, @Nonnull String jdkId) throws IOException {
        Log log = this.mojo.getLog();
        File lockFile = cacheFolder.resolve(".#" + jdkId).toFile();
        lockFile.deleteOnExit();
        if (!lockFile.createNewFile()) {
            boolean locked = false;
            log.info((CharSequence)"Detected existing lock, waiting for unlocking");
            while (!Thread.currentThread().isInterrupted() && !(locked = lockFile.createNewFile())) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    log.warn((CharSequence)"Process interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            if (!locked) {
                throw new IOException("Can't lock folder");
            }
        }
        return lockFile;
    }

    protected boolean isOfflineMode() {
        return this.mojo.isOfflineModeActive();
    }

    @Nonnull
    protected String findCurrentOs(@Nonnull String macOsId) {
        String defaultOs = SystemUtils.IS_OS_MAC ? macOsId : (SystemUtils.IS_OS_WINDOWS ? "windows" : (SystemUtils.IS_OS_AIX ? "aix" : (SystemUtils.IS_OS_FREE_BSD ? "freebsd" : (SystemUtils.IS_OS_IRIX ? "irix" : (SystemUtils.IS_OS_ZOS ? "zos" : "linux")))));
        return defaultOs;
    }

    @Nonnull
    protected String doHttpGetText(@Nonnull HttpClient client, @Nullable Function<HttpRequestBase, HttpRequestBase> customizer, @Nonnull String url, int connectionRequestTimeout, String ... acceptedContent) throws IOException {
        AtomicReference result = new AtomicReference();
        HttpUtils.doGetRequest(client, customizer, url, this.mojo.getProxy(), x -> this.logRateLimitIfPresented(url, (HttpResponse)x), x -> {
            try {
                result.set(EntityUtils.toString((HttpEntity)x));
            }
            catch (IOException ex) {
                throw new IORuntimeWrapperException(ex);
            }
        }, connectionRequestTimeout, false, acceptedContent);
        return (String)result.get();
    }

    protected void logRateLimitIfPresented(@Nonnull String resourceUrl, @Nonnull HttpResponse response) {
        String rateLimitResetDate;
        long rateLimitResetLong;
        long rateLimitRemainingLong;
        long rateLimitLimitLong;
        Header rateLimitReset;
        Header rateLimitRemaining;
        Log logger = this.mojo.getLog();
        Header rateLimitLimit = response.getFirstHeader("X-RateLimit-Limit");
        if (rateLimitLimit == null) {
            rateLimitLimit = response.getFirstHeader("X-Rate-Limit-Limit");
        }
        if ((rateLimitRemaining = response.getFirstHeader("X-RateLimit-Remaining")) == null) {
            rateLimitRemaining = response.getFirstHeader("X-Rate-Limit-Remaining");
        }
        if ((rateLimitReset = response.getFirstHeader("X-RateLimit-Reset")) == null) {
            rateLimitReset = response.getFirstHeader("X-Rate-Limit-Reset");
        }
        String rateLimitLimitValue = rateLimitLimit == null ? null : rateLimitLimit.getValue().trim();
        String rateLimitRemainingValue = rateLimitRemaining == null ? null : rateLimitRemaining.getValue().trim();
        String rateLimitResetValue = rateLimitReset == null ? null : rateLimitReset.getValue().trim();
        try {
            rateLimitLimitLong = rateLimitLimitValue == null ? -1L : Long.parseLong(rateLimitLimitValue);
        }
        catch (NumberFormatException ex) {
            logger.warn((CharSequence)String.format("Detected unexpected '%s' value in rate limit limit header for '%s'", rateLimitLimitValue, resourceUrl));
            rateLimitLimitLong = -1L;
        }
        try {
            rateLimitRemainingLong = rateLimitRemainingValue == null ? -1L : Long.parseLong(rateLimitRemainingValue);
        }
        catch (NumberFormatException ex) {
            logger.warn((CharSequence)String.format("Detected unexpected '%s' value in rate limit remaining header for '%s'", rateLimitRemainingValue, resourceUrl));
            rateLimitRemainingLong = -1L;
        }
        try {
            rateLimitResetLong = rateLimitResetValue == null ? -1L : Long.parseLong(rateLimitResetValue);
        }
        catch (NumberFormatException ex) {
            logger.warn((CharSequence)String.format("Detected unexpected '%s' value in rate limit reset header for '%s'", rateLimitResetValue, resourceUrl));
            rateLimitResetLong = -1L;
        }
        logger.debug((CharSequence)String.format("Resource '%s', limit-remaning=%d, limit-limit=%d, limit-reset=%d", resourceUrl, rateLimitRemainingLong, rateLimitLimitLong, rateLimitResetLong));
        String string = rateLimitResetDate = rateLimitResetLong < 0L ? "UNKNOWN" : new Date(rateLimitResetLong * 1000L).toString();
        if (rateLimitRemainingLong < 0L) {
            logger.debug((CharSequence)"Rate limit remaining is not provided");
        } else if (rateLimitRemainingLong == 0L) {
            logger.error((CharSequence)String.format("Detected zero limit remaining for '%s'! Rate reset expected at '%s'", resourceUrl, rateLimitResetDate));
        } else if (rateLimitRemainingLong < 5L) {
            logger.warn((CharSequence)String.format("Detected %d limit remaining for '%s'.", rateLimitRemainingLong, resourceUrl));
        } else {
            logger.info((CharSequence)String.format("Detected %d limit remaining for '%s'.", rateLimitRemainingLong, resourceUrl));
        }
    }

    @Nonnull
    @MustNotContainNull
    protected Header[] doHttpGetIntoFile(@Nonnull HttpClient client, @Nullable Function<HttpRequestBase, HttpRequestBase> customizer, @Nonnull String url, @Nonnull Path targetFile, @Nonnull MessageDigest digest, int connectionRequestTimeout, String ... acceptedContent) throws IOException {
        Header[] responseHeaders;
        Log log = this.mojo.getLog();
        log.debug((CharSequence)String.format("Loading %s into file %s, request timeout %d ms", url, targetFile.toString(), connectionRequestTimeout));
        try {
            responseHeaders = HttpUtils.doGetRequest(client, customizer, url, this.mojo.getProxy(), x -> this.logRateLimitIfPresented(url, (HttpResponse)x), httpEntity -> {
                boolean showProgress = false;
                try (OutputStream fileOutStream = Files.newOutputStream(targetFile, new OpenOption[0]);){
                    int length;
                    byte[] buffer = new byte[0x100000];
                    long contentSize = httpEntity.getContentLength();
                    InputStream inStream = httpEntity.getContent();
                    log.debug((CharSequence)("Reported content size: " + contentSize + " bytes"));
                    int PROGRESSBAR_WIDTH = 10;
                    String LOADING_TITLE = String.format("Loading %d Mb ", contentSize / 0x100000L);
                    boolean bl = showProgress = contentSize > 0L && !this.mojo.getSession().isParallel();
                    if (!showProgress) {
                        log.info((CharSequence)String.format("Loading file %s, size %d bytes", targetFile.getFileName().toString(), contentSize));
                    }
                    long downloadByteCounter = 0L;
                    int lastShownProgress = -1;
                    if (showProgress) {
                        lastShownProgress = StringUtils.printTextProgress(LOADING_TITLE, downloadByteCounter, contentSize, 10, lastShownProgress);
                    }
                    digest.reset();
                    while (!Thread.currentThread().isInterrupted() && (length = inStream.read(buffer)) >= 0) {
                        fileOutStream.write(buffer, 0, length);
                        digest.update(buffer, 0, length);
                        downloadByteCounter += (long)length;
                        if (!showProgress) continue;
                        lastShownProgress = StringUtils.printTextProgress(LOADING_TITLE, downloadByteCounter, contentSize, 10, lastShownProgress);
                    }
                    fileOutStream.flush();
                }
                catch (IOException ex) {
                    log.error((CharSequence)String.format("Can't download %s into %s: %s", url, targetFile, ex.getMessage()));
                    if (Files.exists(targetFile, new LinkOption[0])) {
                        log.debug((CharSequence)String.format("Deleting file %s", targetFile));
                        try {
                            Files.delete(targetFile);
                        }
                        catch (IOException exx) {
                            log.error((CharSequence)String.format("Can't delete file %s: %s", targetFile, exx.getMessage()));
                        }
                    }
                    throw new IORuntimeWrapperException(ex);
                }
                finally {
                    if (showProgress) {
                        System.out.println();
                    }
                }
            }, connectionRequestTimeout, true, acceptedContent);
        }
        catch (IORuntimeWrapperException ex) {
            throw ex.getWrapped();
        }
        return (Header[])Assertions.assertNotNull((Object)responseHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Path loadJdkIntoCacheIfNotExist(@Nonnull Path cacheFolder, @Nonnull String targetFolderName, @Nonnull IoLoader loader) throws IOException {
        Path resultFolder;
        block7: {
            Log log = this.mojo.getLog();
            Path tempFolder = cacheFolder.resolve(".TMP" + targetFolderName);
            resultFolder = cacheFolder.resolve(targetFolderName);
            File lockingFile = null;
            try {
                lockingFile = this.lockCache(cacheFolder, targetFolderName);
                if (Files.isDirectory(resultFolder, new LinkOption[0])) {
                    log.debug((CharSequence)("Already cached JDK folder detected, skip loading: " + resultFolder));
                    break block7;
                }
                log.debug((CharSequence)("JDK cache has been locking, the locking file: " + lockingFile));
                loader.doLoad(tempFolder);
                if (tempFolder.toFile().renameTo(resultFolder.toFile())) {
                    log.debug((CharSequence)("Renamed " + tempFolder.getFileName() + " to " + resultFolder.getFileName()));
                    break block7;
                }
                log.error((CharSequence)("Can't rename " + tempFolder.getFileName() + " to " + resultFolder.getFileName()));
                throw new IOException("Can't rename temp folder " + tempFolder + " to " + resultFolder);
            }
            finally {
                if (lockingFile != null) {
                    log.debug((CharSequence)("Locker delete status is " + lockingFile.delete()));
                } else {
                    log.debug((CharSequence)"Locker is null");
                }
            }
        }
        return resultFolder;
    }

    @Nonnull
    public abstract Path getPathToJdk(@Nullable String var1, @Nonnull Map<String, String> var2) throws IOException;

    @FunctionalInterface
    public static interface IoLoader {
        public void doLoad(@Nonnull Path var1) throws IOException;
    }
}

