/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders.providers;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvnjlink.exceptions.FailureException;
import com.igormaznitsa.mvnjlink.jdkproviders.AbstractJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.ArchUtils;
import com.igormaznitsa.mvnjlink.utils.HttpUtils;
import com.igormaznitsa.mvnjlink.utils.StringUtils;
import com.igormaznitsa.mvnjlink.utils.WildCardMatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdoptGitOpenJdkProvider
extends AbstractJdkProvider {
    private static final String RELEASES_LIST_TEMPLATE = "https://api.github.com/repos/AdoptOpenJDK/%s/releases";

    public AdoptGitOpenJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        super(mojo);
    }

    @Override
    @Nonnull
    public Path getPathToJdk(@Nullable String authorization, @Nonnull Map<String, String> config) throws IOException {
        Path result;
        Log log = this.mojo.getLog();
        AdoptGitOpenJdkProvider.assertParameters(config, "repositoryName", "arch", "type", "impl", "releaseDate");
        String defaultOs = this.findCurrentOs("macos");
        log.debug((CharSequence)("Default OS recognized as: " + defaultOs));
        String gitRepositoryName = config.get("repositoryName");
        String jdkVersion = config.getOrDefault("version", "");
        String releaseDate = config.get("releaseDate");
        String jdkOs = (String)GetUtils.ensureNonNull((Object)config.get("os"), (Object)defaultOs);
        String jdkArch = config.get("arch");
        String jdkType = config.get("type");
        String jdkImpl = config.get("impl");
        boolean keepArchiveFile = Boolean.parseBoolean(config.getOrDefault("keepArchive", "false"));
        String cachedJdkFolderName = String.format("ADOPTGIT_%s_%s_%s_%s_%s", StringUtils.escapeFileName(jdkVersion.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(releaseDate.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkOs.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkArch.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkImpl.toLowerCase(Locale.ENGLISH).trim()));
        log.info((CharSequence)("looking for '" + cachedJdkFolderName + "' in the cache folder"));
        Path cacheFolder = this.mojo.findJdkCacheFolder();
        Path cachedJdkPath = cacheFolder.resolve(cachedJdkFolderName);
        if (Files.isDirectory(cachedJdkPath, new LinkOption[0])) {
            log.info((CharSequence)("Found cached JDK: " + cachedJdkPath.getFileName()));
            result = cachedJdkPath;
        } else {
            if (this.isOfflineMode()) {
                throw new FailureException("Unpacked '" + cachedJdkPath.getFileName() + "' is not found, stopping process because offline mode is active");
            }
            log.info((CharSequence)("Can't find cached: " + cachedJdkPath.getFileName()));
            HttpClient httpClient = HttpUtils.makeHttpClient(log, this.mojo.getProxy(), this.tuneClient(authorization), this.mojo.isDisableSSLcheck());
            ReleaseList releaseList = new ReleaseList();
            List<Object> releases = Collections.emptyList();
            int page = 1;
            while (!Thread.currentThread().isInterrupted()) {
                log.debug((CharSequence)("Loading releases page: " + page));
                String pageUrl = String.format(RELEASES_LIST_TEMPLATE, gitRepositoryName) + "?per_page=100&page=" + page;
                log.debug((CharSequence)("Page url: " + pageUrl));
                ReleaseList pageReleases = new ReleaseList(log, this.doHttpGetText(httpClient, this.tuneRequestBase(authorization), pageUrl, this.mojo.getConnectionTimeout(), "application/vnd.github.v3+json"));
                releaseList.add(pageReleases);
                releases = releaseList.find(jdkVersion, jdkType, jdkArch, jdkOs, jdkImpl, releaseDate);
                if (!releases.isEmpty() || pageReleases.isEmpty()) break;
                ++page;
            }
            if (releases.isEmpty()) {
                log.warn((CharSequence)("Found releases\n" + releaseList.makeReport()));
                throw new IOException(String.format("Can't find release for version='%s', type='%s', os='%s', arch='%s'", jdkVersion, jdkType, jdkOs, jdkArch));
            }
            log.debug((CharSequence)("Found releases: " + releases));
            Optional<ReleaseList.Release> tarRelease = releases.stream().filter(x -> "tar.gz".equalsIgnoreCase(((ReleaseList.Release)x).extension)).findFirst();
            Optional<ReleaseList.Release> zipRelease = releases.stream().filter(x -> "zip".equalsIgnoreCase(((ReleaseList.Release)x).extension)).findFirst();
            ReleaseList.Release releaseToLoad = (ReleaseList.Release)Stream.of(tarRelease, zipRelease).filter(Optional::isPresent).findFirst().get().get();
            result = this.loadJdkIntoCacheIfNotExist(cacheFolder, ((Path)Assertions.assertNotNull((Object)cachedJdkPath.getFileName())).toString(), tempFolder -> this.downloadAndUnpack(httpClient, authorization, cacheFolder, tempFolder, releaseToLoad, keepArchiveFile));
        }
        return result;
    }

    private void downloadAndUnpack(@Nonnull HttpClient client, @Nullable String authorization, @Nonnull Path tempFolder, @Nonnull Path destUnpackFolder, @Nonnull ReleaseList.Release release, boolean keepArchiveFile) throws IOException {
        Log log = this.mojo.getLog();
        Path pathToArchiveFile = tempFolder.resolve(release.fileName);
        boolean doLoadArchive = true;
        if (Files.isRegularFile(pathToArchiveFile, new LinkOption[0])) {
            log.info((CharSequence)("Detected loaded archive: " + pathToArchiveFile.getFileName()));
            doLoadArchive = false;
        }
        if (doLoadArchive) {
            MessageDigest digest = DigestUtils.getMd5Digest();
            Object[] responseHeaders = this.doHttpGetIntoFile(client, this.tuneRequestBase(authorization), release.link, pathToArchiveFile, digest, this.mojo.getConnectionTimeout(), release.mime);
            log.debug((CharSequence)("Response headers: " + Arrays.toString(responseHeaders)));
            String calculatedMd5Digest = Hex.encodeHexString((byte[])digest.digest());
            log.info((CharSequence)("Archive has been loaded successfully, calculated MD5 digest is " + calculatedMd5Digest));
            Optional<Header> etag = Stream.of(responseHeaders).filter(x -> "ETag".equalsIgnoreCase(x.getName())).findFirst();
            if (etag.isPresent()) {
                Matcher matcher = ETAG_PATTERN.matcher(etag.get().getValue());
                if (matcher.find()) {
                    String extractedEtag = matcher.group(1);
                    if (calculatedMd5Digest.equalsIgnoreCase(extractedEtag)) {
                        log.info((CharSequence)"Calculated MD5 is equal to the ETag in response");
                    } else {
                        log.warn((CharSequence)("Calculated MD5 is not equal to the ETag in response: " + calculatedMd5Digest + " != " + extractedEtag));
                    }
                } else {
                    log.error((CharSequence)("Can't extract MD5 from ETag: " + etag.get().getValue()));
                }
            } else {
                log.warn((CharSequence)"ETag is not presented in the response or its value can't be parsed");
            }
        } else {
            log.info((CharSequence)"Archive loading is skipped");
        }
        if (Files.isDirectory(destUnpackFolder, new LinkOption[0])) {
            log.info((CharSequence)("Detected existing target folder, deleting it: " + destUnpackFolder.getFileName()));
            FileUtils.deleteDirectory((File)destUnpackFolder.toFile());
        }
        String archiveRoorName = ArchUtils.findShortestDirectory(pathToArchiveFile);
        log.debug((CharSequence)("Root archive folder: " + archiveRoorName));
        log.info((CharSequence)"Unpacking archive...");
        int numberOfUnpackedFiles = ArchUtils.unpackArchiveFile(this.mojo.getLog(), true, pathToArchiveFile, destUnpackFolder, archiveRoorName);
        if (numberOfUnpackedFiles == 0) {
            throw new IOException("Extracted 0 files from archive! May be wrong root folder name: " + archiveRoorName);
        }
        log.info((CharSequence)("Archive has been unpacked successfully, extracted " + numberOfUnpackedFiles + " files"));
        if (keepArchiveFile) {
            log.info((CharSequence)("Keep downloaded archive file in cache: " + pathToArchiveFile));
        } else {
            log.info((CharSequence)("Deleting archive: " + pathToArchiveFile));
            Files.delete(pathToArchiveFile);
        }
    }

    private static class ReleaseList {
        private final List<Release> releases = new ArrayList<Release>();

        private ReleaseList() {
        }

        public void add(@Nonnull ReleaseList list) {
            this.releases.addAll(list.releases);
        }

        private ReleaseList(@Nonnull Log log, @Nonnull String json) {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                boolean draft;
                JSONObject release = array.getJSONObject(i);
                if (!release.has("tag_name") || (draft = release.getBoolean("draft")) || !release.has("assets")) continue;
                JSONArray assets = release.getJSONArray("assets");
                for (int a = 0; a < assets.length(); ++a) {
                    JSONObject asset = assets.getJSONObject(a);
                    String fileName = asset.getString("name");
                    String mime = asset.getString("content_type");
                    long size = asset.getLong("size");
                    if (fileName.endsWith(".zip") || fileName.endsWith(".tar.gz")) {
                        String link = asset.getString("browser_download_url");
                        try {
                            Release newRelease = new Release(fileName, link, mime, size);
                            this.releases.add(newRelease);
                            log.debug((CharSequence)("Added found release: " + newRelease));
                        }
                        catch (IllegalArgumentException ex) {
                            log.debug((CharSequence)("Ignoring for non-standard package name: " + fileName));
                        }
                        continue;
                    }
                    log.debug((CharSequence)("Ignoring because becuae non-archive: " + asset));
                }
            }
        }

        public boolean isEmpty() {
            return this.releases.isEmpty();
        }

        @Nonnull
        @MustNotContainNull
        public List<Release> find(@Nonnull String version, @Nonnull String type, @Nonnull String arch, @Nonnull String os, @Nonnull String impl, @Nonnull String releaseDate) {
            WildCardMatcher matcher = new WildCardMatcher(releaseDate, true);
            return this.releases.stream().filter(x -> ((Release)x).version.equalsIgnoreCase(version)).filter(x -> ((Release)x).type.equalsIgnoreCase(type)).filter(x -> ((Release)x).arch.equalsIgnoreCase(arch)).filter(x -> ((Release)x).os.equalsIgnoreCase(os)).filter(x -> ((Release)x).impl.equalsIgnoreCase(impl)).filter(x -> matcher.match(((Release)x).releaseDate)).collect(Collectors.toList());
        }

        @Nonnull
        public String makeReport() {
            return this.releases.stream().map(Release::toString).collect(Collectors.joining("\n"));
        }

        private static class Release {
            private static final Pattern ADOPTGIT_FILENAME_PATTERN = Pattern.compile("^OpenJDK([\\da-z]*)-([a-z]+)_([0-9a-z\\-]+)_([0-9a-z]+)_([0-9a-z_]+)_([\\-a-zA-Z0-9]+).(.+)$", 2);
            private final String version;
            private final String type;
            private final String arch;
            private final String os;
            private final String impl;
            private final String releaseDate;
            private final String fileName;
            private final String link;
            private final String mime;
            private final String extension;
            private final long size;

            private Release(@Nonnull String fileName, @Nonnull String link, @Nonnull String mime, long size) {
                this.fileName = fileName;
                this.link = link;
                this.mime = mime;
                this.size = size;
                Matcher matcher = ADOPTGIT_FILENAME_PATTERN.matcher(fileName);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("Can't parse file name: " + fileName);
                }
                this.version = matcher.group(1);
                this.type = matcher.group(2);
                this.arch = matcher.group(3);
                this.os = matcher.group(4);
                this.impl = matcher.group(5);
                this.releaseDate = matcher.group(6);
                this.extension = matcher.group(7);
            }

            @Nonnull
            public String toString() {
                return String.format("Release[version='%s',type='%s',arch='%s',os='%s',impl='%s',date='%s',extension='%s']", this.version, this.type, this.arch, this.os, this.impl, this.releaseDate, this.extension);
            }
        }
    }
}

