/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders.providers;

import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvnjlink.exceptions.FailureException;
import com.igormaznitsa.mvnjlink.jdkproviders.AbstractJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.ArchUtils;
import com.igormaznitsa.mvnjlink.utils.HttpUtils;
import com.igormaznitsa.mvnjlink.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.maven.plugin.logging.Log;

public class AdoptOpenJdkProvider
extends AbstractJdkProvider {
    private static final String BASEURL = "https://api.adoptopenjdk.net/v3";

    public AdoptOpenJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        super(mojo);
    }

    @Nonnull
    private static String toUrl(@Nonnull String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    @Override
    @Nonnull
    public Path getPathToJdk(@Nullable String authorization, @Nonnull Map<String, String> config) throws IOException {
        Path result;
        Log log = this.mojo.getLog();
        AdoptOpenJdkProvider.assertParameters(config, "release", "arch");
        String defaultOs = this.findCurrentOs("mac");
        log.debug((CharSequence)("Default OS recognized as: " + defaultOs));
        String jdkRelease = config.get("release");
        String jdkArch = config.get("arch");
        String jdkImpl = config.getOrDefault("impl", "hotspot");
        String jdkOs = (String)GetUtils.ensureNonNull((Object)config.get("os"), (Object)defaultOs);
        String jdkImageType = config.getOrDefault("type", "jdk");
        String jdkReleaseType = config.getOrDefault("releaseType", "ga");
        String jdkHeapSize = config.getOrDefault("heapSize", "normal");
        String jdkVendor = config.getOrDefault("vendor", "adoptopenjdk");
        String jdkProject = config.getOrDefault("project", "");
        boolean keepArchiveFile = Boolean.parseBoolean(config.getOrDefault("keepArchive", "false"));
        String cachedJdkFolderName = String.format("ADOPT_%s_%s_%s_%s_%s_%s_%s_%s_%s", StringUtils.escapeFileName(jdkRelease.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkOs.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkArch.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkImpl.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkImageType.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkReleaseType.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkHeapSize.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkVendor.toLowerCase(Locale.ENGLISH).trim()), StringUtils.escapeFileName(jdkProject.toLowerCase(Locale.ENGLISH).trim()));
        log.info((CharSequence)("looking for '" + cachedJdkFolderName + "' in the cache folder"));
        Path cacheFolder = this.mojo.findJdkCacheFolder();
        Path cachedJdkPath = cacheFolder.resolve(cachedJdkFolderName);
        if (Files.isDirectory(cachedJdkPath, new LinkOption[0])) {
            log.info((CharSequence)("Found cached JDK: " + cachedJdkFolderName));
            result = cachedJdkPath;
        } else {
            if (this.isOfflineMode()) {
                throw new FailureException("Unpacked JDK (" + cachedJdkFolderName + ") is not found, stopping process because offline mode is active");
            }
            log.info((CharSequence)("Can't find cached JDK: " + cachedJdkFolderName));
            try {
                Integer.parseInt(jdkRelease);
                result = this.loadFeaturedVersion(authorization, cacheFolder, cachedJdkPath, jdkRelease, jdkReleaseType, jdkOs, jdkArch, jdkImageType, jdkImpl, jdkHeapSize, jdkVendor, jdkProject, keepArchiveFile);
            }
            catch (NumberFormatException ex) {
                result = this.loadReleaseVersion(authorization, cacheFolder, cachedJdkPath, jdkRelease, jdkOs, jdkArch, jdkImageType, jdkImpl, jdkHeapSize, jdkVendor, jdkProject, keepArchiveFile);
            }
        }
        return result;
    }

    @Nonnull
    private Path loadFeaturedVersion(@Nullable String authorization, @Nonnull Path workFolder, @Nonnull Path unpackFolder, @Nonnull String version, @Nonnull String releaseType, @Nonnull String os, @Nonnull String arch, @Nonnull String imageType, @Nonnull String jvmImpl, @Nonnull String heapSize, @Nonnull String vendor, @Nullable String project, boolean keepArchive) throws IOException {
        this.mojo.getLog().debug((CharSequence)"Loading featured version");
        String url = "/binary/latest/" + AdoptOpenJdkProvider.toUrl(version) + '/' + AdoptOpenJdkProvider.toUrl(releaseType) + '/' + AdoptOpenJdkProvider.toUrl(os) + '/' + AdoptOpenJdkProvider.toUrl(arch) + '/' + AdoptOpenJdkProvider.toUrl(imageType) + '/' + AdoptOpenJdkProvider.toUrl(jvmImpl) + '/' + AdoptOpenJdkProvider.toUrl(heapSize) + '/' + AdoptOpenJdkProvider.toUrl(vendor);
        if (project != null && !project.isEmpty()) {
            url = url + "?project=" + AdoptOpenJdkProvider.toUrl(project);
        }
        HttpClient httpClient = HttpUtils.makeHttpClient(this.mojo.getLog(), this.mojo.getProxy(), this.tuneClient(authorization), this.mojo.isDisableSSLcheck());
        this.downloadAndUnpack(BASEURL + url, httpClient, authorization, workFolder, unpackFolder, keepArchive);
        return unpackFolder;
    }

    @Nonnull
    private Path loadReleaseVersion(@Nullable String authorization, @Nonnull Path workFolder, @Nonnull Path unpackFolder, @Nonnull String releaseName, @Nonnull String os, @Nonnull String arch, @Nonnull String imageType, @Nonnull String jvmImpl, @Nonnull String heapSize, @Nonnull String vendor, @Nullable String project, boolean keepArchive) throws IOException {
        this.mojo.getLog().debug((CharSequence)"Loading release version");
        String url = "/binary/version/" + AdoptOpenJdkProvider.toUrl(releaseName) + '/' + AdoptOpenJdkProvider.toUrl(os) + '/' + AdoptOpenJdkProvider.toUrl(arch) + '/' + AdoptOpenJdkProvider.toUrl(imageType) + '/' + AdoptOpenJdkProvider.toUrl(jvmImpl) + '/' + AdoptOpenJdkProvider.toUrl(heapSize) + '/' + AdoptOpenJdkProvider.toUrl(vendor);
        if (project != null && !project.isEmpty()) {
            url = url + "?project=" + AdoptOpenJdkProvider.toUrl(project);
        }
        HttpClient httpClient = HttpUtils.makeHttpClient(this.mojo.getLog(), this.mojo.getProxy(), this.tuneClient(authorization), this.mojo.isDisableSSLcheck());
        this.downloadAndUnpack(BASEURL + url, httpClient, authorization, workFolder, unpackFolder, keepArchive);
        return unpackFolder;
    }

    private void downloadAndUnpack(@Nonnull String url, @Nonnull HttpClient client, @Nullable String authorization, @Nonnull Path tempFolder, @Nonnull Path destUnpackFolder, boolean keepArchiveFile) throws IOException {
        Log log = this.mojo.getLog();
        log.debug((CharSequence)("Formed API uri is " + url));
        Path pathToArchiveFile = tempFolder.resolve("." + destUnpackFolder.getFileName().toString() + ".arch");
        if (Files.isRegularFile(pathToArchiveFile, LinkOption.NOFOLLOW_LINKS) && !Files.deleteIfExists(pathToArchiveFile)) {
            throw new IOException("Can't delete archive: " + pathToArchiveFile);
        }
        MessageDigest digest = DigestUtils.getMd5Digest();
        Object[] responseHeaders = this.doHttpGetIntoFile(client, this.tuneRequestBase(authorization), url, pathToArchiveFile, digest, this.mojo.getConnectionTimeout(), "application/zip", "application/octet-stream", "application/x-zip-compressed", "multipart/x-zip", "application/x-gzip", "application/x-tar+gzip");
        log.debug((CharSequence)("Response headers: " + Arrays.toString(responseHeaders)));
        Optional<Header> originalFileName = Stream.of(responseHeaders).filter(x -> "Content-Disposition".equalsIgnoreCase(x.getName())).findFirst();
        if (!originalFileName.isPresent()) {
            throw new IOException("Can't find Content-Disposition among headers in response");
        }
        Path newArch = pathToArchiveFile.resolveSibling(originalFileName.get().getValue());
        log.debug((CharSequence)("Renaming " + pathToArchiveFile + " -> " + newArch));
        pathToArchiveFile = Files.move(pathToArchiveFile, newArch, new CopyOption[0]);
        String calculatedMd5Digest = Hex.encodeHexString((byte[])digest.digest());
        log.info((CharSequence)("Archive has been loaded successfuly, calculated MD5 digest is " + calculatedMd5Digest));
        Optional<Header> etag = Stream.of(responseHeaders).filter(x -> "ETag".equalsIgnoreCase(x.getName())).findFirst();
        if (etag.isPresent()) {
            Matcher matcher = ETAG_PATTERN.matcher(etag.get().getValue());
            if (matcher.find()) {
                String extractedEtag = matcher.group(1);
                if (calculatedMd5Digest.equalsIgnoreCase(extractedEtag)) {
                    log.info((CharSequence)"Calculated MD5 is equal to the ETag in response");
                } else {
                    log.warn((CharSequence)("Calculated MD5 is not equal to the ETag in response: " + calculatedMd5Digest + " != " + extractedEtag));
                }
            } else {
                log.error((CharSequence)("Can't extract MD5 from ETag: " + etag.get().getValue()));
            }
        } else {
            throw new IOException("ETag is not presented in the response or its value can't be parsed");
        }
        if (Files.isDirectory(destUnpackFolder, new LinkOption[0])) {
            log.info((CharSequence)("Detected existing target folder, deleting it: " + destUnpackFolder.getFileName()));
            FileUtils.deleteDirectory((File)destUnpackFolder.toFile());
        }
        String archiveRoorName = ArchUtils.findShortestDirectory(pathToArchiveFile);
        log.debug((CharSequence)("Root archive folder: " + archiveRoorName));
        log.info((CharSequence)"Unpacking archive...");
        int numberOfUnpackedFiles = ArchUtils.unpackArchiveFile(this.mojo.getLog(), true, pathToArchiveFile, destUnpackFolder, archiveRoorName);
        if (numberOfUnpackedFiles == 0) {
            throw new IOException("Extracted 0 files from archive! May be wrong root folder name: " + archiveRoorName);
        }
        log.info((CharSequence)("Archive has been unpacked successfully, extracted " + numberOfUnpackedFiles + " files"));
        if (keepArchiveFile) {
            log.info((CharSequence)("Keep downloaded archive file in cache: " + pathToArchiveFile));
        } else {
            log.info((CharSequence)("Deleting archive: " + pathToArchiveFile));
            Files.delete(pathToArchiveFile);
        }
    }
}

