/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders.providers;

import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.mvnjlink.jdkproviders.AbstractJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public class LocalJdkProvider
extends AbstractJdkProvider {
    public LocalJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        super(mojo);
    }

    @Override
    @Nonnull
    public Path getPathToJdk(@Nullable String authorization, @Nonnull Map<String, String> config) throws IOException {
        Log log = this.mojo.getLog();
        String toolPath = this.mojo.findJdkTool("javac");
        if (toolPath == null) {
            log.error((CharSequence)"Can't find jlink in the JDK, JDK version must be 9+");
        } else {
            log.debug((CharSequence)("Detected jlink path: " + toolPath));
            Path path = Paths.get(toolPath, new String[0]);
            Path parent = path.getParent();
            if (parent != null && "bin".equals(((Path)Assertions.assertNotNull((Object)parent.getFileName())).toString())) {
                return (Path)Assertions.assertNotNull((Object)parent.getParent());
            }
        }
        throw new IOException("Can't find JDK folder");
    }
}

