/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.mojos;

import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.SelectorUtils;

@Mojo(name="cache-jdk", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class MvnCacheJdkMojo
extends AbstractJdkToolMojo {
    @Parameter(name="jdkPathProperty", defaultValue="mvnjlink.cache.jdk.path")
    private String jdkPathProperty = "mvnjlink.cache.jdk.path";
    @Parameter(name="pathAsProperty")
    private Map<String, String> pathAsProperty;

    @Nonnull
    public String getJdkPathProperty() {
        return this.jdkPathProperty;
    }

    @Override
    public void onExecute() throws MojoExecutionException, MojoFailureException {
        Path jdkPath = this.getSourceJdkFolderFromProvider();
        this.getLog().info((CharSequence)("cached JDK path: " + jdkPath));
        this.getProject().getProperties().setProperty(this.getJdkPathProperty(), jdkPath.toString());
        this.getLog().info((CharSequence)String.format("Project property '%s' <= '%s'", this.getJdkPathProperty(), jdkPath.toString()));
        if (this.pathAsProperty != null && !this.pathAsProperty.isEmpty()) {
            Map<String, Path> found = this.findForPatterns(jdkPath, this.pathAsProperty);
            if (found.size() < this.pathAsProperty.size()) {
                for (Map.Entry<String, String> f : this.pathAsProperty.entrySet()) {
                    if (found.containsKey(f.getKey())) continue;
                    this.getLog().error((CharSequence)("Can't find any file for pattern: " + f.getKey()));
                }
                throw new MojoExecutionException("Can't find some files in JDK for path patterns, see log!");
            }
            for (Map.Entry<String, Path> f : found.entrySet()) {
                this.getLog().info((CharSequence)String.format("Project property '%s' <= '%s' (pattern: %s)", f.getKey(), jdkPath.relativize(f.getValue()).toString(), this.pathAsProperty.get(f.getKey())));
                this.getProject().getProperties().setProperty(f.getKey(), f.getValue().toAbsolutePath().toString());
            }
        }
    }

    @Nonnull
    private Map<String, Path> findForPatterns(@Nonnull Path rootFolder, @Nonnull Map<String, String> patterns) throws MojoExecutionException {
        HashMap<String, Path> result = new HashMap<String, Path>();
        Map<String, String> normalized = patterns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        try (Stream<Path> fileWalker = Files.walk(rootFolder, new FileVisitOption[0]);){
            fileWalker.forEach(x -> {
                for (Map.Entry e : normalized.entrySet()) {
                    Path absolutePath;
                    String propertyName = (String)e.getKey();
                    String pattern = (String)e.getValue();
                    if (!SelectorUtils.match((String)pattern, (String)(absolutePath = rootFolder.resolve((Path)x).toAbsolutePath()).toString())) continue;
                    result.put(propertyName, (Path)x);
                    break;
                }
            });
        }
        catch (IOException ex) {
            throw new MojoExecutionException("IO Error during JDK folder walk", (Exception)ex);
        }
        return result;
    }
}

