/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.utils;

import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.mvnjlink.utils.SystemUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public final class ArchUtils {
    private static final ArchiveStreamFactory ARCHIVE_STREAM_FACTORY = new ArchiveStreamFactory();

    private ArchUtils() {
    }

    @Nullable
    public static final String findShortestDirectory(@Nonnull Path archiveFile) throws IOException {
        ArchiveEntry entry;
        ArchEntryGetter entryGetter;
        ArchiveInputStream archiveInputStream;
        ZipFile zipFile;
        String lcArchiveFileName = ((Path)Assertions.assertNotNull((Object)archiveFile.getFileName())).toString().toLowerCase(Locale.ENGLISH);
        if (lcArchiveFileName.endsWith(".zip")) {
            zipFile = new ZipFile(archiveFile.toFile());
            archiveInputStream = null;
            entryGetter = new ArchEntryGetter(){
                private final Enumeration<ZipArchiveEntry> iterator;
                {
                    this.iterator = zipFile.getEntries();
                }

                @Override
                @Nullable
                public ArchiveEntry getNextEntry() throws IOException {
                    ArchiveEntry result = null;
                    if (this.iterator.hasMoreElements()) {
                        result = (ArchiveEntry)this.iterator.nextElement();
                    }
                    return result;
                }
            };
        } else {
            zipFile = null;
            try {
                if (lcArchiveFileName.endsWith(".tar.gz")) {
                    archiveInputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(Files.newInputStream(archiveFile, new OpenOption[0]))));
                    entryGetter = new ArchEntryGetter(){

                        @Override
                        @Nullable
                        public ArchiveEntry getNextEntry() throws IOException {
                            TarArchiveInputStream tarInputStream = (TarArchiveInputStream)archiveInputStream;
                            return tarInputStream.getNextTarEntry();
                        }
                    };
                } else {
                    archiveInputStream = ARCHIVE_STREAM_FACTORY.createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(archiveFile, new OpenOption[0])));
                    entryGetter = new ArchEntryGetter(){

                        @Override
                        @Nullable
                        public ArchiveEntry getNextEntry() throws IOException {
                            return archiveInputStream.getNextEntry();
                        }
                    };
                }
            }
            catch (ArchiveException ex) {
                throw new IOException("Can't recognize or read archive file : " + archiveFile, ex);
            }
            catch (CantReadArchiveEntryException ex) {
                throw new IOException("Can't read entry from archive file : " + archiveFile, ex);
            }
        }
        String result = null;
        while (!Thread.currentThread().isInterrupted() && (entry = entryGetter.getNextEntry()) != null) {
            int separator;
            String path = entry.getName();
            boolean dotRootPrefix = false;
            if (path.startsWith("./")) {
                path = path.substring(2);
                dotRootPrefix = true;
            }
            if ((separator = path.indexOf(47)) < 0) continue;
            result = path.substring(0, separator);
            if (!dotRootPrefix) continue;
            result = "./" + result;
        }
        SystemUtils.closeCloseable((Closeable)archiveInputStream, null);
        SystemUtils.closeCloseable((Closeable)zipFile, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int unpackArchiveFile(@Nonnull Log logger, boolean tryMakeExecutable, @Nonnull Path archiveFile, @Nonnull Path destinationFolder, String ... foldersToUnpack) throws IOException {
        ArchEntryGetter entryGetter;
        ArchiveInputStream archiveInputStream;
        ZipFile zipFile;
        String lcArchiveFileName = ((Path)Assertions.assertNotNull((Object)archiveFile.getFileName())).toString().toLowerCase(Locale.ENGLISH);
        if (lcArchiveFileName.endsWith(".zip")) {
            logger.debug((CharSequence)"Detected ZIP archive");
            zipFile = new ZipFile(archiveFile.toFile());
            archiveInputStream = null;
            entryGetter = new ArchEntryGetter(){
                private final Enumeration<ZipArchiveEntry> iterator;
                {
                    this.iterator = zipFile.getEntries();
                }

                @Override
                @Nullable
                public ArchiveEntry getNextEntry() throws IOException {
                    ArchiveEntry result = null;
                    if (this.iterator.hasMoreElements()) {
                        result = (ArchiveEntry)this.iterator.nextElement();
                    }
                    return result;
                }
            };
        } else {
            zipFile = null;
            try {
                if (lcArchiveFileName.endsWith(".tar.gz")) {
                    logger.debug((CharSequence)"Detected TAR.GZ archive");
                    archiveInputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(Files.newInputStream(archiveFile, new OpenOption[0]))));
                    entryGetter = new ArchEntryGetter(){

                        @Override
                        @Nullable
                        public ArchiveEntry getNextEntry() throws IOException {
                            TarArchiveInputStream tarInputStream = (TarArchiveInputStream)archiveInputStream;
                            return tarInputStream.getNextTarEntry();
                        }
                    };
                } else {
                    logger.debug((CharSequence)"Detected OTHER archive");
                    archiveInputStream = ARCHIVE_STREAM_FACTORY.createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(archiveFile, new OpenOption[0])));
                    logger.debug((CharSequence)("Created archive stream : " + archiveInputStream.getClass().getName()));
                    entryGetter = new ArchEntryGetter(){

                        @Override
                        @Nullable
                        public ArchiveEntry getNextEntry() throws IOException {
                            return archiveInputStream.getNextEntry();
                        }
                    };
                }
            }
            catch (ArchiveException ex) {
                throw new IOException("Can't recognize or read archive file : " + archiveFile, ex);
            }
            catch (CantReadArchiveEntryException ex) {
                throw new IOException("Can't read entry from archive file : " + archiveFile, ex);
            }
        }
        try {
            ArchiveEntry entry;
            List normalizedFolders = Stream.of(foldersToUnpack).map(x -> FilenameUtils.normalize((String)x, (boolean)true) + '/').collect(Collectors.toList());
            int unpackedFilesCounter = 0;
            while (!Thread.currentThread().isInterrupted() && (entry = entryGetter.getNextEntry()) != null) {
                String normalizedPath;
                block35: {
                    Path targetFile;
                    block33: {
                        block34: {
                            logger.debug((CharSequence)("Unpacking entry: " + entry.getName()));
                            normalizedPath = FilenameUtils.normalize((String)entry.getName(), (boolean)true);
                            if (normalizedFolders.isEmpty()) break block34;
                            if (!normalizedFolders.stream().anyMatch(normalizedPath::startsWith)) break block35;
                        }
                        String normalizedFolder = normalizedFolders.stream().filter(normalizedPath::startsWith).findFirst().orElse("");
                        targetFile = Paths.get(destinationFolder.toString(), normalizedPath.substring(normalizedFolder.length()));
                        if (entry.isDirectory()) {
                            logger.debug((CharSequence)("Folder : " + normalizedPath));
                            if (Files.exists(targetFile, new LinkOption[0])) continue;
                            Files.createDirectories(targetFile, new FileAttribute[0]);
                            continue;
                        }
                        Path parent = targetFile.getParent();
                        if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        try (OutputStream fos = Files.newOutputStream(targetFile, new OpenOption[0]);){
                            if (zipFile != null) {
                                logger.debug((CharSequence)("Unpacking ZIP entry : " + normalizedPath));
                                try (InputStream zipEntryInStream = zipFile.getInputStream((ZipArchiveEntry)entry);){
                                    if ((long)IOUtils.copy((InputStream)zipEntryInStream, (OutputStream)fos) != entry.getSize()) {
                                        throw new IOException("Can't unpack file, illegal unpacked length : " + entry.getName());
                                    }
                                    break block33;
                                }
                            }
                            logger.debug((CharSequence)("Unpacking archive entry : " + normalizedPath));
                            if (!archiveInputStream.canReadEntryData(entry)) {
                                throw new IOException("Can't read archive entry data : " + normalizedPath);
                            }
                            if ((long)IOUtils.copy((InputStream)archiveInputStream, (OutputStream)fos) != entry.getSize()) {
                                throw new IOException("Can't unpack file, illegal unpacked length : " + entry.getName());
                            }
                        }
                    }
                    if (tryMakeExecutable) {
                        String name = ((Path)Assertions.assertNotNull((Object)targetFile.getFileName())).toString().toLowerCase(Locale.ENGLISH);
                        if (Files.size(targetFile) > 0L && (name.endsWith(".bat") || name.endsWith(".cmd") || name.endsWith(".exe") || name.endsWith(".sh") || !name.contains(".")) && !targetFile.toFile().setExecutable(true, true)) {
                            logger.warn((CharSequence)("Can't make executable : " + targetFile));
                        }
                    }
                    ++unpackedFilesCounter;
                    continue;
                }
                logger.debug((CharSequence)("Archive entry " + normalizedPath + " ignored"));
            }
            ArchUtils.postProcessUnpackedArchive(logger, destinationFolder.toFile());
            int n = unpackedFilesCounter;
            return n;
        }
        finally {
            SystemUtils.closeCloseable((Closeable)zipFile, logger);
            SystemUtils.closeCloseable((Closeable)archiveInputStream, logger);
        }
    }

    private static void postProcessUnpackedArchive(@Nonnull Log logger, @Nonnull File unpackFolder) throws IOException {
        File[] filesInRoot = unpackFolder.listFiles();
        if (filesInRoot != null && filesInRoot.length != 0 && Arrays.stream(filesInRoot).filter(File::isDirectory).anyMatch(x -> "contents".equalsIgnoreCase(x.getName()))) {
            logger.debug((CharSequence)"Detected archive prepared for MacOS, moving its internal JDK folder to the root");
            File unpackedHomeFolder = new File(Arrays.stream(filesInRoot).filter(File::isDirectory).filter(x -> "contents".equalsIgnoreCase(x.getName())).findFirst().orElseThrow(() -> new IOException("Can't find Contents folder")), "Home");
            if (unpackedHomeFolder.isDirectory()) {
                logger.debug((CharSequence)"Found Home folder, copying it as JDK root");
                File renamedDestinationFolder = new File(unpackFolder.getParent(), "." + unpackFolder.getName() + "_tmp");
                logger.debug((CharSequence)("Renaming file " + unpackFolder + " to " + renamedDestinationFolder));
                if (!unpackFolder.renameTo(renamedDestinationFolder)) {
                    throw new IOException("Can't rename " + unpackFolder + " to " + renamedDestinationFolder);
                }
                File tempHomeFolder = new File(new File(renamedDestinationFolder, "Contents"), "Home");
                logger.debug((CharSequence)("Moving folder " + tempHomeFolder + " to " + unpackFolder));
                FileUtils.moveDirectory((File)tempHomeFolder, (File)unpackFolder);
                FileUtils.deleteDirectory((File)renamedDestinationFolder);
                logger.debug((CharSequence)("Temp folder deleted " + renamedDestinationFolder));
            } else {
                throw new IOException("Can't find Contents/Home sub-folder in MacOS archive");
            }
        }
    }

    public static final class CantReadArchiveEntryException
    extends RuntimeException {
        public CantReadArchiveEntryException(@Nullable Throwable cause) {
            super("Can't read archive entry for exception", cause);
        }
    }

    private static interface ArchEntryGetter {
        @Nullable
        public ArchiveEntry getNextEntry() throws IOException;
    }
}

