/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.utils;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class StringUtils {
    private static final Pattern PATTERN_MODULE_LINE = Pattern.compile("^(.*)->(.*)$");
    private static final Pattern PATTERN_FILE_HASH = Pattern.compile("([0-9a-fA-F]+)\\s+(.+)");

    private StringUtils() {
    }

    @Nonnull
    public static String escapeFileName(@Nonnull String text) {
        StringBuilder result = new StringBuilder(text.length());
        block5: for (char c : text.toCharArray()) {
            switch (c) {
                case '*': {
                    result.append('#');
                    continue block5;
                }
                case '?': {
                    result.append('_');
                    continue block5;
                }
                case '\"': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '\\': 
                case '|': {
                    result.append('.');
                    continue block5;
                }
                default: {
                    if (Character.isWhitespace(c) || Character.isISOControl(c)) continue block5;
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    @Nonnull
    public static String extractFileHash(@Nonnull String text) throws IOException {
        Matcher hashMatcher = PATTERN_FILE_HASH.matcher(text.trim());
        if (hashMatcher.find()) {
            return hashMatcher.group(1);
        }
        throw new IOException("Can't extract file hash from '" + text + '\'');
    }

    public static int printTextProgress(@Nonnull String text, long value, long maxValue, int progressBarWidth, int lastValue) {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("\r\u001b[?25l");
        builder.append(text);
        builder.append("[");
        int progress = Math.max(0, Math.min(progressBarWidth, (int)Math.round((double)progressBarWidth * ((double)value / (double)maxValue))));
        for (i = 0; i < progress; ++i) {
            builder.append('\u2592');
        }
        for (i = progress; i < progressBarWidth; ++i) {
            builder.append('-');
        }
        builder.append("]\u001b[?25h");
        if (progress != lastValue) {
            System.out.print(builder.toString());
            System.out.flush();
        }
        return progress;
    }

    @Nonnull
    @MustNotContainNull
    public static List<String> extractJdepsModuleNames(@Nonnull String text) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : text.split("\\n")) {
            String moduleName;
            Matcher lineMatcher = PATTERN_MODULE_LINE.matcher(line);
            if (!lineMatcher.find() || (moduleName = lineMatcher.group(2).trim()).contains(" ")) continue;
            result.add(moduleName);
        }
        return result;
    }
}

