/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders.providers;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvnjlink.exceptions.FailureException;
import com.igormaznitsa.mvnjlink.jdkproviders.AbstractJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.ArchUtils;
import com.igormaznitsa.mvnjlink.utils.HttpUtils;
import com.igormaznitsa.mvnjlink.utils.StringUtils;
import com.igormaznitsa.mvnjlink.utils.WildCardMatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class GraalVmCeJdkProvider
extends AbstractJdkProvider {
    static final String RELEASES_LIST = "https://api.github.com/repos/graalvm/graalvm-ce-builds/releases";

    public GraalVmCeJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        super(mojo);
    }

    @Override
    @Nonnull
    public Path getPathToJdk(@Nullable String authorization, @Nonnull Map<String, String> config, Consumer<Path> ... loadedArchiveConsumers) throws IOException {
        Path result;
        Log log = this.mojo.getLog();
        GraalVmCeJdkProvider.assertParameters(config, "type", "version", "arch");
        String defaultOs = this.findCurrentOs("darwin");
        log.debug((CharSequence)("Default OS recognized as: " + defaultOs));
        String jdkType = config.get("type");
        String jdkVersion = config.get("version");
        String jdkOs = (String)GetUtils.ensureNonNull((Object)config.get("os"), (Object)defaultOs);
        String jdkArch = config.get("arch");
        boolean checkArchive = Boolean.parseBoolean(config.getOrDefault("check", "true"));
        int perPage = this.ensurePageSizeValue(config.getOrDefault("perPage", "40"));
        boolean keepArchiveFile = Boolean.parseBoolean(config.getOrDefault("keepArchive", "false"));
        Path cacheFolder = this.mojo.findJdkCacheFolder();
        Path cachedJdkPath = cacheFolder.resolve(String.format("GRAALVMCE_%s_%s_%s_%s", StringUtils.escapeFileName(jdkType.toLowerCase(Locale.ENGLISH)), StringUtils.escapeFileName(jdkVersion.toLowerCase(Locale.ENGLISH)), StringUtils.escapeFileName(jdkOs.toLowerCase(Locale.ENGLISH)), StringUtils.escapeFileName(jdkArch.toLowerCase(Locale.ENGLISH))));
        if (Files.isDirectory(cachedJdkPath, new LinkOption[0])) {
            log.info((CharSequence)("Found cached JDK: " + cachedJdkPath.getFileName()));
            result = cachedJdkPath;
        } else {
            if (this.isOfflineMode()) {
                throw new FailureException("Unpacked '" + cachedJdkPath.getFileName() + "' is not found, stopping process because offline mode is active");
            }
            log.info((CharSequence)("Can't find cached: " + cachedJdkPath.getFileName()));
            HttpClient httpClient = HttpUtils.makeHttpClient(log, this.mojo.getProxy(), this.tuneClient(authorization), this.mojo.isDisableSSLcheck());
            ReleaseList releaseList = new ReleaseList();
            List<Object> releases = Collections.emptyList();
            int page = 1;
            while (!Thread.currentThread().isInterrupted()) {
                log.debug((CharSequence)("Loading releases page: " + page));
                ReleaseList pageReleases = new ReleaseList(log, this.doHttpGetText(httpClient, this.tuneRequestBase(authorization), "https://api.github.com/repos/graalvm/graalvm-ce-builds/releases?per_page=" + perPage + "&page=" + page, this.mojo.getConnectionTimeout(), "application/vnd.github.v3+json"));
                releaseList.add(pageReleases);
                releases = releaseList.find(jdkType, jdkVersion, jdkOs, jdkArch);
                if (!releases.isEmpty() || pageReleases.isEmpty()) break;
                ++page;
            }
            if (releases.isEmpty()) {
                log.warn((CharSequence)("Found releases\n" + releaseList.makeReport()));
                throw new IOException(String.format("Can't find release for version='%s', type='%s', os='%s', arch='%s'", jdkVersion, jdkType, jdkOs, jdkArch));
            }
            log.debug((CharSequence)("Found releases: " + releases));
            Optional<ReleaseList.Release> tarRelease = releases.stream().filter(x -> "tar.gz".equalsIgnoreCase(((ReleaseList.Release)x).extension)).findFirst();
            Optional<ReleaseList.Release> zipRelease = releases.stream().filter(x -> "zip".equalsIgnoreCase(((ReleaseList.Release)x).extension)).findFirst();
            ReleaseList.Release releaseToLoad = (ReleaseList.Release)Stream.of(tarRelease, zipRelease).filter(Optional::isPresent).findFirst().get().get();
            result = this.loadJdkIntoCacheIfNotExist(cacheFolder, ((Path)Assertions.assertNotNull((Object)cachedJdkPath.getFileName())).toString(), tempFolder -> this.downloadAndUnpack(httpClient, authorization, cacheFolder, tempFolder, releaseToLoad, checkArchive, keepArchiveFile, loadedArchiveConsumers));
        }
        return result;
    }

    @SafeVarargs
    private final void downloadAndUnpack(@Nonnull HttpClient client, @Nullable String authorization, @Nonnull Path tempFolder, @Nonnull Path destUnpackFolder, @Nonnull ReleaseList.Release release, boolean check, boolean keepArchiveFile, Consumer<Path> ... loadedArchiveConsumers) throws IOException {
        Log log = this.mojo.getLog();
        Path pathToArchiveFile = tempFolder.resolve(release.fileName);
        boolean doLoadArchive = true;
        if (Files.isRegularFile(pathToArchiveFile, new LinkOption[0])) {
            log.info((CharSequence)("Detected loaded archive: " + pathToArchiveFile.getFileName()));
            doLoadArchive = false;
        }
        if (doLoadArchive) {
            Consumer<Path>[] digest = DigestUtils.getSha256Digest();
            Object[] responseHeaders = this.doHttpGetIntoFile(client, this.tuneRequestBase(authorization), release.link, pathToArchiveFile, Collections.singletonList(digest), this.mojo.getConnectionTimeout(), release.mime);
            log.debug((CharSequence)("Response headers: " + Arrays.toString(responseHeaders)));
            if (check) {
                String sha256text;
                String sha256link = release.link + ".sha256";
                try {
                    log.debug((CharSequence)("Loading SHA256 text: " + sha256link));
                    sha256text = this.doHttpGetText(this.createHttpClient(authorization), this.tuneRequestBase(authorization), sha256link, this.mojo.getConnectionTimeout(), MIME_TEXT).trim();
                }
                catch (Exception ex) {
                    log.error((CharSequence)("Can't find SHA256 for distributive: " + sha256link), (Throwable)ex);
                    throw ex;
                }
                StringBuilder buffer = new StringBuilder();
                for (char c : sha256text.toCharArray()) {
                    if (!Character.isDigit(c) && !Character.isAlphabetic(c)) break;
                    buffer.append(c);
                }
                String sha256signature = buffer.toString();
                log.info((CharSequence)("Loaded SHA256 for distributive: " + sha256signature));
                GraalVmCeJdkProvider.assertChecksum(sha256signature, Collections.singletonList(digest), "SHA-256");
            } else {
                log.warn((CharSequence)"Archive check skipped");
            }
        } else {
            log.info((CharSequence)"Archive loading is skipped");
        }
        if (Files.isDirectory(destUnpackFolder, new LinkOption[0])) {
            log.info((CharSequence)("Detected existing target folder, deleting it: " + destUnpackFolder.getFileName()));
            FileUtils.deleteDirectory((File)destUnpackFolder.toFile());
        }
        for (Consumer<Path> c : loadedArchiveConsumers) {
            c.accept(pathToArchiveFile);
        }
        String archiveRootName = ArchUtils.findShortestDirectory(pathToArchiveFile);
        log.debug((CharSequence)("Root archive folder: " + archiveRootName));
        log.info((CharSequence)"Unpacking archive...");
        int numberOfUnpackedFiles = ArchUtils.unpackArchiveFile(this.mojo.getLog(), true, pathToArchiveFile, destUnpackFolder, archiveRootName);
        if (numberOfUnpackedFiles == 0) {
            throw new IOException("Extracted 0 files from archive! May be wrong root folder name: " + archiveRootName);
        }
        log.info((CharSequence)("Archive has been unpacked successfully, extracted " + numberOfUnpackedFiles + " files"));
        if (keepArchiveFile) {
            log.info((CharSequence)("Keep downloaded archive file in cache: " + pathToArchiveFile));
        } else {
            log.info((CharSequence)("Deleting archive: " + pathToArchiveFile));
            Files.delete(pathToArchiveFile);
        }
    }

    static class ReleaseList {
        private final List<Release> releases = new ArrayList<Release>();

        private ReleaseList() {
        }

        private ReleaseList(@Nonnull Log log, @Nonnull String json) {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject release = array.getJSONObject(i);
                if (!release.has("tag_name")) continue;
                boolean draft = release.getBoolean("draft");
                boolean prerelease = release.getBoolean("prerelease");
                if (draft || prerelease || !release.has("assets")) continue;
                JSONArray assets = release.getJSONArray("assets");
                for (int a = 0; a < assets.length(); ++a) {
                    JSONObject asset = assets.getJSONObject(a);
                    String fileName = asset.getString("name");
                    String mime = asset.getString("content_type");
                    long size = asset.getLong("size");
                    if (fileName.endsWith(".zip") || fileName.endsWith(".tar.gz")) {
                        String link = asset.getString("browser_download_url");
                        try {
                            this.releases.add(new Release(fileName, link, mime, size));
                        }
                        catch (IllegalArgumentException ex) {
                            log.debug((CharSequence)("File with incompatible name: " + fileName));
                        }
                        continue;
                    }
                    log.debug((CharSequence)("Ignoring because non-unpackable file: " + asset));
                }
            }
        }

        public void add(@Nonnull ReleaseList list) {
            this.releases.addAll(list.releases);
        }

        public boolean isEmpty() {
            return this.releases.isEmpty();
        }

        @Nonnull
        @MustNotContainNull
        public List<Release> find(@Nonnull String type, @Nonnull String version, @Nonnull String os, @Nonnull String arch) {
            WildCardMatcher matcher = new WildCardMatcher(version, true);
            return this.releases.stream().filter(x -> ((Release)x).type.equalsIgnoreCase(type)).filter(x -> ((Release)x).os.equalsIgnoreCase(os)).filter(x -> ((Release)x).arch.equalsIgnoreCase(arch)).filter(x -> matcher.match(((Release)x).version)).collect(Collectors.toList());
        }

        @Nonnull
        public String makeReport() {
            return this.releases.stream().map(Release::toString).collect(Collectors.joining("\n"));
        }

        static class Release {
            static final Pattern GRAALVMCE_FILENAME_PATTERN = Pattern.compile("^graalvm-ce-([a-z.0-9+]+)-([a-z]+)-([a-z\\d]+)-([\\d.]+\\d).([\\D.]+)$", 2);
            private final String type;
            private final String version;
            private final String os;
            private final String arch;
            private final String fileName;
            private final String link;
            private final String mime;
            private final String extension;
            private final long size;

            private Release(@Nonnull String fileName, @Nonnull String link, @Nonnull String mime, long size) {
                this.fileName = fileName;
                this.link = link;
                this.mime = mime;
                this.size = size;
                Matcher matcher = GRAALVMCE_FILENAME_PATTERN.matcher(fileName);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("Can't parse file name: " + fileName);
                }
                this.type = matcher.group(1);
                this.os = matcher.group(2);
                this.arch = matcher.group(3);
                this.version = matcher.group(4);
                this.extension = matcher.group(5);
            }

            @Nonnull
            public String toString() {
                return String.format("Release[type='%s',version='%s',os='%s',arch='%s',ext='%s']", this.type, this.version, this.os, this.arch, this.extension);
            }
        }
    }
}

