/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.mojos;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

@Mojo(name="jlink", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class MvnJlinkMojo
extends AbstractJdkToolMojo {
    private static final String SPECNAME_JDK_JMODS = "JDK.PROVIDER.JMODS";
    @Parameter(name="jdepsReportPath")
    private String jdepsReportPath;
    @Parameter(name="options")
    private List<String> options = new ArrayList<String>();
    @Parameter(name="modulePaths")
    private String[] modulePaths;
    @Parameter(name="addModules")
    private List<String> addModules = new ArrayList<String>();
    @Parameter(name="output", required=true)
    private String output;

    @Nonnull
    @MustNotContainNull
    private static List<String> extractModuleNamesFromJdepsReport(@Nonnull Optional<Path> jdepsReportPath) throws MojoExecutionException {
        if (jdepsReportPath.isPresent()) {
            Path jdepsFile = jdepsReportPath.get();
            try {
                return StringUtils.extractJdepsModuleNames(FileUtils.readFileToString((File)jdepsFile.toFile(), (Charset)Charset.defaultCharset()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't read jdeps out file:" + jdepsFile, (Exception)ex);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    @MustNotContainNull
    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(@Nullable @MustNotContainNull List<String> value) {
        this.options = (List)GetUtils.ensureNonNull(value, new ArrayList());
    }

    @Nonnull
    private Path findJmodsFolderInJdk(@Nonnull Path jdk) throws MojoExecutionException {
        Path pathToMods = jdk.resolve("jmods");
        if (!Files.isDirectory(pathToMods, new LinkOption[0])) {
            throw new MojoExecutionException("Can't find jmods folder: " + pathToMods.toString());
        }
        return pathToMods;
    }

    @Nonnull
    private String formModulePath(@Nonnull Log log, @Nonnull Path providerJdk) throws MojoExecutionException {
        String result;
        if (this.modulePaths == null) {
            log.info((CharSequence)("Provider JDK will be used as module path source: " + providerJdk));
            result = this.findJmodsFolderInJdk(providerJdk).toString();
        } else {
            StringBuilder buffer = new StringBuilder();
            String separator = "";
            for (String path : this.modulePaths) {
                buffer.append(separator);
                File modulePathFolder = new File(path.trim().equals(SPECNAME_JDK_JMODS) ? this.findJmodsFolderInJdk(providerJdk).toString() : path);
                log.debug((CharSequence)("Adding module path: " + modulePathFolder));
                if (!modulePathFolder.isDirectory()) {
                    throw new MojoExecutionException("Can't find folder defined in 'modulePaths': " + modulePathFolder.getAbsolutePath());
                }
                buffer.append(modulePathFolder.getAbsolutePath());
                separator = File.pathSeparator;
            }
            result = buffer.toString();
        }
        log.info((CharSequence)("Formed module path: " + result));
        return result;
    }

    @Override
    public void onExecute() throws MojoExecutionException, MojoFailureException {
        ProcessResult executor;
        Log log = this.getLog();
        Path providerJdk = this.getSourceJdkFolderFromProvider();
        Path outputPath = Paths.get(this.output, new String[0]);
        String pathToJlink = this.findJdkTool("jlink");
        if (pathToJlink == null) {
            throw new MojoExecutionException("Can't find jlink in JDK");
        }
        Path execJlinkPath = Paths.get(pathToJlink, new String[0]);
        List<String> modulesFromJdeps = MvnJlinkMojo.extractModuleNamesFromJdepsReport(Optional.ofNullable(this.jdepsReportPath == null ? null : Paths.get(this.jdepsReportPath, new String[0])));
        ArrayList<String> totalModules = new ArrayList<String>(modulesFromJdeps);
        totalModules.addAll(this.addModules);
        String joinedAddModules = totalModules.stream().map(String::trim).collect(Collectors.joining(","));
        log.info((CharSequence)("List of modules : " + joinedAddModules));
        ArrayList<String> commandLineOptions = new ArrayList<String>(this.getOptions());
        commandLineOptions.add("--module-path");
        commandLineOptions.add(this.formModulePath(log, providerJdk));
        int indexOptions = commandLineOptions.indexOf("--add-modules");
        if (indexOptions < 0) {
            if (joinedAddModules.isEmpty()) {
                throw new MojoExecutionException("There are not provided modules to be added.");
            }
            commandLineOptions.add("--add-modules");
            commandLineOptions.add(joinedAddModules);
        } else if (!joinedAddModules.isEmpty()) {
            commandLineOptions.set(indexOptions + 1, (String)commandLineOptions.get(indexOptions + 1) + ',' + joinedAddModules);
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            log.warn((CharSequence)("Deleting existing output folder: " + outputPath));
            try {
                FileUtils.deleteDirectory((File)outputPath.toFile());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't delete output folder: " + outputPath, (Exception)ex);
            }
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(execJlinkPath.toString());
        commandLine.add("--output");
        commandLine.add(outputPath.toString());
        commandLine.addAll(commandLineOptions);
        this.getLog().info((CharSequence)("CLI arguments: " + commandLine.stream().skip(1L).collect(Collectors.joining(" "))));
        log.debug((CharSequence)("Command line: " + commandLine));
        ByteArrayOutputStream consoleOut = new ByteArrayOutputStream();
        ByteArrayOutputStream consoleErr = new ByteArrayOutputStream();
        try {
            executor = new ProcessExecutor(commandLine).readOutput(true).redirectOutput((OutputStream)consoleOut).redirectError((OutputStream)consoleErr).exitValueAny().executeNoTimeout();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error during execution", (Exception)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new MojoFailureException("Execution interrupted", (Throwable)ex);
        }
        if (executor.getExitValue() != 0) {
            String textOut = new String(consoleOut.toByteArray(), Charset.defaultCharset());
            String textErr = new String(consoleErr.toByteArray(), Charset.defaultCharset());
            if (executor.getExitValue() == 1 && textOut.contains("Error: java.lang.IllegalArgumentException")) {
                log.error((CharSequence)"It looks like that the current JDK is incompatible with the provided JDK!");
            }
            if (textErr.isEmpty()) {
                log.error((CharSequence)textOut);
            } else {
                log.info((CharSequence)textOut);
                log.error((CharSequence)textErr);
            }
            throw new MojoFailureException("jlink returns error status code: " + executor.getExitValue());
        }
        log.debug((CharSequence)new String(consoleOut.toByteArray(), Charset.defaultCharset()));
        log.info((CharSequence)("Execution completed successfully, the result folder is " + outputPath));
    }
}

