/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders;

import com.igormaznitsa.mvnjlink.jdkproviders.AbstractJdkProvider;
import com.igormaznitsa.mvnjlink.jdkproviders.providers.AdoptiumOpenJdkProvider;
import com.igormaznitsa.mvnjlink.jdkproviders.providers.GraalVmCeJdkProvider;
import com.igormaznitsa.mvnjlink.jdkproviders.providers.LibericaOpenJdkProvider;
import com.igormaznitsa.mvnjlink.jdkproviders.providers.LocalJdkProvider;
import com.igormaznitsa.mvnjlink.jdkproviders.providers.MicrosoftJdkProvider;
import com.igormaznitsa.mvnjlink.jdkproviders.providers.SapmachineOpenJdkProvider;
import com.igormaznitsa.mvnjlink.jdkproviders.providers.UrlLinkJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;

public enum JdkProviderId {
    ADOPTIUM(AdoptiumOpenJdkProvider.class),
    BELLSOFT(LibericaOpenJdkProvider.class),
    SAPMACHINE(SapmachineOpenJdkProvider.class),
    GRAALVMCE(GraalVmCeJdkProvider.class),
    URL(UrlLinkJdkProvider.class),
    MICROSOFT(MicrosoftJdkProvider.class),
    LOCAL(LocalJdkProvider.class);

    @Nonnull
    private final Class<? extends AbstractJdkProvider> implementation;

    private JdkProviderId(Class<? extends AbstractJdkProvider> implementation) {
        this.implementation = implementation;
    }

    @Nonnull
    public AbstractJdkProvider makeInstance(@Nonnull AbstractJdkToolMojo mojo) {
        try {
            return this.implementation.getDeclaredConstructor(AbstractJdkToolMojo.class).newInstance(new Object[]{mojo});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Error("Unexpected error, can't create instance of JDK provider", e);
        }
    }
}

