/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders.providers;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.annotation.ReturnsOriginal;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.mvnjlink.exceptions.FailureException;
import com.igormaznitsa.mvnjlink.jdkproviders.AbstractJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.ArchUtils;
import com.igormaznitsa.mvnjlink.utils.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.maven.plugin.logging.Log;

public class UrlLinkJdkProvider
extends AbstractJdkProvider {
    protected static final String[] MIMES = new String[]{"application/zip", "application/octet-stream", "application/x-zip-compressed", "application/x-gzip", "application/x-gtar", "application/x-tar", "application/tar", "application/x-compress", "application/x-compressed", "application/x-tgz", "application/tar+gzip"};

    public UrlLinkJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        super(mojo);
    }

    @Nonnull
    @ReturnsOriginal
    private static String asserAppropriateFileName(@Nonnull String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("File name is empty");
        }
        if (name.length() > 96) {
            throw new IllegalArgumentException("Too long file name (must contain less than 97 chars): " + name);
        }
        for (char c : name.toCharArray()) {
            if (Character.isISOControl(c)) {
                throw new IllegalArgumentException("FIle name must not contain ISO control chars");
            }
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '+' || c == '.' || Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("File name contains non-allowed char '" + c + "': " + name);
        }
        return name;
    }

    @Override
    @Nonnull
    public Path getPathToJdk(@Nullable String authorization, @Nonnull Map<String, String> config, Consumer<Path> ... loadedArchiveConsumers) throws IOException {
        Path result;
        Log log = this.mojo.getLog();
        UrlLinkJdkProvider.assertParameters(config, "id", "url");
        String id = UrlLinkJdkProvider.asserAppropriateFileName(config.get("id").trim());
        String url = config.get("url");
        String sha1 = config.get("sha1");
        String sha256 = config.get("sha256");
        String sha384 = config.get("sha384");
        String sha512 = config.get("sha512");
        String md5 = config.get("md5");
        String md2 = config.get("md2");
        String mimes = config.get("mime");
        boolean checkArchive = Boolean.parseBoolean(config.getOrDefault("check", "true"));
        String[] allowedMimes = mimes == null ? MIMES : mimes.split(",");
        for (int i = 0; i < allowedMimes.length; ++i) {
            allowedMimes[i] = allowedMimes[i].trim();
        }
        boolean keepArchiveFile = Boolean.parseBoolean(config.getOrDefault("keepArchive", "false"));
        Path cacheFolder = this.mojo.findJdkCacheFolder();
        Path cachedJdkPath = cacheFolder.resolve(id);
        if (Files.isDirectory(cachedJdkPath, new LinkOption[0])) {
            log.info((CharSequence)("Found cached JDK: " + cachedJdkPath.getFileName()));
            result = cachedJdkPath;
        } else {
            if (this.isOfflineMode()) {
                throw new FailureException("Unpacked '" + cachedJdkPath.getFileName() + "' is not found, stopping process because offline mode is active");
            }
            log.info((CharSequence)("Can't find cached: " + cachedJdkPath.getFileName()));
            HttpClient httpClient = HttpUtils.makeHttpClient(log, this.mojo.getProxy(), this.tuneClient(authorization), this.mojo.isDisableSSLcheck());
            String archiveFileName = String.format(".%s-%s.arch", id, Integer.toHexString(id.hashCode()).toUpperCase(Locale.ENGLISH));
            log.info((CharSequence)("Loading URL: " + url));
            result = this.loadJdkIntoCacheIfNotExist(cacheFolder, ((Path)Assertions.assertNotNull((Object)cachedJdkPath.getFileName())).toString(), tempFolder -> this.downloadAndUnpack(httpClient, authorization, cacheFolder, tempFolder, url, archiveFileName, checkArchive, sha1, sha256, sha384, sha512, md2, md5, keepArchiveFile, allowedMimes, loadedArchiveConsumers));
        }
        return result;
    }

    @SafeVarargs
    protected final void downloadAndUnpack(@Nonnull HttpClient client, @Nullable String authorization, @Nonnull Path tempFolder, @Nonnull Path destUnpackFolder, @Nonnull String downloadLink, @Nonnull String archiveFileName, boolean checkArchive, @Nullable String sha1checksum, @Nullable String sha256checksum, @Nullable String sha384checksum, @Nullable String sha512checksum, @Nullable String md2checksum, @Nullable String md5checksum, boolean keepArchiveFile, @Nonnull @MustNotContainNull String[] allowedMimes, Consumer<Path> ... loadedArchiveConsumers) throws IOException {
        Log log = this.mojo.getLog();
        Path pathToArchiveFile = tempFolder.resolve(archiveFileName);
        boolean doLoadArchive = true;
        if (Files.isRegularFile(pathToArchiveFile, new LinkOption[0])) {
            log.info((CharSequence)("Detected loaded archive: " + pathToArchiveFile.getFileName()));
            doLoadArchive = false;
        }
        String mimeContentType = "unknown";
        if (doLoadArchive) {
            ArrayList<MessageDigest> digests = new ArrayList<MessageDigest>();
            if (sha1checksum != null) {
                digests.add(DigestUtils.getSha1Digest());
            }
            if (sha384checksum != null) {
                digests.add(DigestUtils.getSha384Digest());
            }
            if (sha256checksum != null) {
                digests.add(DigestUtils.getSha256Digest());
            }
            if (sha512checksum != null) {
                digests.add(DigestUtils.getSha512Digest());
            }
            if (md2checksum != null) {
                digests.add(DigestUtils.getMd2Digest());
            }
            if (md5checksum != null) {
                digests.add(DigestUtils.getMd5Digest());
            }
            Object[] responseHeaders = this.doHttpGetIntoFile(client, this.tuneRequestBase(authorization), downloadLink, pathToArchiveFile, digests, this.mojo.getConnectionTimeout(), allowedMimes);
            mimeContentType = Arrays.stream(responseHeaders).filter(x -> x.getName().equalsIgnoreCase("content-type")).findFirst().map(NameValuePair::getValue).orElse("");
            log.debug((CharSequence)("Downloaded file content type: " + mimeContentType));
            log.debug((CharSequence)("Response headers: " + Arrays.toString(responseHeaders)));
            if (checkArchive) {
                if (sha1checksum != null) {
                    UrlLinkJdkProvider.assertChecksum(sha1checksum, digests, "SHA-1");
                    log.info((CharSequence)"SHA1 digest is OK");
                }
                if (md2checksum != null) {
                    UrlLinkJdkProvider.assertChecksum(md2checksum, digests, "MD2");
                    log.info((CharSequence)"MD2 digest is OK");
                }
                if (md5checksum != null) {
                    UrlLinkJdkProvider.assertChecksum(md5checksum, digests, "MD5");
                    log.info((CharSequence)"MD5 digest is OK");
                }
                if (sha256checksum != null) {
                    UrlLinkJdkProvider.assertChecksum(sha256checksum, digests, "SHA-256");
                    log.info((CharSequence)"SHA256 digest is OK");
                }
                if (sha384checksum != null) {
                    UrlLinkJdkProvider.assertChecksum(sha384checksum, digests, "SHA-384");
                    log.info((CharSequence)"SHA384 digest is OK");
                }
                if (sha512checksum != null) {
                    UrlLinkJdkProvider.assertChecksum(sha512checksum, digests, "SHA-512");
                    log.info((CharSequence)"SHA512 digest is OK");
                }
                log.info((CharSequence)("Archive file has been loaded successfully as: " + pathToArchiveFile));
            } else {
                log.warn((CharSequence)"Archive check skipped");
            }
            for (Consumer<Path> c : loadedArchiveConsumers) {
                c.accept(pathToArchiveFile);
            }
        } else {
            log.info((CharSequence)"Archive load is skipped");
        }
        if (Files.isDirectory(destUnpackFolder, new LinkOption[0])) {
            log.info((CharSequence)("Detected existing target folder, deleting it: " + destUnpackFolder.getFileName()));
            FileUtils.deleteDirectory((File)destUnpackFolder.toFile());
        }
        String archiveRootName = ArchUtils.findShortestDirectory(pathToArchiveFile);
        log.debug((CharSequence)("Root archive folder: " + archiveRootName));
        log.info((CharSequence)"Unpacking archive...");
        int numberOfUnpackedFiles = ArchUtils.unpackArchiveFile(this.mojo.getLog(), true, pathToArchiveFile, destUnpackFolder, archiveRootName);
        if (numberOfUnpackedFiles == 0) {
            throw new IOException("Extracted 0 files from archive! May be wrong root folder name: " + archiveRootName);
        }
        log.info((CharSequence)("Archive has been unpacked successfully, extracted " + numberOfUnpackedFiles + " files"));
        if (keepArchiveFile) {
            log.info((CharSequence)("Keep downloaded archive file in cache: " + pathToArchiveFile));
        } else {
            log.info((CharSequence)("Deleting archive: " + pathToArchiveFile));
            Files.delete(pathToArchiveFile);
        }
    }
}

