/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.SystemUtils;

public enum HostOs {
    WINDOWS("windows", "exe", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_WINDOWS;
        }
    }),
    UNIX("unix", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_UNIX;
        }
    }),
    LINUX("linux", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_LINUX;
        }
    }),
    MAC("macos", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_MAC;
        }
    }),
    MAC_OSX("macosx", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_MAC_OSX;
        }
    }),
    AIX("aix", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_AIX;
        }
    }),
    IRIX("irix", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_IRIX;
        }
    }),
    ZOS("zos", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_ZOS;
        }
    }),
    HP_UX("hpux", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_HP_UX;
        }
    }),
    FREE_BSD("freebsd", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_FREE_BSD;
        }
    }),
    SOLARIS("solaris", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return SystemUtils.IS_OS_SOLARIS;
        }
    }),
    UNKNOWN("", "", new Supplier<Boolean>(){

        @Override
        @Nonnull
        public Boolean get() {
            return false;
        }
    });

    private static final List<HostOs> VALUES;
    private final String id;
    private final Supplier<Boolean> hostChecker;
    private final String defaultExtension;

    private HostOs(@Nonnull String id, String defaultExtension, Supplier<Boolean> hostChecker) {
        this.id = id;
        this.defaultExtension = defaultExtension;
        this.hostChecker = hostChecker;
    }

    @Nonnull
    public static HostOs findHostOs() {
        return VALUES.stream().filter(x -> x != UNKNOWN).filter(HostOs::isHostOs).reduce((a, b) -> b).orElse(UNKNOWN);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public static HostOs findForId(@Nonnull String id) {
        String normalized = id.toLowerCase(Locale.ENGLISH).trim();
        return VALUES.stream().filter(x -> x != UNKNOWN).filter(x -> x.getId().equals(normalized)).reduce((a, b) -> b).orElse(UNKNOWN);
    }

    @Nonnull
    public static String makeAllIdAsString() {
        return VALUES.stream().filter(x -> x != UNKNOWN).map(HostOs::getId).collect(Collectors.joining(","));
    }

    @Nonnull
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public boolean isHostOs() {
        return this.hostChecker.get();
    }

    public boolean isMac() {
        return this == MAC || this == MAC_OSX;
    }

    static {
        VALUES = Arrays.stream(HostOs.values()).sorted(Comparator.comparingInt(Enum::ordinal)).collect(Collectors.toList());
    }
}

