/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;

public final class KamranzafarTarArchiveFacade
extends ArchiveInputStream<ArchiveEntry> {
    public KamranzafarTarArchiveFacade(@Nonnull InputStream inputStream) {
        super((InputStream)new TarInputStream(inputStream), Charset.defaultCharset().name());
    }

    @Nullable
    public ArchiveEntry getNextEntry() throws IOException {
        TarEntry nextEntry = ((TarInputStream)this.in).getNextEntry();
        if (nextEntry == null) {
            return null;
        }
        return new TarEntryWrapper(nextEntry);
    }

    private static class TarEntryWrapper
    implements ArchiveEntry {
        private final TarEntry tarEntry;

        TarEntryWrapper(@Nonnull TarEntry entry) {
            this.tarEntry = entry;
        }

        @Nonnull
        public Date getLastModifiedDate() {
            return this.tarEntry.getModTime();
        }

        @Nonnull
        public String getName() {
            return this.tarEntry.getName();
        }

        public long getSize() {
            return this.tarEntry.getSize();
        }

        public boolean isDirectory() {
            return this.tarEntry.isDirectory();
        }
    }
}

