/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.utils;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.mvnjlink.utils.HostOs;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public final class SystemUtils {
    private SystemUtils() {
    }

    @Nullable
    public static Path findJdkExecutable(@Nonnull Log log, @Nonnull Path jdkFolder, @Nonnull String jdkExecutableFileName, @Nonnull HostOs hostOs, @Nonnull @MustNotContainNull Map<HostOs, String> forceExtensions) {
        Path binFolder = jdkFolder.resolve("bin");
        if (Files.isDirectory(binFolder, new LinkOption[0])) {
            log.debug((CharSequence)("Detected JDK bin folder: " + binFolder));
        } else {
            log.debug((CharSequence)("Can't find bin folder in jdk: " + jdkFolder));
            binFolder = jdkFolder.resolve("Contents/Home/bin");
            if (Files.isDirectory(binFolder, new LinkOption[0])) {
                log.debug((CharSequence)("Detected MacOS JDK bin folder: " + jdkFolder));
            } else {
                log.debug((CharSequence)("Can't find MacOS bin folder in jdk: " + jdkFolder));
                return null;
            }
        }
        Path result = binFolder.resolve(SystemUtils.addHostFileExtensionIfNeeded(jdkExecutableFileName, hostOs, forceExtensions));
        if (!Files.isRegularFile(result, new LinkOption[0])) {
            log.error((CharSequence)("Can't find file: " + result));
            result = null;
        } else if (!Files.isExecutable(result)) {
            log.error((CharSequence)("Can't find executable file: " + result));
            result = null;
        }
        return result;
    }

    @Nonnull
    public static String addHostFileExtensionIfNeeded(@Nonnull String fileName, @Nonnull HostOs hostOs, @Nonnull @MustNotContainNull Map<HostOs, String> forceExtensions) {
        String extension = forceExtensions.getOrDefault((Object)hostOs, hostOs.getDefaultExtension());
        String result = extension.isEmpty() || fileName.contains(".") ? fileName : (fileName.toLowerCase(Locale.ENGLISH).endsWith(('.' + extension).toLowerCase(Locale.ENGLISH)) ? fileName : fileName + '.' + extension);
        return result;
    }

    public static void closeCloseable(@Nullable Closeable closeable, @Nullable Log logger) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception ex) {
                    if (logger == null) break block3;
                    logger.debug((CharSequence)("Can't close closeable object: " + closeable), (Throwable)ex);
                }
            }
        }
    }
}

