/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders.providers;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvnjlink.exceptions.FailureException;
import com.igormaznitsa.mvnjlink.jdkproviders.AbstractJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.ArchUtils;
import com.igormaznitsa.mvnjlink.utils.HostOs;
import com.igormaznitsa.mvnjlink.utils.HttpUtils;
import com.igormaznitsa.mvnjlink.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.maven.plugin.logging.Log;

public class AdoptiumApiOpenJdkProvider
extends AbstractJdkProvider {
    public static final String API_BASE_URL = "https://api.adoptium.net/v3/";

    public AdoptiumApiOpenJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        super(mojo);
    }

    @Nonnull
    private static String makeCachePath(@Nonnull String baseUrl, @Nullable String jdkFeatureVersion, @Nullable String jdkReleaseName, @Nonnull String jdkReleaseType, @Nonnull String jdkArch, @Nonnull String jdkHeapSize, @Nonnull String jdkImageType, @Nonnull String jdkJvmImpl, @Nonnull String jdkOs, @Nonnull String jdkVendor, @Nullable String jdkClib, @Nullable String jdkProject) {
        String folderName = "ADOPT_" + Long.toHexString(StringUtils.longHash(baseUrl)).toUpperCase(Locale.ENGLISH) + '_' + (jdkFeatureVersion == null ? "" : jdkFeatureVersion.trim().toLowerCase(Locale.ENGLISH)) + (jdkReleaseName == null ? "" : jdkReleaseName.trim().toLowerCase(Locale.ENGLISH)) + (jdkFeatureVersion == null ? "" : '_' + jdkReleaseType.trim().toLowerCase(Locale.ENGLISH)) + '_' + jdkArch.trim().toLowerCase(Locale.ENGLISH) + '_' + jdkHeapSize.trim().toLowerCase(Locale.ENGLISH) + '_' + jdkImageType.trim().toLowerCase(Locale.ENGLISH) + '_' + jdkJvmImpl.trim().toLowerCase(Locale.ENGLISH) + '_' + jdkOs.trim().toLowerCase(Locale.ENGLISH) + '_' + jdkVendor.trim().toLowerCase(Locale.ENGLISH);
        if (jdkClib != null || jdkProject != null) {
            folderName = folderName + '_' + (jdkClib == null ? "" : jdkClib.trim().toLowerCase(Locale.ENGLISH)) + (jdkProject == null ? "" : jdkProject.trim().toLowerCase(Locale.ENGLISH));
        }
        return StringUtils.escapeFileName(folderName);
    }

    @Nonnull
    private static String makeUrl(@Nonnull String baseUrl, @Nullable String jdkFeatureVersion, @Nullable String jdkReleaseName, @Nonnull String jdkReleaseType, @Nonnull String jdkArch, @Nonnull String jdkHeapSize, @Nonnull String jdkImageType, @Nonnull String jdkJvmImpl, @Nonnull String jdkOs, @Nonnull String jdkVendor, @Nullable String jdkClib, @Nullable String jdkProject) {
        StringBuilder builder = new StringBuilder(baseUrl);
        if (!builder.toString().endsWith("/")) {
            builder.append('/');
        }
        if (jdkReleaseName != null) {
            builder.append("binary/version/").append(jdkReleaseName);
        } else if (jdkFeatureVersion != null) {
            builder.append("binary/latest/").append(jdkFeatureVersion).append('/').append(jdkReleaseType);
        } else {
            throw new IllegalStateException("There must be defined either featureVersion or releaseName");
        }
        builder.append("/").append(jdkOs.trim()).append("/").append(jdkArch.trim()).append("/").append(jdkImageType.trim()).append("/").append(jdkJvmImpl.trim()).append("/").append(jdkHeapSize.trim()).append("/").append(jdkVendor.trim());
        if (jdkClib != null || jdkProject != null) {
            builder.append("?");
            boolean added = false;
            if (jdkClib != null) {
                added = true;
                builder.append("c_lib=").append(jdkClib.trim());
            }
            if (jdkProject != null) {
                if (added) {
                    builder.append('&');
                }
                builder.append("project=").append(jdkProject.trim());
            }
        }
        return builder.toString();
    }

    @Override
    @SafeVarargs
    @Nonnull
    public final Path getPathToJdk(@Nullable String authorization, @Nonnull @MustNotContainNull Map<String, String> config, Consumer<Path> ... loadedArchiveConsumers) throws IOException {
        Log log = this.mojo.getLog();
        HostOs hostOs = HostOs.findHostOs();
        String apiUrl = (String)GetUtils.ensureNonNull((Object)config.get("apiUrl"), (Object)API_BASE_URL);
        String jdkFeatureVersion = config.get("featureVersion");
        String jdkReleaseName = config.get("releaseName");
        String jdkArch = (String)GetUtils.ensureNonNull((Object)config.get("arch"), (Object)"x64");
        String jdkReleaseType = (String)GetUtils.ensureNonNull((Object)config.get("releaseType"), (Object)"ga");
        String jdkHeapSize = (String)GetUtils.ensureNonNull((Object)config.get("heapSize"), (Object)"normal");
        String jdkImageType = (String)GetUtils.ensureNonNull((Object)config.get("imageType"), (Object)"jdk");
        String jdkJvmImpl = (String)GetUtils.ensureNonNull((Object)config.get("jvmImpl"), (Object)"hotspot");
        String jdkOs = (String)GetUtils.ensureNonNull((Object)config.get("os"), (Object)(HostOs.isAlpineLinux() ? "alpine-linux" : (hostOs.isMac() ? "mac" : hostOs.getId())));
        String jdkVendor = (String)GetUtils.ensureNonNull((Object)config.get("vendor"), (Object)"eclipse");
        String jdkClib = config.get("cLib");
        String jdkProject = config.get("project");
        boolean keepArchiveFile = Boolean.parseBoolean(config.getOrDefault("keepArchive", "false"));
        String cacheJdkFolder = AdoptiumApiOpenJdkProvider.makeCachePath(apiUrl, jdkFeatureVersion, jdkReleaseName, jdkReleaseType, jdkArch, jdkHeapSize, jdkImageType, jdkJvmImpl, jdkOs, jdkVendor, jdkClib, jdkProject);
        log.info((CharSequence)("Cache folder: " + cacheJdkFolder));
        Path cacheFolder = this.mojo.findJdkCacheFolder();
        Path cachedJdkPath = cacheFolder.resolve(cacheJdkFolder);
        if (Files.isDirectory(cachedJdkPath, new LinkOption[0])) {
            log.info((CharSequence)("Found cached JDK: " + cachedJdkPath.getFileName()));
            return cachedJdkPath;
        }
        String requestUrl = AdoptiumApiOpenJdkProvider.makeUrl(apiUrl, jdkFeatureVersion, jdkReleaseName, jdkReleaseType, jdkArch, jdkHeapSize, jdkImageType, jdkJvmImpl, jdkOs, jdkVendor, jdkClib, jdkProject);
        log.info((CharSequence)("Formed url link: " + requestUrl));
        if (this.isOfflineMode()) {
            throw new FailureException("Unpacked '" + cachedJdkPath.getFileName() + "' is not found, stopping process because offline mode is active");
        }
        log.info((CharSequence)("Can't find cached: " + cachedJdkPath.getFileName()));
        this.loadJdkIntoCacheIfNotExist(cacheFolder, ((Path)Assertions.assertNotNull((Object)cachedJdkPath.getFileName())).toString(), tempFolder -> this.downloadAndUnpack(requestUrl, this.makeHttpClient(authorization), authorization, cacheFolder, tempFolder, keepArchiveFile, loadedArchiveConsumers));
        return cachedJdkPath;
    }

    @Nonnull
    private HttpClient makeHttpClient(@Nullable String authorization) throws IOException {
        return HttpUtils.makeHttpClient(this.mojo.getLog(), this.mojo.getProxy(), this.tuneClient(authorization), this.mojo.isDisableSSLcheck());
    }

    @SafeVarargs
    private final void downloadAndUnpack(@Nonnull String url, @Nonnull HttpClient client, @Nullable String authorization, @Nonnull Path tempFolder, @Nonnull Path destinationUnpackedFolder, boolean keepArchiveFile, Consumer<Path> ... loadedArchiveConsumers) throws IOException {
        Log log = this.mojo.getLog();
        String tempFileName = ".tempAdopt" + UUID.randomUUID();
        Path pathToArchiveFile = tempFolder.resolve(tempFileName);
        if (Files.isRegularFile(pathToArchiveFile, new LinkOption[0])) {
            log.warn((CharSequence)("Deleting found temp file: " + pathToArchiveFile));
            Files.delete(pathToArchiveFile);
        }
        MessageDigest digest = DigestUtils.getSha256Digest();
        Object[] responseHeaders = this.doHttpGetIntoFile(client, this.tuneRequestBase(authorization), url, pathToArchiveFile, Collections.singletonList(digest), this.mojo.getConnectionTimeout(), "*/*");
        log.debug((CharSequence)("Response headers: " + Arrays.toString(responseHeaders)));
        for (Consumer<Path> c : loadedArchiveConsumers) {
            c.accept(pathToArchiveFile);
        }
        if (Files.isDirectory(destinationUnpackedFolder, new LinkOption[0])) {
            log.info((CharSequence)("Detected existing target folder, deleting it: " + destinationUnpackedFolder.getFileName()));
            FileUtils.deleteDirectory((File)destinationUnpackedFolder.toFile());
        }
        String archiveRootName = ArchUtils.findShortestDirectory(pathToArchiveFile);
        log.debug((CharSequence)("Root archive folder: " + archiveRootName));
        log.info((CharSequence)"Unpacking archive...");
        int numberOfUnpackedFiles = ArchUtils.unpackArchiveFile(this.mojo.getLog(), true, pathToArchiveFile, destinationUnpackedFolder, archiveRootName);
        if (numberOfUnpackedFiles == 0) {
            throw new IOException("Extracted 0 files from archive! May be wrong root folder name: " + archiveRootName);
        }
        log.info((CharSequence)("Archive has been unpacked successfully, extracted " + numberOfUnpackedFiles + " files"));
        if (keepArchiveFile) {
            log.info((CharSequence)("Keep downloaded archive file in cache: " + pathToArchiveFile));
        } else {
            log.info((CharSequence)("Deleting archive: " + pathToArchiveFile));
            Files.delete(pathToArchiveFile);
        }
    }
}

