/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.jdkproviders.providers;

import com.igormaznitsa.mvnjlink.jdkproviders.providers.UrlLinkJdkProvider;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import com.igormaznitsa.mvnjlink.utils.HostOs;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public class MicrosoftJdkProvider
extends UrlLinkJdkProvider {
    private static final String TEMPLATE_FILE_NAME = "microsoft-%s-%s-%s-%s";
    private static final String TEMPLATE_FILE_URL = "https://aka.ms/download-jdk/%s";

    public MicrosoftJdkProvider(@Nonnull AbstractJdkToolMojo mojo) {
        super(mojo);
    }

    @Nonnull
    private String findAppropriateExtension() {
        HostOs os = this.findCurrentOs(HostOs.LINUX);
        if (os == HostOs.WINDOWS) {
            return "zip";
        }
        return "tar.gz";
    }

    @Override
    @Nonnull
    @SafeVarargs
    public final Path getPathToJdk(@Nullable String authorization, @Nonnull Map<String, String> config, Consumer<Path> ... loadedArchiveConsumers) throws IOException {
        String sha256signature;
        Log log = this.mojo.getLog();
        String jdkType = config.getOrDefault("type", "jdk");
        String jdkVersion = config.getOrDefault("version", "17.0.4.1");
        HostOs hostOs = this.findCurrentOs(HostOs.LINUX);
        String jdkOs = config.getOrDefault("os", hostOs == HostOs.MAC || hostOs == HostOs.MAC_OSX ? "macOs" : hostOs.getId());
        String jdkArch = config.getOrDefault("arch", "x64");
        String jdkExtension = config.getOrDefault("extension", this.findAppropriateExtension());
        String sha256 = config.getOrDefault("sha256", null);
        String baseArchiveName = config.getOrDefault("file", String.format(TEMPLATE_FILE_NAME, jdkType, jdkVersion, jdkOs, jdkArch));
        String archiveFileName = baseArchiveName + (jdkExtension.isEmpty() ? "" : '.' + jdkExtension);
        log.info((CharSequence)("Archive name: " + archiveFileName));
        String shaFile = config.getOrDefault("fileSha256", archiveFileName + ".sha256sum.txt");
        String urlArchive = String.format(TEMPLATE_FILE_URL, archiveFileName);
        String urlArchiveSha = String.format(TEMPLATE_FILE_URL, shaFile);
        if (sha256 == null) {
            log.info((CharSequence)("Loading SHA256 signature file: " + urlArchiveSha));
            String body = this.doHttpGetText(this.createHttpClient(authorization), this.tuneRequestBase(authorization), urlArchiveSha, this.mojo.getConnectionTimeout(), MIME_TEXT).trim();
            StringBuilder buffer = new StringBuilder();
            for (char c : body.toCharArray()) {
                if (!Character.isDigit(c) && !Character.isAlphabetic(c)) break;
                buffer.append(c);
            }
            sha256signature = buffer.toString();
            log.info((CharSequence)("Extracted downloaded SHA256: " + sha256signature));
        } else {
            log.info((CharSequence)("Use provided SHA256 signature: " + sha256));
            sha256signature = sha256;
        }
        HashMap<String, String> newConfig = new HashMap<String, String>();
        newConfig.put("id", baseArchiveName);
        newConfig.put("url", urlArchive);
        newConfig.put("sha256", sha256signature);
        return super.getPathToJdk(authorization, newConfig, new Consumer[0]);
    }
}

