/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.mojos;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.mvnjlink.exceptions.FailureException;
import com.igormaznitsa.mvnjlink.jdkproviders.JdkProviderId;
import com.igormaznitsa.mvnjlink.utils.HostOs;
import com.igormaznitsa.mvnjlink.utils.HttpResponseException;
import com.igormaznitsa.mvnjlink.utils.ProxySettings;
import com.igormaznitsa.mvnjlink.utils.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractJdkToolMojo
extends AbstractMojo {
    private final Map<String, String> toolPathCache = new HashMap<String, String>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(name="forceHostOs")
    private HostOs forceHostOs;
    @Parameter(name="forceOsExtensions")
    private Map<String, String> forceOsExtensions = new HashMap<String, String>();
    @Parameter(defaultValue="false", name="useOnlyCache")
    private boolean useOnlyCache;
    @Parameter(defaultValue="${user.home}${file.separator}.mvnJlinkCache", name="jdkCachePath")
    private String jdkCachePath = System.getProperty("user.home") + File.separator + ".mvnJlinkJdkCache";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(name="skip", defaultValue="false")
    private boolean skip;
    @Parameter(name="authorization")
    private String authorization;
    @Parameter(name="disableSSLcheck", defaultValue="false")
    private boolean disableSSLcheck;
    @Parameter(name="connectionTimeout", defaultValue="60000")
    private int connectionTimeout = 60000;
    @Parameter(name="proxy")
    private ProxySettings proxy;
    @Parameter(name="provider", defaultValue="LOCAL")
    private JdkProviderId provider = JdkProviderId.LOCAL;
    @Parameter(name="providerConfig")
    private Map<String, String> providerConfig = new HashMap<String, String>();
    @Parameter(name="toolJdk")
    private String toolJdk = null;
    @Component
    private ToolchainManager toolchainManager;

    public int getConnectionTimeout() {
        return Integer.parseInt(Objects.requireNonNull(this.findProperty("mvn.jlink.connection.timeout", Integer.toString(this.connectionTimeout))));
    }

    @Nullable
    public String getToolJdk() {
        return this.findProperty("mvn.jlink.tool.jdk", this.toolJdk);
    }

    public boolean isUseOnlyCache() {
        return Boolean.parseBoolean(this.findProperty("mvn.jlink.use.only.cache", Boolean.toString(this.useOnlyCache)));
    }

    @Nonnull
    public HostOs findHostOs() {
        if (this.forceHostOs == null) {
            return HostOs.findHostOs();
        }
        return this.forceHostOs;
    }

    @Nonnull
    @MustNotContainNull
    public Map<String, String> getForceOsExtensions() {
        return this.forceOsExtensions;
    }

    @Nonnull
    public Map<String, String> getProviderConfig() {
        return this.providerConfig;
    }

    @Nonnull
    public String getJdkCachePath() {
        return Objects.requireNonNull(this.findProperty("mvn.jlink.jdk.cache.path", this.jdkCachePath));
    }

    @Nonnull
    public JdkProviderId getProvider() {
        return this.provider;
    }

    @Nullable
    public ProxySettings getProxy() {
        return this.proxy;
    }

    public boolean isDisableSSLcheck() {
        return Boolean.parseBoolean(this.findProperty("mvn.jlink.disable.ssl.check", Boolean.toString(this.disableSSLcheck)));
    }

    @Nullable
    public String getAuthorization() {
        return this.findProperty("mvn.jlink.authorization", this.authorization);
    }

    public boolean isSkip() {
        return Boolean.parseBoolean(this.findProperty("mvn.jlink.skip", Boolean.toString(this.skip)));
    }

    @Nonnull
    public MavenProject getProject() {
        return this.project;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping execution");
        } else {
            this.onExecute();
        }
    }

    public boolean isOfflineModeActive() {
        return this.isUseOnlyCache() || this.getSession().isOffline();
    }

    @Nonnull
    public MavenSession getSession() {
        return this.session;
    }

    @Nonnull
    public Path findJdkCacheFolder() throws IOException {
        String storeFolder = this.getJdkCachePath();
        if (storeFolder.trim().isEmpty()) {
            throw new IOException("Path to the cache folder is not provided");
        }
        Path result = Paths.get(storeFolder, new String[0]);
        if (!result.toFile().isDirectory()) {
            this.getLog().info((CharSequence)("Creating cache folder: " + result));
            Files.createDirectories(result, new FileAttribute[0]);
        }
        if (!Files.isReadable(result)) {
            throw new IOException("Can't read from the cache folder, check rights: " + result);
        }
        if (!Files.isWritable(result)) {
            throw new IOException("Can't write to the cache folder, check rights: " + result);
        }
        return result;
    }

    @Nonnull
    protected Path getSourceJdkFolderFromProvider() throws MojoExecutionException, MojoFailureException {
        try {
            return this.getProvider().makeInstance(this).getPathToJdk(this.getAuthorization(), this.getProviderConfig(), new Consumer[0]);
        }
        catch (FailureException | HttpResponseException ex) {
            throw new MojoFailureException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unexpected error during JDK folder preparation, see log for errors!", (Exception)ex);
        }
    }

    @Nonnull
    @MustNotContainNull
    protected Map<HostOs, String> findForceHostExtensions() {
        return this.forceOsExtensions.entrySet().stream().collect(Collectors.toMap(x -> {
            HostOs result = HostOs.findForId((String)x.getKey());
            if (result == HostOs.UNKNOWN) {
                throw new IllegalArgumentException("Unknown host OS ID: " + (String)x.getKey() + ", expected one of " + HostOs.makeAllIdAsString());
            }
            return result;
        }, Map.Entry::getValue));
    }

    @Nullable
    public String findJdkTool(@Nonnull String toolName) {
        Log log = this.getLog();
        String toolPath = this.toolPathCache.get(toolName);
        Map<HostOs, String> foundForcedOsExtensions = this.findForceHostExtensions();
        if (toolPath == null) {
            log.debug((CharSequence)("toolJdk = " + this.getToolJdk()));
            if (this.getToolJdk() == null) {
                Toolchain toolchain = this.getToolchain();
                log.debug((CharSequence)("Toolchain: " + toolchain));
                if (toolchain == null) {
                    String mavenJavaHome = System.getProperty("java.home");
                    log.debug((CharSequence)("Maven java.home: " + mavenJavaHome));
                    Path path = SystemUtils.findJdkExecutable(log, Paths.get(mavenJavaHome, new String[0]), toolName, this.findHostOs(), foundForcedOsExtensions);
                    toolPath = path == null ? null : path.toString();
                } else {
                    log.debug((CharSequence)("Detected toolchain: " + toolchain));
                    toolPath = SystemUtils.addHostFileExtensionIfNeeded(toolchain.findTool(toolName), this.findHostOs(), foundForcedOsExtensions);
                }
            } else {
                Path jdkHome = Paths.get(this.getToolJdk(), new String[0]);
                if (jdkHome.toFile().isDirectory()) {
                    log.debug((CharSequence)("Tool base JDK home: " + jdkHome));
                    Path foundPath = SystemUtils.findJdkExecutable(this.getLog(), jdkHome, toolName, this.findHostOs(), foundForcedOsExtensions);
                    toolPath = foundPath == null ? null : foundPath.toString();
                } else {
                    log.error((CharSequence)("Can't find directory: " + jdkHome));
                }
            }
            if (toolPath != null) {
                log.debug((CharSequence)("Caching path for tool '" + toolName + "' -> " + toolPath));
                this.toolPathCache.put(toolName, toolPath);
            }
        } else {
            log.debug((CharSequence)("Detected cached path for tool '" + toolName + "' -> " + toolPath));
        }
        return toolPath;
    }

    @Nullable
    protected Toolchain getToolchain() {
        Toolchain result = null;
        if (this.toolchainManager != null && (result = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)) == null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List toolchainList = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", Collections.singletonMap("version", "[1.8,)"));
                if (toolchainList != null && !toolchainList.isEmpty()) {
                    result = (Toolchain)toolchainList.get(toolchainList.size() - 1);
                }
            }
            catch (Exception ex) {
                this.getLog().debug((CharSequence)"Exception during getToolchain()", (Throwable)ex);
            }
        }
        return result;
    }

    public abstract void onExecute() throws MojoExecutionException, MojoFailureException;

    @Nullable
    public String findProperty(@Nonnull String key, @Nullable String dflt) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.project.getProperties());
        properties.putAll((Map<?, ?>)this.session.getSystemProperties());
        properties.putAll((Map<?, ?>)this.session.getUserProperties());
        return properties.getProperty(key, dflt);
    }
}

