/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.mojos;

import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

@Mojo(name="jdeps", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class MvnJdepsMojo
extends AbstractJdkToolMojo {
    @Parameter(name="options")
    private List<String> options = new ArrayList<String>();
    @Parameter(name="output", required=true)
    private String output;

    @Override
    public void onExecute() throws MojoExecutionException, MojoFailureException {
        ProcessResult executor;
        Log log = this.getLog();
        this.getSourceJdkFolderFromProvider();
        String pathToJdeps = this.findJdkTool("jdeps");
        if (pathToJdeps == null) {
            throw new MojoExecutionException("Can't find jdeps in JDK");
        }
        Path execJdepsPath = Paths.get(pathToJdeps, new String[0]);
        ArrayList<String> cliArguments = new ArrayList<String>();
        cliArguments.add(execJdepsPath.toString());
        cliArguments.addAll(this.options);
        log.info((CharSequence)("CLI arguments: " + cliArguments.stream().skip(1L).collect(Collectors.joining(" "))));
        ByteArrayOutputStream consoleOut = new ByteArrayOutputStream();
        ByteArrayOutputStream consoleErr = new ByteArrayOutputStream();
        try {
            executor = new ProcessExecutor(cliArguments).readOutput(true).redirectOutput((OutputStream)consoleOut).redirectError((OutputStream)consoleErr).exitValueAny().executeNoTimeout();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error during execution", (Exception)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Execution interrupted", (Exception)ex);
        }
        if (executor.getExitValue() == 0) {
            String text = new String(consoleOut.toByteArray(), Charset.defaultCharset());
            String error = new String(consoleErr.toByteArray(), Charset.defaultCharset());
            log.debug((CharSequence)text);
            log.debug((CharSequence)error);
            if (text.isEmpty()) {
                throw new MojoFailureException("jdeps has generated empty output stream, check your jar, may be it is empty");
            }
            if (text.contains("Path does not exist: ")) {
                log.error((CharSequence)text);
                throw new MojoFailureException("A record that some path doesn't exist has been detected in out stream, it is recognized as error");
            }
            if (this.output != null) {
                File outFile = new File(this.output);
                try {
                    FileUtils.writeByteArrayToFile((File)outFile, (byte[])consoleOut.toByteArray());
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Can't write jdeps file: " + outFile, (Exception)ex);
                }
                log.info((CharSequence)("Saved " + text.length() + " chars into file : " + outFile.getAbsolutePath()));
            }
        } else {
            String strOut = new String(consoleOut.toByteArray(), Charset.defaultCharset());
            String strErr = new String(consoleErr.toByteArray(), Charset.defaultCharset());
            if (strErr.isEmpty()) {
                log.error((CharSequence)strOut);
            } else {
                log.info((CharSequence)new String(consoleOut.toByteArray(), Charset.defaultCharset()));
                log.error((CharSequence)new String(consoleErr.toByteArray(), Charset.defaultCharset()));
            }
            throw new MojoFailureException("jdeps returns error status code: " + executor.getExitValue());
        }
    }
}

