/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.mojos;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.mvnjlink.mojos.AbstractJdkToolMojo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

@Mojo(name="jdk-tool", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class MvnJdkToolMojo
extends AbstractJdkToolMojo {
    @Parameter(name="tool", required=true)
    private String tool;
    @Parameter(name="options")
    private List<String> options = new ArrayList<String>();
    @Parameter(name="output")
    private String output = null;
    @Parameter(name="outputErr")
    private String outputErr = null;
    @Parameter(name="timeout", defaultValue="-1")
    private long timeout = -1L;

    @Nonnull
    public String getTool() {
        return this.tool;
    }

    @Nonnull
    @MustNotContainNull
    public List<String> getOptions() {
        return this.options;
    }

    @Nullable
    public String getOutput() {
        return this.output;
    }

    @Nullable
    public String getOutputErr() {
        return this.outputErr;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void onExecute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Path providerJdk = this.getSourceJdkFolderFromProvider();
        log.debug((CharSequence)("Provider jdk: " + providerJdk));
        String pathToTool = this.findJdkTool(this.getTool());
        if (pathToTool == null) {
            throw new MojoExecutionException("Can't find tool in JDK: " + this.getTool());
        }
        Path execToolPath = Paths.get(pathToTool, new String[0]);
        if (!Files.isRegularFile(execToolPath, new LinkOption[0]) || !Files.isExecutable(execToolPath)) {
            throw new MojoExecutionException("Can't find executable file: " + execToolPath);
        }
        ArrayList<String> cliOptions = new ArrayList<String>();
        cliOptions.add(execToolPath.toString());
        cliOptions.addAll(this.getOptions());
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        try {
            byte[] data;
            log.info((CharSequence)("Executing: " + cliOptions));
            ProcessExecutor executor = new ProcessExecutor(cliOptions).redirectError((OutputStream)errorStream).redirectOutput((OutputStream)outStream).readOutput(true).exitValueAny();
            ProcessResult result = this.getTimeout() > 0L ? executor.executeNoTimeout() : executor.timeout(this.getTimeout(), TimeUnit.SECONDS).execute();
            String strOut = new String(outStream.toByteArray(), Charset.defaultCharset());
            String strErr = new String(errorStream.toByteArray(), Charset.defaultCharset());
            log.debug((CharSequence)"----OUT----\n");
            log.debug((CharSequence)strOut);
            log.debug((CharSequence)"----ERR----\n");
            log.debug((CharSequence)strErr);
            boolean failed = false;
            int exitStatus = result.getExitValue();
            if (exitStatus == 0) {
                log.info((CharSequence)"Successfully completed");
            } else {
                log.error((CharSequence)("Completed with error status: " + exitStatus));
                failed = true;
            }
            if (this.getOutput() != null) {
                try {
                    data = outStream.toByteArray();
                    FileUtils.writeByteArrayToFile((File)new File(this.getOutput()), (byte[])data);
                    log.info((CharSequence)("Written " + data.length + " bytes into " + this.getOutput()));
                }
                catch (Exception ex) {
                    log.error((CharSequence)("Can't save output into file: " + this.getOutput()));
                    failed = true;
                }
            }
            if (this.getOutputErr() != null) {
                try {
                    data = errorStream.toByteArray();
                    FileUtils.writeByteArrayToFile((File)new File(this.getOutputErr()), (byte[])data);
                    log.info((CharSequence)("Written " + data.length + " bytes into " + this.getOutputErr()));
                }
                catch (Exception ex) {
                    log.error((CharSequence)("Can't save error output into file: " + this.getOutputErr()));
                    failed = true;
                }
            }
            if (failed) {
                throw new MojoFailureException("Execution failed, see log");
            }
        }
        catch (TimeoutException ex) {
            throw new MojoFailureException("Timeout");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new MojoFailureException("Interrupted");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Exception during execution", (Exception)ex);
        }
    }
}

