/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvnjlink.utils;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.mvnjlink.utils.ContentTypeParsed;
import com.igormaznitsa.mvnjlink.utils.HttpResponseException;
import com.igormaznitsa.mvnjlink.utils.ProxySettings;
import com.igormaznitsa.mvnjlink.utils.WildCardMatcher;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.plugin.logging.Log;

public final class HttpUtils {
    public static final String MIME_OCTET_STREAM = "application/octet-stream";
    public static final Set<String> ARCHIVE_MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/x-gzip", "application/zip", "application/tar+gzip")));

    private HttpUtils() {
    }

    @Nonnull
    private static HttpRequestBase makeGet(@Nonnull String urlLink, @Nonnull RequestConfig config, @Nullable Function<HttpRequestBase, HttpRequestBase> customizer, String ... acceptedContent) {
        HttpGet methodGet = new HttpGet(urlLink);
        if (customizer != null) {
            methodGet = customizer.apply((HttpRequestBase)methodGet);
        }
        if (acceptedContent.length != 0) {
            methodGet.addHeader("Accept", Stream.of(acceptedContent).collect(Collectors.joining(", ")));
        }
        methodGet.setHeader("User-Agent", "mvn-jlink-plugin");
        methodGet.setConfig(config);
        return methodGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @MustNotContainNull
    public static Header[] doGetRequest(@Nonnull HttpClient client, @Nullable Function<HttpRequestBase, HttpRequestBase> customizer, @Nonnull String urlLink, @Nullable ProxySettings proxySettings, @Nullable Consumer<HttpResponse> responseConsumer, @Nonnull Consumer<HttpEntity> consumer, int timeout, boolean expectedBinaryFile, String ... acceptedContent) throws IOException {
        if (expectedBinaryFile && Arrays.stream(acceptedContent).noneMatch(x -> x.trim().equalsIgnoreCase(MIME_OCTET_STREAM))) {
            acceptedContent = Arrays.copyOf(acceptedContent, acceptedContent.length + 1);
            acceptedContent[acceptedContent.length - 1] = MIME_OCTET_STREAM;
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom().setRedirectsEnabled(true).setSocketTimeout(timeout).setConnectTimeout(timeout);
        if (proxySettings != null) {
            HttpHost proxyHost = new HttpHost(proxySettings.host, proxySettings.port, proxySettings.protocol);
            configBuilder.setProxy(proxyHost);
        }
        RequestConfig config = configBuilder.build();
        HttpResponse response = null;
        HttpRequestBase methodGet = null;
        try {
            int statusCode = -1;
            StatusLine statusLine = null;
            for (int i = 0; i < 5 && (statusCode = (statusLine = (response = client.execute((HttpUriRequest)(methodGet = HttpUtils.makeGet(urlLink, config, customizer, acceptedContent)))).getStatusLine()).getStatusCode()) == 504; ++i) {
                methodGet.releaseConnection();
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            if (statusCode != 200) {
                throw new HttpResponseException(String.format("HTTP request returns unexpected %d code (%s)", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()), response);
            }
            if (responseConsumer != null) {
                responseConsumer.accept(response);
            }
            HttpEntity entity = response.getEntity();
            ContentTypeParsed contentType = new ContentTypeParsed(ContentType.get((HttpEntity)entity).getMimeType());
            if (acceptedContent.length != 0 && Stream.of(acceptedContent).map(ContentTypeParsed::new).noneMatch(x -> x.equals(contentType)) && (!expectedBinaryFile || ARCHIVE_MIME_TYPES.stream().map(ContentTypeParsed::new).noneMatch(x -> x.equals(contentType)))) {
                throw new IOException("Unexpected content type : " + ContentType.get((HttpEntity)entity).getMimeType() + " (expected: " + Arrays.toString(acceptedContent) + ")");
            }
            consumer.accept(entity);
        }
        finally {
            if (methodGet != null) {
                methodGet.releaseConnection();
            }
        }
        return response.getAllHeaders();
    }

    @Nonnull
    public static String extractComputerName() {
        String result = System.getenv("COMPUTERNAME");
        if (result == null) {
            result = System.getenv("HOSTNAME");
        }
        if (result == null) {
            try {
                result = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                result = null;
            }
        }
        return (String)GetUtils.ensureNonNull((Object)result, (Object)"<Unknown computer>");
    }

    @Nonnull
    public static String extractDomainName() {
        String result = System.getenv("USERDOMAIN");
        return (String)GetUtils.ensureNonNull((Object)result, (Object)"");
    }

    @Nonnull
    public static HttpClient makeHttpClient(@Nonnull Log logger, @Nullable ProxySettings proxy, boolean disableSslCheck) throws IOException {
        return HttpUtils.makeHttpClient(logger, proxy, x -> x, disableSslCheck);
    }

    @Nonnull
    public static HttpClient makeHttpClient(@Nonnull Log logger, @Nullable ProxySettings proxy, @Nullable Function<HttpClientBuilder, HttpClientBuilder> tuner, boolean disableSslCheck) throws IOException {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setRedirectStrategy((RedirectStrategy)LaxRedirectStrategy.INSTANCE).disableCookieManagement();
        if (proxy != null) {
            Object[] matchers;
            String[] ignoreForAddresses;
            if (proxy.hasCredentials()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxy.host, proxy.port), (Credentials)new NTCredentials((String)GetUtils.ensureNonNull((Object)proxy.username, (Object)""), proxy.password, HttpUtils.extractComputerName(), HttpUtils.extractDomainName()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                logger.debug((CharSequence)String.format("Credentials provider has been created for proxy (username : %s): %s", proxy.username, proxy.toString()));
            }
            String[] stringArray = ignoreForAddresses = proxy.nonProxyHosts == null ? new String[]{} : proxy.nonProxyHosts.split("\\|");
            if (ignoreForAddresses.length > 0) {
                matchers = new WildCardMatcher[ignoreForAddresses.length];
                for (int i = 0; i < ignoreForAddresses.length; ++i) {
                    matchers[i] = new WildCardMatcher(ignoreForAddresses[i], true);
                }
            } else {
                matchers = new WildCardMatcher[]{};
            }
            logger.debug((CharSequence)"Regular routing mode");
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxy.host, proxy.port, proxy.protocol), (WildCardMatcher[])matchers, logger){
                final /* synthetic */ WildCardMatcher[] val$matchers;
                final /* synthetic */ Log val$logger;
                {
                    this.val$matchers = wildCardMatcherArray;
                    this.val$logger = log;
                    super(proxy);
                }

                @Nonnull
                public HttpRoute determineRoute(@Nonnull HttpHost host, @Nonnull HttpRequest request, @Nonnull HttpContext context) throws HttpException {
                    HttpRoute result = null;
                    String hostName = host.getHostName();
                    for (WildCardMatcher m : this.val$matchers) {
                        if (!m.match(hostName)) continue;
                        this.val$logger.debug((CharSequence)("Ignoring proxy for host : " + hostName));
                        result = new HttpRoute(host);
                        break;
                    }
                    if (result == null) {
                        result = super.determineRoute(host, request, context);
                    }
                    this.val$logger.debug((CharSequence)("Made connection route : " + result));
                    return result;
                }
            };
            builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            logger.debug((CharSequence)("Proxy will ignore: " + Arrays.toString(matchers)));
        }
        builder.setUserAgent("mvn-jlink-agent/1.0");
        if (disableSslCheck) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    @Nullable
                    @MustNotContainNull
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(@Nonnull @MustNotContainNull X509Certificate[] arg0, @Nonnull String arg1) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(@Nonnull @MustNotContainNull X509Certificate[] arg0, @Nonnull String arg1) throws CertificateException {
                    }
                };
                sslcontext.init(null, new TrustManager[]{tm}, null);
                SSLConnectionSocketFactory sslfactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry r = RegistryBuilder.create().register("https", (Object)sslfactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
                builder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)r));
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslfactory);
                builder.setSSLContext(sslcontext);
                logger.warn((CharSequence)"SSL certificate check has been disabled");
            }
            catch (Exception ex) {
                throw new IOException("Can't disable SSL certificate check", ex);
            }
        }
        return tuner == null ? builder.build() : tuner.apply(builder).build();
    }
}

