/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.route.client;

import com.iih5.route.client.ClientHandler;
import com.iih5.route.client.Handler;
import com.iih5.route.client.ProtoType;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    Logger logger = LoggerFactory.getLogger(Client.class);
    public static Channel channel = null;
    public static Handler clientHandler = null;
    public static String[] textLabels = null;
    public static Integer protoType = ProtoType.TEXT;
    public static String serverPwd = "";
    private Bootstrap bootstrap = null;
    private ChannelFuture channelFuture = null;
    private URI uri = null;
    private Timer timer = null;
    private LinkedList<String> urls = null;
    private int connectErrorCount = 0;

    public Client(Handler handler, String ... labels) {
        clientHandler = handler;
        textLabels = labels;
        this.init();
    }

    public Client(Handler handler) {
        clientHandler = handler;
        this.init();
    }

    private void init() {
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new WebSocketInitializer()});
            }
        });
        this.urls = new LinkedList();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (channel == null) {
                    Client.this.logger.debug("\u8fdb\u5165\u65ad\u7ebf\u91cd\u8fde\u3002\u3002\u3002");
                    Client.this.disConnect();
                    Client.this.connect();
                }
            }
        }, 500L, 1500L);
    }

    public void setServerPwd(String pwd) {
        serverPwd = pwd;
    }

    public void setProtoType(Integer type) {
        protoType = type;
    }

    public void setUrls(LinkedList<String> urls) {
        this.urls = urls;
    }

    public void connect(String url) {
        try {
            this.uri = new URI(System.getProperty("url", url));
            this.channelFuture = this.bootstrap.connect(this.uri.getHost(), this.uri.getPort()).sync();
        }
        catch (Exception e) {
            ++this.connectErrorCount;
            clientHandler.connectError(e, this.timer, this.connectErrorCount);
        }
    }

    public void connect() {
        String url = this.urls.pop();
        this.logger.debug("\u5c1d\u8bd5\u5f53\u524d\u8fde\u63a5\uff1a" + url);
        this.connect(url);
        this.urls.add(url);
    }

    public void disConnect() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close();
        }
    }

    public void publish(String label, String content) {
        String pack = label + " # " + content;
        channel.writeAndFlush((Object)new TextWebSocketFrame(pack));
    }

    public void publish(String label, byte[] content) {
        try {
            ByteBuf data = Unpooled.buffer();
            byte[] c = label.getBytes("UTF-8");
            data.writeShort(c.length);
            data.writeBytes(c);
            data.writeBytes(content);
            channel.writeAndFlush((Object)new BinaryWebSocketFrame(data));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WebSocketInitializer
    extends ChannelInitializer<SocketChannel> {
        WebSocketInitializer() {
        }

        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
            ClientHandler wc = new ClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)Client.this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
            pipeline.addLast(new ChannelHandler[]{wc});
        }
    }
}

