/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.route.client;

import com.alibaba.fastjson.JSON;
import com.iih5.route.client.Client;
import com.iih5.route.client.ProtoType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientHandler
extends SimpleChannelInboundHandler<Object> {
    private WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;

    public ClientHandler(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Client.channel = null;
        Client.clientHandler.disconnect(ctx.channel());
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
            this.handshakeFuture.setSuccess();
            Client.channel = ch;
            Client.clientHandler.connect(ctx.channel());
            if (Client.protoType == ProtoType.TEXT) {
                if (Client.textLabels != null) {
                    String pack = Client.serverPwd + " # " + JSON.toJSONString((Object)Client.textLabels);
                    ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(pack));
                }
            } else if (Client.textLabels != null) {
                ByteBuf data = Unpooled.buffer();
                byte[] d = Client.serverPwd.getBytes("UTF-8");
                data.writeShort(d.length);
                data.writeBytes(d);
                byte[] c = JSON.toJSONString((Object)Client.textLabels).getBytes("UTF-8");
                data.writeShort(c.length);
                data.writeBytes(c);
                ctx.channel().writeAndFlush((Object)new BinaryWebSocketFrame(data));
            }
            return;
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame bw = (BinaryWebSocketFrame)frame;
            ByteBuf buf = bw.content();
            if (Client.clientHandler != null) {
                byte[] b = buf.readBytes((int)buf.readShort()).array();
                String label = new String(b, Charset.forName("UTF-8"));
                byte[] content = new byte[buf.readableBytes()];
                buf.readBytes(content);
                Client.clientHandler.onMessage(label, content);
            }
        } else {
            String[] arr;
            String content = ((TextWebSocketFrame)frame).text();
            if (Client.clientHandler != null && (arr = content.split(" # ", 2)) != null && arr.length == 2) {
                Client.clientHandler.onMessage(arr[0], arr[1]);
            }
        }
    }
}

