/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.actor;

import com.iih5.actor.ActorManager;
import com.iih5.actor.ActorState;
import com.iih5.actor.IActor;
import com.iih5.actor.IActorExecutor;
import com.iih5.actor.scheduler.LoopScheduledTask;
import com.iih5.actor.scheduler.ScheduledTask;
import com.iih5.actor.scheduler.TaskFutureListener;
import com.iih5.actor.util.GlobalConstant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Actor
implements IActor {
    Logger logger = LoggerFactory.getLogger(Actor.class);
    protected volatile IActorExecutor executor;
    private BlockingQueue<Runnable> waitQueue = new LinkedBlockingQueue<Runnable>();
    private volatile ActorState state = ActorState.NORMAL;
    private Lock lock = new ReentrantLock(true);
    private ActorManager parent;
    private ScheduledExecutorService scheduledExecutorService;
    private Map<String, Future<?>> futures;

    public Actor(ActorManager parent) {
        this.parent = parent;
        this.scheduledExecutorService = parent.getScheduledExecutorService();
        this.futures = new TreeMap();
    }

    @Override
    public IActorExecutor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExecutor(IActorExecutor executor) {
        this.lock.lock();
        try {
            if (executor == null) {
                throw new NullPointerException("\u4efb\u52a1\u5904\u7406\u5668executor\u4e0d\u80fd\u4e3a\u7a7a,\u5426\u5219\u63d0\u4ea4\u7684\u4efb\u52a1\u4e0d\u80fd\u6267\u884c");
            }
            if (this.executor != null && this.executor.workThread() != null && this.executor != executor) {
                this.logger.info("Actor \u5207\u6362\u7ebf\u7a0b:old={},new={} " + this.executor.workThread() + executor.workThread());
                this.state = ActorState.TRANSITIVE;
                this.transfer(executor);
                this.state = ActorState.NORMAL;
            }
            this.executor = executor;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void switchExecutor(IActorExecutor executor) {
        this.setExecutor(executor);
    }

    private void transfer(IActorExecutor executor) {
        if (this.state == ActorState.TRANSITIVE) {
            for (Runnable task : this.waitQueue) {
                executor.submit(task);
            }
        } else {
            throw new IllegalStateException("\u975e" + (Object)((Object)ActorState.TRANSITIVE) + "\u72b6\u6001\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c");
        }
    }

    @Override
    public ActorState getActorState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeTransTask(Runnable task) {
        if (this.state == ActorState.TRANSITIVE) {
            this.lock.lock();
            try {
                if (this.state == ActorState.TRANSITIVE) {
                    this.logger.info("\u8fc7\u6e21\u671f\u65b0\u4efb\u52a1:actor={}" + this.toString());
                    this.waitQueue.put(task);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.logger.info("\u5904\u7406\u8fc7\u6e21\u671f\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> execute(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        if (this.executor == null) {
            List<IActorExecutor> list = this.parent.getActorExecutors();
            synchronized (list) {
                this.executor = this.parent.assignActorExecutor();
                this.executor.incrActorCount();
            }
        }
        if (this.executeTransTask(future)) {
            this.executor.decrActorCount();
        } else {
            this.executor.submit(future);
        }
        return future;
    }

    @Override
    public Future<?> scheduledTask(final Runnable task, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            return this.execute(task);
        }
        ScheduledFuture<?> result = this.scheduledExecutorService.schedule(new Runnable(){

            public void run() {
                Actor.this.execute(task);
            }
        }, delay, unit);
        return result;
    }

    @Override
    public Future<?> scheduleAtFixedRateTask(final Runnable task, long delay, long period, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                Actor.this.execute(task);
            }
        }, delay, period, unit);
    }

    @Override
    public Future<?> scheduleWithFixedDelayTask(final Runnable task, long delay, long period, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                Actor.this.execute(task);
            }
        }, delay, period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> execute(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        if (this.executor == null) {
            List<IActorExecutor> list = this.parent.getActorExecutors();
            synchronized (list) {
                this.executor = this.parent.assignActorExecutor();
            }
        }
        if (!this.executeTransTask(future)) {
            this.executor.submit(future);
        }
        return future;
    }

    @Override
    public Future<?> scheduledTask(final Callable<?> task, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            return this.execute(task);
        }
        return this.scheduledExecutorService.schedule(new Runnable(){

            public void run() {
                Actor.this.execute(task);
            }
        }, delay, unit);
    }

    @Override
    public Future<?> addLoopTask(LoopScheduledTask task) {
        if (!this.futures.containsKey(task.getName())) {
            Future<?> future = null;
            future = task.isFixRate() ? this.scheduleAtFixedRateTask(task, task.getDelay(), task.getPeriod(), task.getUnit()) : this.scheduleWithFixedDelayTask(task, task.getDelay(), task.getPeriod(), task.getUnit());
            this.futures.put(task.getName(), future);
            return this.futures.get(task.getName());
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5df2\u5b58\u5728:name={}" + task.getName());
        return null;
    }

    @Override
    public Future<?> addTask(ScheduledTask task) {
        if (!this.futures.containsKey(task.getName())) {
            task.addListener(new DefaultTaskFutureListener());
            Future<?> future = this.scheduledTask(task, task.getDelay(), task.getUnit());
            this.futures.put(task.getName(), future);
            return this.futures.get(task.getName());
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5df2\u5b58\u5728:name={}" + task.getName());
        return null;
    }

    @Override
    public boolean cancelTask(String name, boolean mayInterruptIfRunning) {
        Future<?> future = this.futures.get(name);
        if (future != null) {
            this.futures.remove(name);
            boolean b = future.cancel(mayInterruptIfRunning);
            return b;
        }
        this.logger.info("\u4efb\u52a1\u4e0d\u5b58\u5728:name = {}" + name);
        return false;
    }

    @Override
    public long getId() {
        return GlobalConstant.ATOMIC_COUNTER.incrementAndGet();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.executor != null) {
            this.executor.decrActorCount();
        }
    }

    private class DefaultTaskFutureListener
    implements TaskFutureListener {
        private DefaultTaskFutureListener() {
        }

        public void completed(ScheduledTask task) {
            Actor.this.cancelTask(task.getName(), true);
        }
    }
}

