/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.actor;

import com.iih5.actor.IActorExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActorExecutor
implements IActorExecutor {
    private Logger logger = LoggerFactory.getLogger(ActorExecutor.class);
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(500000);
    private Thread thread;
    private AtomicInteger actorCount = new AtomicInteger(0);

    public void run() {
        this.thread = Thread.currentThread();
        while (true) {
            try {
                while (true) {
                    Runnable task = this.queue.take();
                    task.run();
                }
            }
            catch (Exception e) {
                this.logger.error("\u7ebf\u7a0b\u5f02\u5e38\uff1a", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void submit(Runnable task) {
        if (this.thread == Thread.currentThread()) {
            task.run();
        } else {
            try {
                this.queue.put(task);
            }
            catch (Exception e) {
                this.logger.error("\u7ebf\u7a0b\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    public int getUndoneTaskSize() {
        return this.queue.size();
    }

    public int compareTo(IActorExecutor o) {
        int compare = this.getUndoneTaskSize() - o.getUndoneTaskSize();
        if (compare == 0) {
            compare = this.actorCount.get() - o.getActorCount();
        }
        return compare;
    }

    public Thread workThread() {
        return this.thread;
    }

    public void incrActorCount() {
        this.actorCount.getAndIncrement();
    }

    public void decrActorCount() {
        this.actorCount.getAndDecrement();
    }

    public int getActorCount() {
        return this.actorCount.get();
    }
}

