/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.actor;

import com.iih5.actor.Actor;
import com.iih5.actor.ActorExecutor;
import com.iih5.actor.IActor;
import com.iih5.actor.IActorExecutor;
import com.iih5.actor.util.ListSortUtil;
import com.iih5.actor.util.ThreadFactoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorManager {
    protected int threadSize;
    protected ExecutorService threadPool;
    private List<IActorExecutor> actorThreads;
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private Map<String, IActor> actorMap = new ConcurrentHashMap<String, IActor>();

    public ActorManager(int threadSize, ThreadFactory factory) {
        this.threadSize = threadSize;
        this.threadPool = this.initThreadPool(factory);
        this.actorThreads = new ArrayList<IActorExecutor>(threadSize);
    }

    public ActorManager() {
        ThreadFactory threadFactory = ThreadFactoryUtil.createThreadFactory("Default-Pool-" + System.currentTimeMillis());
        this.threadSize = 8;
        this.actorThreads = new ArrayList<IActorExecutor>(this.threadSize);
        this.threadPool = this.initThreadPool(threadFactory);
    }

    private ExecutorService initThreadPool(ThreadFactory factory) {
        if (this.threadPool == null) {
            this.threadPool = Executors.newFixedThreadPool(this.threadSize, factory);
        }
        return this.threadPool;
    }

    public IActorExecutor assignActorExecutor() {
        if (this.actorThreads.size() < this.threadSize) {
            for (IActorExecutor executor : this.actorThreads) {
                if (executor.getUndoneTaskSize() != 0 || executor.getActorCount() != 0) continue;
                executor.incrActorCount();
                return executor;
            }
            ActorExecutor executor = new ActorExecutor();
            executor.incrActorCount();
            this.actorThreads.add(executor);
            this.threadPool.execute(executor);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return executor;
        }
        ListSortUtil.sort(this.actorThreads);
        IActorExecutor er = this.actorThreads.get(0);
        er.incrActorCount();
        return er;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public IActor createActor() {
        Actor actor = new Actor(this);
        IActorExecutor actorExecutor = this.assignActorExecutor();
        actor.setExecutor(actorExecutor);
        return actor;
    }

    public List<IActorExecutor> getActorExecutors() {
        return this.actorThreads;
    }

    public IActor createActor(String actorName) {
        IActor actor = this.createActor();
        this.actorMap.put(actorName, actor);
        return actor;
    }

    public IActor getActor(String actorName) {
        return this.actorMap.get(actorName);
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }
}

