/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.actor.scheduler;

import com.iih5.actor.scheduler.TaskFutureListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class ScheduledTask
implements Runnable {
    protected String name;
    protected long delay;
    protected TimeUnit unit;
    protected List<TaskFutureListener> listeners = new LinkedList<TaskFutureListener>();

    public ScheduledTask(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public void addListener(TaskFutureListener promise) {
        this.listeners.add(promise);
    }

    public void removeListener(TaskFutureListener promise) {
        this.listeners.remove(promise);
    }

    public abstract void execute();

    public void run() {
        this.execute();
        for (TaskFutureListener listener : this.listeners) {
            listener.completed(this);
        }
    }
}

