/*
 * Decompiled with CFR 0.152.
 */
package com.ikasoa.zk;

import com.ikasoa.core.loadbalance.ServerInfo;
import com.ikasoa.core.utils.ListUtil;
import com.ikasoa.core.utils.StringUtil;
import com.ikasoa.zk.ZkServerNode;
import java.util.List;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkBase {
    private static final Logger log = LoggerFactory.getLogger(ZkBase.class);
    private ZkClient zkClient;
    private String zkNode;
    private List<String> nodeList;
    public static final String ZK_ROOT_NODE = "/";

    public ZkBase(String zkServerString, String zkNode) {
        if (StringUtil.isEmpty((String)zkServerString)) {
            throw new IllegalArgumentException("'zkServerString' is null !");
        }
        this.zkClient = new ZkClient(zkServerString);
        this.zkNode = StringUtil.isEmpty((String)zkNode) ? ZK_ROOT_NODE : zkNode;
        this.zkClient.subscribeDataChanges(this.zkNode, new IZkDataListener(){

            public void handleDataChange(String nodePath, Object nodeObj) throws Exception {
                log.debug("handleDataChange (nodePath : {}, nodeObj : {})", (Object)nodePath, nodeObj);
            }

            public void handleDataDeleted(String nodePath) throws Exception {
                log.warn("handleDataDeleted (nodePath : {})", (Object)nodePath);
            }
        });
        this.zkClient.subscribeStateChanges(new IZkStateListener(){

            public void handleNewSession() throws Exception {
                log.debug("Implementing 'handleNewSession' .");
                ZkBase.this.nodeList = ZkBase.this.getChildren();
            }

            public void handleSessionEstablishmentError(Throwable t) throws Exception {
                log.error(t.getMessage());
            }

            public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
                log.debug("Implementing 'handleStateChanged (state : {})' .", (Object)state);
            }
        });
        this.zkClient.subscribeChildChanges(this.zkNode, new IZkChildListener(){

            public void handleChildChange(String parentPath, List<String> currentChildList) throws Exception {
                log.debug("Implementing 'handleChildChange (parentPath : {}, currentChildList : {})' .", (Object)parentPath, currentChildList);
                ZkBase.this.nodeList = currentChildList;
            }
        });
    }

    public List<ServerInfo> getServerInfoList() {
        List serverInfoList = ListUtil.newArrayList();
        List nList = this.zkClient.getChildren(this.zkNode);
        for (String n : nList) {
            ZkServerNode zksn = (ZkServerNode)this.zkClient.readData(StringUtil.merge((Object[])new Object[]{this.zkNode, ZK_ROOT_NODE, n}));
            serverInfoList.add(new ServerInfo(zksn.getServerHost(), zksn.getServerPort().intValue()));
        }
        log.debug("ServerInfoList is : {}", (Object)serverInfoList);
        return serverInfoList;
    }

    public boolean isExistNode(String serverName, String serverHost, int serverPort) {
        if (ListUtil.isEmpty(this.nodeList)) {
            this.nodeList = this.getChildren();
        }
        for (String n : this.nodeList) {
            if (!n.contains(StringUtil.merge((Object[])new Object[]{serverName, "-", serverHost, "-", serverPort}))) continue;
            return true;
        }
        return false;
    }

    public List<String> getChildren() {
        return this.zkClient.getChildren(this.zkNode);
    }

    public ZkClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public String getZkNode() {
        return this.zkNode;
    }

    public void setZkNode(String zkNode) {
        this.zkNode = zkNode;
    }
}

