/*
 * Decompiled with CFR 0.152.
 */
package com.ikasoa.zk;

import com.ikasoa.core.thrift.server.ServerAspect;
import com.ikasoa.core.thrift.server.ServerConfiguration;
import com.ikasoa.core.thrift.server.ThriftServer;
import com.ikasoa.core.utils.ObjectUtil;
import com.ikasoa.core.utils.ServerUtil;
import com.ikasoa.core.utils.StringUtil;
import com.ikasoa.zk.ZkBase;
import com.ikasoa.zk.ZkServerNode;
import com.ikasoa.zk.utils.LocalUtil;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Optional;
import org.I0Itec.zkclient.ZkClient;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServerAspect
implements ServerAspect {
    private static final Logger log = LoggerFactory.getLogger(ZkServerAspect.class);
    private ZkBase zkBase;
    private String host;
    private int port;
    private boolean isLocalIp = false;
    private String sNodeStr;
    private static final String DEFAULT_NODE_NAME = "ikasoa_node";

    public ZkServerAspect(String zkServerString, String zkNode) {
        this.zkBase = new ZkBase(zkServerString, zkNode);
    }

    public ZkServerAspect(String zkServerString, String zkNode, String host, int port) {
        this.zkBase = new ZkBase(zkServerString, zkNode);
        this.host = host;
        this.port = port;
    }

    public ZkServerAspect(String zkServerString, String zkNode, boolean isLocalIp) {
        this.zkBase = new ZkBase(zkServerString, zkNode);
        this.isLocalIp = isLocalIp;
    }

    public void beforeStart(String serverName, int serverPort, ServerConfiguration configuration, TProcessor processor, ThriftServer server) {
    }

    public void afterStart(String serverName, int serverPort, ServerConfiguration configuration, TProcessor processor, ThriftServer server) {
        String zkNode;
        ZkClient zkClient = this.zkBase.getZkClient();
        if (!zkClient.exists(zkNode = this.zkBase.getZkNode())) {
            zkClient.createPersistent(zkNode, (Object)StringUtil.merge((Object[])new Object[]{"/", DEFAULT_NODE_NAME}));
        }
        try {
            String serverHost;
            String string = StringUtil.isNotEmpty((String)this.host) ? this.host : (serverHost = this.isLocalIp ? LocalUtil.getLocalIP() : InetAddress.getLocalHost().getHostAddress());
            if (ServerUtil.isPort((int)this.port)) {
                serverPort = this.port;
            }
            if (!StringUtil.equals((String)"/", (String)zkNode)) {
                zkNode = StringUtil.merge((Object[])new Object[]{zkNode, "/"});
            }
            this.sNodeStr = StringUtil.merge((Object[])new Object[]{zkNode, serverName, "-", serverHost, "-", serverPort, " "});
            if (this.zkBase.isExistNode(serverName, serverHost, serverPort)) {
                throw new RuntimeException(StringUtil.merge((Object[])new Object[]{"Server already register ! (name: ", serverName, " , host : ", serverHost, " , port : ", serverPort, ")"}));
            }
            ZkServerNode zkSNObj = new ZkServerNode(serverName, serverHost, serverPort);
            if (ObjectUtil.isNotNull((Object)configuration)) {
                if (ObjectUtil.isNotNull((Object)configuration.getTransportFactory())) {
                    zkSNObj.setTransportFactoryClassName(configuration.getTransportFactory().getClass().getName());
                }
                if (ObjectUtil.isNotNull((Object)configuration.getProtocolFactory())) {
                    zkSNObj.setTransportFactoryClassName(configuration.getProtocolFactory().getClass().getName());
                }
                if (ObjectUtil.isNotNull((Object)configuration.getProcessorFactory())) {
                    zkSNObj.setTransportFactoryClassName(configuration.getProcessorFactory().getClass().getName());
                }
            }
            Optional.ofNullable(processor).ifPresent(p -> zkSNObj.setProcessorClassName(p.getClass().getName()));
            log.debug("Create server node : {}", (Object)this.sNodeStr);
            zkClient.createEphemeralSequential(this.sNodeStr, (Object)zkSNObj);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeStop(String serverName, int serverPort, ServerConfiguration configuration, TProcessor processor, ThriftServer server) {
    }

    public void afterStop(String serverName, int serverPort, ServerConfiguration configuration, TProcessor processor, ThriftServer server) {
        if (StringUtil.isNotEmpty((String)this.sNodeStr)) {
            log.debug("Delete server node : {}", (Object)this.sNodeStr);
            this.zkBase.getZkClient().delete(this.sNodeStr);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

